/**
 * Copyright (c) 2010-2012, Zoltan Ujhelyi, Abel Hegedus, Tamas Szabo, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Zoltan Ujhelyi, Abel Hegedus, Tamas Szabo - initial API and implementation
 */
package org.eclipse.viatra.addon.validation.tooling;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.viatra.query.patternlanguage.emf.eMFPatternLanguage.PackageImport;
import org.eclipse.viatra.query.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.viatra.query.patternlanguage.emf.helper.EMFPatternLanguageHelper;
import org.eclipse.viatra.query.patternlanguage.emf.util.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.viatra.query.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Annotation;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.AnnotationParameter;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.ListValue;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Pattern;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.StringValue;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.ValueReference;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Variable;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.VariableReference;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.VariableValue;
import org.eclipse.viatra.query.tooling.core.generator.ExtensionData;
import org.eclipse.viatra.query.tooling.core.generator.ExtensionGenerator;
import org.eclipse.viatra.query.tooling.core.generator.fragments.IGenerationFragment;
import org.eclipse.viatra.query.tooling.core.generator.genmodel.IVQGenmodelProvider;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.w3c.dom.Element;

@SuppressWarnings("all")
public class ValidationGenerator implements IGenerationFragment {
  @Inject
  @Extension
  private EMFPatternLanguageJvmModelInferrerUtil _eMFPatternLanguageJvmModelInferrerUtil;
  
  @Inject
  private IVQGenmodelProvider vqGenModelProvider;
  
  @Inject
  @Extension
  private ExtensionGenerator exGen;
  
  private static String VALIDATIONEXTENSION_PREFIX = "validation.constraint.";
  
  private static String UI_VALIDATION_MENUS_PREFIX = "generated.viatra.addon.validation.menu.";
  
  private static String VALIDATION_EXTENSION_POINT = "org.eclipse.viatra.addon.validation.runtime.constraint";
  
  private static String ECLIPSE_MENUS_EXTENSION_POINT = "org.eclipse.ui.menus";
  
  private static String annotationLiteral = "Constraint";
  
  @Override
  public void generateFiles(final Pattern pattern, final IFileSystemAccess fsa) {
    EList<Annotation> _annotations = pattern.getAnnotations();
    for (final Annotation ann : _annotations) {
      String _name = ann.getName();
      boolean _equals = Objects.equal(_name, ValidationGenerator.annotationLiteral);
      if (_equals) {
        String _constraintClassJavaFile = this.constraintClassJavaFile(pattern, ann);
        CharSequence _patternHandler = this.patternHandler(pattern, ann);
        fsa.generateFile(_constraintClassJavaFile, _patternHandler);
      }
    }
  }
  
  @Override
  public void cleanUp(final Pattern pattern, final IFileSystemAccess fsa) {
    EList<Annotation> _annotations = pattern.getAnnotations();
    for (final Annotation ann : _annotations) {
      String _name = ann.getName();
      boolean _equals = Objects.equal(_name, ValidationGenerator.annotationLiteral);
      if (_equals) {
        String _constraintClassJavaFile = this.constraintClassJavaFile(pattern, ann);
        fsa.deleteFile(_constraintClassJavaFile);
      }
    }
  }
  
  @Override
  public Iterable<Pair<String, String>> removeExtension(final Pattern pattern) {
    String _constraintContributionId = this.constraintContributionId(pattern);
    final Pair<String, String> p = Pair.<String, String>of(_constraintContributionId, ValidationGenerator.VALIDATION_EXTENSION_POINT);
    final ArrayList<Pair<String, String>> extensionList = CollectionLiterals.<Pair<String, String>>newArrayList(p);
    EObject _eContainer = pattern.eContainer();
    final PatternModel patternModel = ((PatternModel) _eContainer);
    Iterable<PackageImport> _packageImportsIterable = EMFPatternLanguageHelper.getPackageImportsIterable(patternModel);
    for (final PackageImport imp : _packageImportsIterable) {
      {
        final EPackage pack = imp.getEPackage();
        final GenPackage genPackage = this.vqGenModelProvider.findGenPackage(pattern, pack);
        boolean _notEquals = (!Objects.equal(genPackage, null));
        if (_notEquals) {
          String _qualifiedEditorClassName = genPackage.getQualifiedEditorClassName();
          final String editorId = (_qualifiedEditorClassName + "ID");
          boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(editorId);
          boolean _not = (!_isNullOrEmpty);
          if (_not) {
            String _menuContributionId = this.menuContributionId(editorId);
            Pair<String, String> _of = Pair.<String, String>of(_menuContributionId, ValidationGenerator.ECLIPSE_MENUS_EXTENSION_POINT);
            extensionList.add(_of);
          }
        }
      }
    }
    EList<Annotation> _annotations = pattern.getAnnotations();
    for (final Annotation ann : _annotations) {
      String _name = ann.getName();
      boolean _equals = Objects.equal(_name, ValidationGenerator.annotationLiteral);
      if (_equals) {
        final ArrayList<ValueReference> editorIds = this.getAnnotationParameterValue(ann, "targetEditorId");
        for (final ValueReference id : editorIds) {
          {
            final String editorId = ((StringValue) id).getValue();
            String _menuContributionId = this.menuContributionId(editorId);
            Pair<String, String> _of = Pair.<String, String>of(_menuContributionId, ValidationGenerator.ECLIPSE_MENUS_EXTENSION_POINT);
            extensionList.add(_of);
          }
        }
      }
    }
    return extensionList;
  }
  
  @Override
  public Collection<Pair<String, String>> getRemovableExtensions() {
    Pair<String, String> _of = Pair.<String, String>of(ValidationGenerator.VALIDATIONEXTENSION_PREFIX, ValidationGenerator.VALIDATION_EXTENSION_POINT);
    Pair<String, String> _of_1 = Pair.<String, String>of(ValidationGenerator.UI_VALIDATION_MENUS_PREFIX, ValidationGenerator.ECLIPSE_MENUS_EXTENSION_POINT);
    return CollectionLiterals.<Pair<String, String>>newArrayList(_of, _of_1);
  }
  
  @Override
  public String[] getProjectDependencies() {
    return ((String[])Conversions.unwrapArray(CollectionLiterals.<String>newArrayList(
      "com.google.guava", 
      "org.eclipse.viatra.query.runtime", 
      "org.eclipse.viatra.addon.validation.core"), String.class));
  }
  
  @Override
  public String getProjectPostfix() {
    return "validation";
  }
  
  @Override
  public Iterable<ExtensionData> extensionContribution(final Pattern pattern) {
    String _constraintContributionId = this.constraintContributionId(pattern);
    final Procedure1<Element> _function = new Procedure1<Element>() {
      @Override
      public void apply(final Element it) {
        EList<Annotation> _annotations = pattern.getAnnotations();
        for (final Annotation ann : _annotations) {
          String _name = ann.getName();
          boolean _equals = Objects.equal(_name, ValidationGenerator.annotationLiteral);
          if (_equals) {
            final Procedure1<Element> _function = new Procedure1<Element>() {
              @Override
              public void apply(final Element it) {
                String _constraintClassName = ValidationGenerator.this.constraintClassName(pattern, ann);
                ValidationGenerator.this.exGen.contribAttribute(it, "class", _constraintClassName);
                String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
                ValidationGenerator.this.exGen.contribAttribute(it, "name", _fullyQualifiedName);
                final ArrayList<ValueReference> editorIds = ValidationGenerator.this.getAnnotationParameterValue(ann, "targetEditorId");
                for (final ValueReference id : editorIds) {
                  {
                    final String editorId = ((StringValue) id).getValue();
                    final Procedure1<Element> _function = new Procedure1<Element>() {
                      @Override
                      public void apply(final Element it) {
                        ValidationGenerator.this.exGen.contribAttribute(it, "editorId", editorId);
                      }
                    };
                    ValidationGenerator.this.exGen.contribElement(it, "enabledForEditor", _function);
                  }
                }
                EObject _eContainer = pattern.eContainer();
                final PatternModel patternModel = ((PatternModel) _eContainer);
                Iterable<PackageImport> _packageImportsIterable = EMFPatternLanguageHelper.getPackageImportsIterable(patternModel);
                for (final PackageImport imp : _packageImportsIterable) {
                  {
                    final EPackage pack = imp.getEPackage();
                    final GenPackage genPackage = ValidationGenerator.this.vqGenModelProvider.findGenPackage(pattern, pack);
                    boolean _notEquals = (!Objects.equal(genPackage, null));
                    if (_notEquals) {
                      String _qualifiedEditorClassName = genPackage.getQualifiedEditorClassName();
                      final String editorId = (_qualifiedEditorClassName + "ID");
                      final Procedure1<Element> _function = new Procedure1<Element>() {
                        @Override
                        public void apply(final Element it) {
                          ValidationGenerator.this.exGen.contribAttribute(it, "editorId", editorId);
                        }
                      };
                      ValidationGenerator.this.exGen.contribElement(it, "enabledForEditor", _function);
                    }
                  }
                }
              }
            };
            ValidationGenerator.this.exGen.contribElement(it, "constraint", _function);
          }
        }
      }
    };
    ExtensionData _contribExtension = this.exGen.contribExtension(_constraintContributionId, ValidationGenerator.VALIDATION_EXTENSION_POINT, _function);
    final ArrayList<ExtensionData> extensionList = CollectionLiterals.<ExtensionData>newArrayList(_contribExtension);
    return extensionList;
  }
  
  public String constraintClassName(final Pattern pattern, final Annotation annotation) {
    String _packageName = this._eMFPatternLanguageJvmModelInferrerUtil.getPackageName(pattern);
    String _realPatternName = this._eMFPatternLanguageJvmModelInferrerUtil.realPatternName(pattern);
    String _firstUpper = StringExtensions.toFirstUpper(_realPatternName);
    EList<Annotation> _annotations = pattern.getAnnotations();
    int _indexOf = _annotations.indexOf(annotation);
    return String.format("%s.%s%s%s", _packageName, _firstUpper, ValidationGenerator.annotationLiteral, Integer.valueOf(_indexOf));
  }
  
  public String constraintClassPath(final Pattern pattern, final Annotation annotation) {
    String _packagePath = this._eMFPatternLanguageJvmModelInferrerUtil.getPackagePath(pattern);
    String _realPatternName = this._eMFPatternLanguageJvmModelInferrerUtil.realPatternName(pattern);
    String _firstUpper = StringExtensions.toFirstUpper(_realPatternName);
    EList<Annotation> _annotations = pattern.getAnnotations();
    int _indexOf = _annotations.indexOf(annotation);
    return String.format("%s/%s%s%s", _packagePath, _firstUpper, ValidationGenerator.annotationLiteral, Integer.valueOf(_indexOf));
  }
  
  public String constraintClassJavaFile(final Pattern pattern, final Annotation annotation) {
    String _constraintClassPath = this.constraintClassPath(pattern, annotation);
    return (_constraintClassPath + ".java");
  }
  
  public String constraintContributionId(final Pattern pattern) {
    String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
    return (ValidationGenerator.VALIDATIONEXTENSION_PREFIX + _fullyQualifiedName);
  }
  
  public String menuContributionId(final String editorId) {
    return String.format("%s%s", ValidationGenerator.UI_VALIDATION_MENUS_PREFIX, editorId);
  }
  
  public String getElementOfConstraintAnnotation(final Annotation annotation, final String elementName) {
    final ValueReference ap = CorePatternLanguageHelper.getFirstAnnotationParameter(annotation, elementName);
    String _switchResult = null;
    boolean _matched = false;
    if (ap instanceof StringValue) {
      _matched=true;
      _switchResult = ((StringValue)ap).getValue();
    }
    if (!_matched) {
      if (ap instanceof VariableValue) {
        _matched=true;
        VariableReference _value = ((VariableValue)ap).getValue();
        _switchResult = _value.getVar();
      }
    }
    if (!_matched) {
      _switchResult = null;
    }
    return _switchResult;
  }
  
  public ArrayList<ValueReference> getAnnotationParameterValue(final Annotation annotation, final String elementName) {
    final ArrayList<ValueReference> values = CollectionLiterals.<ValueReference>newArrayList();
    EList<AnnotationParameter> _parameters = annotation.getParameters();
    for (final AnnotationParameter ap : _parameters) {
      String _name = ap.getName();
      boolean _matches = _name.matches(elementName);
      if (_matches) {
        ValueReference _value = ap.getValue();
        values.add(_value);
      }
    }
    return values;
  }
  
  @Override
  public IPath[] getAdditionalBinIncludes() {
    Path _path = new Path("plugin.xml");
    return ((IPath[])Conversions.unwrapArray(CollectionLiterals.<IPath>newArrayList(_path), IPath.class));
  }
  
  public CharSequence patternHandler(final Pattern pattern, final Annotation annotation) {
    CharSequence _xblockexpression = null;
    {
      String _name = pattern.getName();
      String _firstUpper = StringExtensions.toFirstUpper(_name);
      String _plus = (_firstUpper + ValidationGenerator.annotationLiteral);
      EList<Annotation> _annotations = pattern.getAnnotations();
      int _indexOf = _annotations.indexOf(annotation);
      final String className = (_plus + Integer.valueOf(_indexOf));
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("/**");
      _builder.newLine();
      String _fileComment = this._eMFPatternLanguageJvmModelInferrerUtil.getFileComment(pattern);
      _builder.append(_fileComment, "");
      _builder.newLineIfNotEmpty();
      _builder.append("*/");
      _builder.newLine();
      _builder.append("package ");
      String _packageName = this._eMFPatternLanguageJvmModelInferrerUtil.getPackageName(pattern);
      _builder.append(_packageName, "");
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("import java.util.List;");
      _builder.newLine();
      _builder.append("import java.util.Map;");
      _builder.newLine();
      _builder.append("import java.util.Set;");
      _builder.newLine();
      _builder.append("import com.google.common.collect.ImmutableList;");
      _builder.newLine();
      _builder.append("import com.google.common.collect.ImmutableMap;");
      _builder.newLine();
      _builder.append("import com.google.common.collect.ImmutableSet;");
      _builder.newLine();
      _builder.newLine();
      _builder.append("import org.eclipse.viatra.addon.validation.core.api.Severity;");
      _builder.newLine();
      _builder.append("import org.eclipse.viatra.addon.validation.core.api.IConstraintSpecification;");
      _builder.newLine();
      _builder.append("import org.eclipse.viatra.query.runtime.api.IPatternMatch;");
      _builder.newLine();
      _builder.append("import org.eclipse.viatra.query.runtime.api.IQuerySpecification;");
      _builder.newLine();
      _builder.append("import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;");
      _builder.newLine();
      _builder.append("import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;");
      _builder.newLine();
      _builder.newLine();
      _builder.append("import ");
      String _utilPackageName = this._eMFPatternLanguageJvmModelInferrerUtil.getUtilPackageName(pattern);
      String _plus_1 = (_utilPackageName + ".");
      String _querySpecificationClassName = this._eMFPatternLanguageJvmModelInferrerUtil.querySpecificationClassName(pattern);
      String _plus_2 = (_plus_1 + _querySpecificationClassName);
      _builder.append(_plus_2, "");
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("public class ");
      _builder.append(className, "");
      _builder.append(" implements IConstraintSpecification {");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("    ");
      _builder.append("private ");
      String _querySpecificationClassName_1 = this._eMFPatternLanguageJvmModelInferrerUtil.querySpecificationClassName(pattern);
      _builder.append(_querySpecificationClassName_1, "    ");
      _builder.append(" querySpecification;");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("    ");
      _builder.append("public ");
      _builder.append(className, "    ");
      _builder.append("() throws ViatraQueryException {");
      _builder.newLineIfNotEmpty();
      _builder.append("        ");
      _builder.append("querySpecification = ");
      String _querySpecificationClassName_2 = this._eMFPatternLanguageJvmModelInferrerUtil.querySpecificationClassName(pattern);
      _builder.append(_querySpecificationClassName_2, "        ");
      _builder.append(".instance();");
      _builder.newLineIfNotEmpty();
      _builder.append("    ");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("    ");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("    ");
      _builder.append("public String getMessageFormat() {");
      _builder.newLine();
      _builder.append("        ");
      _builder.append("return \"");
      String _elementOfConstraintAnnotation = this.getElementOfConstraintAnnotation(annotation, "message");
      String _convertToJavaString = Strings.convertToJavaString(_elementOfConstraintAnnotation);
      _builder.append(_convertToJavaString, "        ");
      _builder.append("\";");
      _builder.newLineIfNotEmpty();
      _builder.append("    ");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.newLine();
      _builder.append("    ");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("    ");
      _builder.append("public Map<String,Object> getKeyObjects(IPatternMatch signature) {");
      _builder.newLine();
      _builder.append("        ");
      _builder.append("Map<String,Object> map = ImmutableMap.of(");
      _builder.newLine();
      {
        ImmutableList<String> _keyList = this.getKeyList(pattern, annotation);
        boolean _hasElements = false;
        for(final String key : _keyList) {
          if (!_hasElements) {
            _hasElements = true;
          } else {
            _builder.appendImmediate(",", "            ");
          }
          _builder.append("            ");
          _builder.append("\"");
          _builder.append(key, "            ");
          _builder.append("\",signature.get(\"");
          _builder.append(key, "            ");
          _builder.append("\")");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.append("        ");
      _builder.append(");");
      _builder.newLine();
      _builder.append("        ");
      _builder.append("return map;");
      _builder.newLine();
      _builder.append("    ");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("    ");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("    ");
      _builder.append("public List<String> getKeyNames() {");
      _builder.newLine();
      _builder.append("        ");
      _builder.append("List<String> keyNames = ImmutableList.of(");
      _builder.newLine();
      {
        ImmutableList<String> _keyList_1 = this.getKeyList(pattern, annotation);
        boolean _hasElements_1 = false;
        for(final String key_1 : _keyList_1) {
          if (!_hasElements_1) {
            _hasElements_1 = true;
          } else {
            _builder.appendImmediate(",", "            ");
          }
          _builder.append("            ");
          _builder.append("\"");
          _builder.append(key_1, "            ");
          _builder.append("\"");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.append("        ");
      _builder.append(");");
      _builder.newLine();
      _builder.append("        ");
      _builder.append("return keyNames;");
      _builder.newLine();
      _builder.append("    ");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("    ");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("    ");
      _builder.append("public List<String> getPropertyNames() {");
      _builder.newLine();
      _builder.append("        ");
      _builder.append("List<String> propertyNames = ImmutableList.of(");
      _builder.newLine();
      {
        ImmutableList<String> _propertyList = this.getPropertyList(pattern, annotation);
        boolean _hasElements_2 = false;
        for(final String property : _propertyList) {
          if (!_hasElements_2) {
            _hasElements_2 = true;
          } else {
            _builder.appendImmediate(",", "            ");
          }
          _builder.append("            ");
          _builder.append("\"");
          _builder.append(property, "            ");
          _builder.append("\"");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.append("        ");
      _builder.append(");");
      _builder.newLine();
      _builder.append("        ");
      _builder.append("return propertyNames;");
      _builder.newLine();
      _builder.append("    ");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("    ");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("    ");
      _builder.append("public Set<List<String>> getSymmetricPropertyNames() {");
      _builder.newLine();
      _builder.append("        ");
      _builder.append("Set<List<String>> symmetricPropertyNamesSet = ImmutableSet.<List<String>>of(");
      _builder.newLine();
      _builder.append("            ");
      ImmutableSet<ImmutableList<String>> _symmetricList = this.getSymmetricList(pattern, annotation);
      final Function1<ImmutableList<String>, Boolean> _function = new Function1<ImmutableList<String>, Boolean>() {
        @Override
        public Boolean apply(final ImmutableList<String> it) {
          ImmutableList<String> _keyList = ValidationGenerator.this.getKeyList(pattern, annotation);
          boolean _containsAll = _keyList.containsAll(it);
          return Boolean.valueOf((!_containsAll));
        }
      };
      final Iterable<ImmutableList<String>> symmetricProperties = IterableExtensions.<ImmutableList<String>>filter(_symmetricList, _function);
      _builder.newLineIfNotEmpty();
      {
        boolean _hasElements_3 = false;
        for(final ImmutableList<String> propertyList : symmetricProperties) {
          if (!_hasElements_3) {
            _hasElements_3 = true;
          } else {
            _builder.appendImmediate(",", "            ");
          }
          _builder.append("            ");
          _builder.append("ImmutableList.of(");
          _builder.newLine();
          {
            boolean _hasElements_4 = false;
            for(final String property_1 : propertyList) {
              if (!_hasElements_4) {
                _hasElements_4 = true;
              } else {
                _builder.appendImmediate(",", "            ");
              }
              _builder.append("            ");
              _builder.append("\"");
              _builder.append(property_1, "            ");
              _builder.append("\"");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("            ");
          _builder.append(")");
          _builder.newLine();
        }
      }
      _builder.append("        ");
      _builder.append(");");
      _builder.newLine();
      _builder.append("        ");
      _builder.append("return symmetricPropertyNamesSet;");
      _builder.newLine();
      _builder.append("    ");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("    ");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("    ");
      _builder.append("public Set<List<String>> getSymmetricKeyNames() {");
      _builder.newLine();
      _builder.append("        ");
      _builder.append("Set<List<String>> symmetricKeyNamesSet = ImmutableSet.<List<String>>of(");
      _builder.newLine();
      _builder.append("            ");
      ImmutableSet<ImmutableList<String>> _symmetricList_1 = this.getSymmetricList(pattern, annotation);
      final Function1<ImmutableList<String>, Boolean> _function_1 = new Function1<ImmutableList<String>, Boolean>() {
        @Override
        public Boolean apply(final ImmutableList<String> it) {
          ImmutableList<String> _keyList = ValidationGenerator.this.getKeyList(pattern, annotation);
          return Boolean.valueOf(_keyList.containsAll(it));
        }
      };
      final Iterable<ImmutableList<String>> symmetricKeys = IterableExtensions.<ImmutableList<String>>filter(_symmetricList_1, _function_1);
      _builder.newLineIfNotEmpty();
      {
        boolean _hasElements_5 = false;
        for(final ImmutableList<String> symmetricKeyList : symmetricKeys) {
          if (!_hasElements_5) {
            _hasElements_5 = true;
          } else {
            _builder.appendImmediate(",", "            ");
          }
          _builder.append("            ");
          _builder.append("ImmutableList.of(");
          _builder.newLine();
          {
            boolean _hasElements_6 = false;
            for(final String key_2 : symmetricKeyList) {
              if (!_hasElements_6) {
                _hasElements_6 = true;
              } else {
                _builder.appendImmediate(",", "            ");
              }
              _builder.append("            ");
              _builder.append("\"");
              _builder.append(key_2, "            ");
              _builder.append("\"");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("            ");
          _builder.append(")");
          _builder.newLine();
        }
      }
      _builder.append("        ");
      _builder.append(");");
      _builder.newLine();
      _builder.append("        ");
      _builder.append("return symmetricKeyNamesSet;");
      _builder.newLine();
      _builder.append("    ");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("    ");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("    ");
      _builder.append("public Severity getSeverity() {");
      _builder.newLine();
      _builder.append("        ");
      _builder.append("return Severity.");
      String _elementOfConstraintAnnotation_1 = this.getElementOfConstraintAnnotation(annotation, "severity");
      String _upperCase = _elementOfConstraintAnnotation_1.toUpperCase();
      _builder.append(_upperCase, "        ");
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.append("    ");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("    ");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("    ");
      _builder.append("public IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>> getQuerySpecification() {");
      _builder.newLine();
      _builder.append("        ");
      _builder.append("return querySpecification;");
      _builder.newLine();
      _builder.append("    ");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("}");
      _builder.newLine();
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
  
  public ImmutableList<String> getKeyList(final Pattern pattern, final Annotation annotation) {
    ImmutableList<String> _xblockexpression = null;
    {
      ValueReference _firstAnnotationParameter = CorePatternLanguageHelper.getFirstAnnotationParameter(annotation, "key");
      final EList<ValueReference> keyParamValues = ((ListValue) _firstAnnotationParameter).getValues();
      ImmutableList.Builder<String> _builder = ImmutableList.<String>builder();
      final Function1<ValueReference, String> _function = new Function1<ValueReference, String>() {
        @Override
        public String apply(final ValueReference it) {
          return ValidationGenerator.this.getNameOfParameterFromValueReference(it);
        }
      };
      List<String> _map = ListExtensions.<ValueReference, String>map(keyParamValues, _function);
      ImmutableList.Builder<String> _addAll = _builder.addAll(_map);
      _xblockexpression = _addAll.build();
    }
    return _xblockexpression;
  }
  
  public ImmutableList<String> getPropertyList(final Pattern pattern, final Annotation annotation) {
    ImmutableList<String> _xblockexpression = null;
    {
      EList<Variable> _parameters = pattern.getParameters();
      final Function1<Variable, String> _function = new Function1<Variable, String>() {
        @Override
        public String apply(final Variable it) {
          return it.getName();
        }
      };
      final List<String> parameters = ListExtensions.<Variable, String>map(_parameters, _function);
      ValueReference _firstAnnotationParameter = CorePatternLanguageHelper.getFirstAnnotationParameter(annotation, "key");
      final EList<ValueReference> keyParamValues = ((ListValue) _firstAnnotationParameter).getValues();
      final Function1<ValueReference, String> _function_1 = new Function1<ValueReference, String>() {
        @Override
        public String apply(final ValueReference it) {
          return ValidationGenerator.this.getNameOfParameterFromValueReference(it);
        }
      };
      final List<String> keys = ListExtensions.<ValueReference, String>map(keyParamValues, _function_1);
      final Function1<String, Boolean> _function_2 = new Function1<String, Boolean>() {
        @Override
        public Boolean apply(final String it) {
          boolean _contains = keys.contains(it);
          return Boolean.valueOf((!_contains));
        }
      };
      Iterable<String> _filter = IterableExtensions.<String>filter(parameters, _function_2);
      _xblockexpression = ImmutableList.<String>copyOf(_filter);
    }
    return _xblockexpression;
  }
  
  public ImmutableSet<ImmutableList<String>> getSymmetricList(final Pattern pattern, final Annotation annotation) {
    ImmutableSet<ImmutableList<String>> _xblockexpression = null;
    {
      final Collection<ValueReference> symmetricParams = CorePatternLanguageHelper.getAnnotationParameters(annotation, "symmetric");
      final Function1<ValueReference, ImmutableList<String>> _function = new Function1<ValueReference, ImmutableList<String>>() {
        @Override
        public ImmutableList<String> apply(final ValueReference it) {
          EList<ValueReference> _values = ((ListValue) it).getValues();
          final Function1<ValueReference, String> _function = new Function1<ValueReference, String>() {
            @Override
            public String apply(final ValueReference it) {
              return ValidationGenerator.this.getNameOfParameterFromValueReference(it);
            }
          };
          List<String> _map = ListExtensions.<ValueReference, String>map(_values, _function);
          return ImmutableList.<String>copyOf(_map);
        }
      };
      final Iterable<ImmutableList<String>> symmetryLists = IterableExtensions.<ValueReference, ImmutableList<String>>map(symmetricParams, _function);
      _xblockexpression = ImmutableSet.<ImmutableList<String>>copyOf(symmetryLists);
    }
    return _xblockexpression;
  }
  
  public String getNameOfParameterFromValueReference(final ValueReference ref) {
    String _xifexpression = null;
    if ((ref instanceof StringValue)) {
      _xifexpression = ((StringValue)ref).getValue();
    } else {
      String _xifexpression_1 = null;
      if ((ref instanceof VariableValue)) {
        VariableReference _value = ((VariableValue)ref).getValue();
        Variable _variable = _value.getVariable();
        _xifexpression_1 = _variable.getName();
      } else {
        _xifexpression_1 = ref.toString();
      }
      _xifexpression = _xifexpression_1;
    }
    return _xifexpression;
  }
}
