/**
 * 
 *   Copyright (c) 2010-2015, Csaba Debreceni, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *     Csaba Debreceni - initial API and implementation
 *  
 */
package org.eclipse.viatra.addon.viewers.runtime.model.patterns;

import org.eclipse.viatra.addon.viewers.runtime.model.patterns.ChildrenMatcher;
import org.eclipse.viatra.addon.viewers.runtime.model.patterns.Param2containmentMatcher;
import org.eclipse.viatra.addon.viewers.runtime.model.patterns.Param2edgeMatcher;
import org.eclipse.viatra.addon.viewers.runtime.model.patterns.Param2itemMatcher;
import org.eclipse.viatra.addon.viewers.runtime.model.patterns.util.ChildrenQuerySpecification;
import org.eclipse.viatra.addon.viewers.runtime.model.patterns.util.Param2containmentQuerySpecification;
import org.eclipse.viatra.addon.viewers.runtime.model.patterns.util.Param2edgeQuerySpecification;
import org.eclipse.viatra.addon.viewers.runtime.model.patterns.util.Param2itemQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedPatternGroup;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;

/**
 * A pattern group formed of all patterns defined in ViewersTraceabilityQueries.vql.
 * 
 * <p>Use the static instance as any {@link org.eclipse.viatra.query.runtime.api.IPatternGroup}, to conveniently prepare
 * a VIATRA Query engine for matching all patterns originally defined in file ViewersTraceabilityQueries.vql,
 * in order to achieve better performance than one-by-one on-demand matcher initialization.
 * 
 * <p> From package org.eclipse.viatra.addon.viewers.runtime.model.patterns, the group contains the definition of the following patterns: <ul>
 * <li>param2item</li>
 * <li>param2edge</li>
 * <li>param2containment</li>
 * <li>children</li>
 * </ul>
 * 
 * @see IPatternGroup
 * 
 */
@SuppressWarnings("all")
public final class ViewersTraceabilityQueries extends BaseGeneratedPatternGroup {
  /**
   * Access the pattern group.
   * 
   * @return the singleton instance of the group
   * @throws ViatraQueryException if there was an error loading the generated code of pattern specifications
   * 
   */
  public static ViewersTraceabilityQueries instance() throws ViatraQueryException {
    if (INSTANCE == null) {
    	INSTANCE = new ViewersTraceabilityQueries();
    }
    return INSTANCE;
  }
  
  private static ViewersTraceabilityQueries INSTANCE;
  
  private ViewersTraceabilityQueries() throws ViatraQueryException {
    querySpecifications.add(Param2itemQuerySpecification.instance());
    querySpecifications.add(Param2edgeQuerySpecification.instance());
    querySpecifications.add(Param2containmentQuerySpecification.instance());
    querySpecifications.add(ChildrenQuerySpecification.instance());
  }
  
  public Param2itemQuerySpecification getParam2item() throws ViatraQueryException {
    return Param2itemQuerySpecification.instance();
  }
  
  public Param2itemMatcher getParam2item(final ViatraQueryEngine engine) throws ViatraQueryException {
    return Param2itemMatcher.on(engine);
  }
  
  public Param2edgeQuerySpecification getParam2edge() throws ViatraQueryException {
    return Param2edgeQuerySpecification.instance();
  }
  
  public Param2edgeMatcher getParam2edge(final ViatraQueryEngine engine) throws ViatraQueryException {
    return Param2edgeMatcher.on(engine);
  }
  
  public Param2containmentQuerySpecification getParam2containment() throws ViatraQueryException {
    return Param2containmentQuerySpecification.instance();
  }
  
  public Param2containmentMatcher getParam2containment(final ViatraQueryEngine engine) throws ViatraQueryException {
    return Param2containmentMatcher.on(engine);
  }
  
  public ChildrenQuerySpecification getChildren() throws ViatraQueryException {
    return ChildrenQuerySpecification.instance();
  }
  
  public ChildrenMatcher getChildren(final ViatraQueryEngine engine) throws ViatraQueryException {
    return ChildrenMatcher.on(engine);
  }
}
