/**
 * 
 *   Copyright (c) 2010-2015, Csaba Debreceni, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *     Csaba Debreceni - initial API and implementation
 *  
 */
package org.eclipse.viatra.addon.viewers.runtime.model.patterns.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.viatra.addon.viewers.runtime.model.patterns.ChildrenMatch;
import org.eclipse.viatra.addon.viewers.runtime.model.patterns.ChildrenMatcher;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameterDirection;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.viatra.query.runtime.matchers.tuple.FlatTuple;

/**
 * A pattern-specific query specification that can instantiate ChildrenMatcher in a type-safe way.
 * 
 * @see ChildrenMatcher
 * @see ChildrenMatch
 * 
 */
@SuppressWarnings("all")
public final class ChildrenQuerySpecification extends BaseGeneratedEMFQuerySpecification<ChildrenMatcher> {
  private ChildrenQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws ViatraQueryException if the pattern definition could not be loaded
   * 
   */
  public static ChildrenQuerySpecification instance() throws ViatraQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected ChildrenMatcher instantiate(final ViatraQueryEngine engine) throws ViatraQueryException {
    return ChildrenMatcher.on(engine);
  }
  
  @Override
  public ChildrenMatcher instantiate() throws ViatraQueryException {
    return ChildrenMatcher.create();
  }
  
  @Override
  public ChildrenMatch newEmptyMatch() {
    return ChildrenMatch.newEmptyMatch();
  }
  
  @Override
  public ChildrenMatch newMatch(final Object... parameters) {
    return ChildrenMatch.newMatch((org.eclipse.viatra.addon.viewers.runtime.notation.Item) parameters[0], (org.eclipse.viatra.addon.viewers.runtime.notation.Item) parameters[1]);
  }
  
  /**
   * Inner class allowing the singleton instance of {@link ChildrenQuerySpecification} to be created 
   * 	<b>not</b> at the class load time of the outer class, 
   * 	but rather at the first call to {@link ChildrenQuerySpecification#instance()}.
   * 
   * <p> This workaround is required e.g. to support recursion.
   * 
   */
  private static class LazyHolder {
    private final static ChildrenQuerySpecification INSTANCE = new ChildrenQuerySpecification();
    
    /**
     * Statically initializes the query specification <b>after</b> the field {@link #INSTANCE} is assigned.
     * This initialization order is required to support indirect recursion.
     * 
     * <p> The static initializer is defined using a helper field to work around limitations of the code generator.
     * 
     */
    private final static Object STATIC_INITIALIZER = ensureInitialized();
    
    public static Object ensureInitialized() {
      INSTANCE.ensureInitializedInternalSneaky();
      return null;
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static ChildrenQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    private final PParameter parameter_pParent = new PParameter("parent", "org.eclipse.viatra.addon.viewers.runtime.notation.Item", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("http://www.eclipse.org/viatra/addon/viewers/notation/1.0", "Item")), PParameterDirection.INOUT);
    
    private final PParameter parameter_pChild = new PParameter("child", "org.eclipse.viatra.addon.viewers.runtime.notation.Item", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("http://www.eclipse.org/viatra/addon/viewers/notation/1.0", "Item")), PParameterDirection.INOUT);
    
    private final List<PParameter> parameters = Arrays.asList(parameter_pParent, parameter_pChild);
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.addon.viewers.runtime.model.patterns.children";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("parent","child");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return parameters;
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      setEvaluationHints(new QueryEvaluationHint(null, Collections.<String,Object>emptyMap()));
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_parent = body.getOrCreateVariableByName("parent");
      		PVariable var_child = body.getOrCreateVariableByName("child");
      		PVariable var_c = body.getOrCreateVariableByName("c");
      		new TypeConstraint(body, new FlatTuple(var_parent), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/addon/viewers/notation/1.0", "Item")));
      		new TypeConstraint(body, new FlatTuple(var_child), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/addon/viewers/notation/1.0", "Item")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_parent, parameter_pParent),
      		   new ExportedParameter(body, var_child, parameter_pChild)
      		));
      		// 	Containment.source(c, parent)
      		new TypeConstraint(body, new FlatTuple(var_c), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/addon/viewers/notation/1.0", "Containment")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var_c, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/addon/viewers/notation/1.0", "Edge", "source")));
      		new Equality(body, var__virtual_0_, var_parent);
      		// 	Containment.target(c, child)
      		new TypeConstraint(body, new FlatTuple(var_c), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/addon/viewers/notation/1.0", "Containment")));
      		PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      		new TypeConstraint(body, new FlatTuple(var_c, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/addon/viewers/notation/1.0", "Edge", "target")));
      		new Equality(body, var__virtual_1_, var_child);
      		bodies.add(body);
      	}
      	{
      		PAnnotation annotation = new PAnnotation("QueryExplorer");
      		annotation.addAttribute("checked", false);
      		addAnnotation(annotation);
      	}
      	// to silence compiler error
      	if (false) throw new ViatraQueryException("Never", "happens");
      } catch (ViatraQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
