/**
 * 
 *   Copyright (c) 2010-2015, Csaba Debreceni, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *     Csaba Debreceni - initial API and implementation
 *  
 */
package org.eclipse.viatra.addon.viewers.runtime.model.patterns.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.viatra.addon.viewers.runtime.model.patterns.Param2edgeMatch;
import org.eclipse.viatra.addon.viewers.runtime.model.patterns.Param2edgeMatcher;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameterDirection;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.viatra.query.runtime.matchers.tuple.FlatTuple;

/**
 * A pattern-specific query specification that can instantiate Param2edgeMatcher in a type-safe way.
 * 
 * @see Param2edgeMatcher
 * @see Param2edgeMatch
 * 
 */
@SuppressWarnings("all")
public final class Param2edgeQuerySpecification extends BaseGeneratedEMFQuerySpecification<Param2edgeMatcher> {
  private Param2edgeQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws ViatraQueryException if the pattern definition could not be loaded
   * 
   */
  public static Param2edgeQuerySpecification instance() throws ViatraQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected Param2edgeMatcher instantiate(final ViatraQueryEngine engine) throws ViatraQueryException {
    return Param2edgeMatcher.on(engine);
  }
  
  @Override
  public Param2edgeMatcher instantiate() throws ViatraQueryException {
    return Param2edgeMatcher.create();
  }
  
  @Override
  public Param2edgeMatch newEmptyMatch() {
    return Param2edgeMatch.newEmptyMatch();
  }
  
  @Override
  public Param2edgeMatch newMatch(final Object... parameters) {
    return Param2edgeMatch.newMatch((java.lang.Object) parameters[0], (java.lang.Object) parameters[1], (org.eclipse.viatra.transformation.views.traceability.Trace) parameters[2], (org.eclipse.viatra.addon.viewers.runtime.notation.Edge) parameters[3]);
  }
  
  /**
   * Inner class allowing the singleton instance of {@link Param2edgeQuerySpecification} to be created 
   * 	<b>not</b> at the class load time of the outer class, 
   * 	but rather at the first call to {@link Param2edgeQuerySpecification#instance()}.
   * 
   * <p> This workaround is required e.g. to support recursion.
   * 
   */
  private static class LazyHolder {
    private final static Param2edgeQuerySpecification INSTANCE = new Param2edgeQuerySpecification();
    
    /**
     * Statically initializes the query specification <b>after</b> the field {@link #INSTANCE} is assigned.
     * This initialization order is required to support indirect recursion.
     * 
     * <p> The static initializer is defined using a helper field to work around limitations of the code generator.
     * 
     */
    private final static Object STATIC_INITIALIZER = ensureInitialized();
    
    public static Object ensureInitialized() {
      INSTANCE.ensureInitializedInternalSneaky();
      return null;
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static Param2edgeQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    private final PParameter parameter_pSource = new PParameter("source", "java.lang.Object", (IInputKey)null, PParameterDirection.INOUT);
    
    private final PParameter parameter_pTarget = new PParameter("target", "java.lang.Object", (IInputKey)null, PParameterDirection.INOUT);
    
    private final PParameter parameter_pTrace = new PParameter("trace", "org.eclipse.viatra.transformation.views.traceability.Trace", (IInputKey)null, PParameterDirection.INOUT);
    
    private final PParameter parameter_pEdge = new PParameter("edge", "org.eclipse.viatra.addon.viewers.runtime.notation.Edge", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("http://www.eclipse.org/viatra/addon/viewers/notation/1.0", "Edge")), PParameterDirection.INOUT);
    
    private final List<PParameter> parameters = Arrays.asList(parameter_pSource, parameter_pTarget, parameter_pTrace, parameter_pEdge);
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.addon.viewers.runtime.model.patterns.param2edge";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("source","target","trace","edge");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return parameters;
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      setEvaluationHints(new QueryEvaluationHint(null, Collections.<String,Object>emptyMap()));
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_source = body.getOrCreateVariableByName("source");
      		PVariable var_target = body.getOrCreateVariableByName("target");
      		PVariable var_trace = body.getOrCreateVariableByName("trace");
      		PVariable var_edge = body.getOrCreateVariableByName("edge");
      		new TypeConstraint(body, new FlatTuple(var_edge), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/addon/viewers/notation/1.0", "Edge")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_source, parameter_pSource),
      		   new ExportedParameter(body, var_target, parameter_pTarget),
      		   new ExportedParameter(body, var_trace, parameter_pTrace),
      		   new ExportedParameter(body, var_edge, parameter_pEdge)
      		));
      		// 	Trace.params(trace, source)
      		new TypeConstraint(body, new FlatTuple(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var_trace, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace", "params")));
      		new Equality(body, var__virtual_0_, var_source);
      		// 	Trace.params(trace, target)
      		new TypeConstraint(body, new FlatTuple(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
      		PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      		new TypeConstraint(body, new FlatTuple(var_trace, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace", "params")));
      		new Equality(body, var__virtual_1_, var_target);
      		// 	Trace.targets(trace, edge)
      		new TypeConstraint(body, new FlatTuple(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
      		PVariable var__virtual_2_ = body.getOrCreateVariableByName(".virtual{2}");
      		new TypeConstraint(body, new FlatTuple(var_trace, var__virtual_2_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace", "targets")));
      		new Equality(body, var__virtual_2_, var_edge);
      		bodies.add(body);
      	}
      	{
      		PBody body = new PBody(this);
      		PVariable var_source = body.getOrCreateVariableByName("source");
      		PVariable var_target = body.getOrCreateVariableByName("target");
      		PVariable var_trace = body.getOrCreateVariableByName("trace");
      		PVariable var_edge = body.getOrCreateVariableByName("edge");
      		new TypeConstraint(body, new FlatTuple(var_edge), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/addon/viewers/notation/1.0", "Edge")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_source, parameter_pSource),
      		   new ExportedParameter(body, var_target, parameter_pTarget),
      		   new ExportedParameter(body, var_trace, parameter_pTrace),
      		   new ExportedParameter(body, var_edge, parameter_pEdge)
      		));
      		// 	Trace.objects(trace, source)
      		new TypeConstraint(body, new FlatTuple(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var_trace, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace", "objects")));
      		new Equality(body, var__virtual_0_, var_source);
      		// 	Trace.params(trace, target)
      		new TypeConstraint(body, new FlatTuple(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
      		PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      		new TypeConstraint(body, new FlatTuple(var_trace, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace", "params")));
      		new Equality(body, var__virtual_1_, var_target);
      		// 	Trace.targets(trace, edge)
      		new TypeConstraint(body, new FlatTuple(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
      		PVariable var__virtual_2_ = body.getOrCreateVariableByName(".virtual{2}");
      		new TypeConstraint(body, new FlatTuple(var_trace, var__virtual_2_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace", "targets")));
      		new Equality(body, var__virtual_2_, var_edge);
      		bodies.add(body);
      	}
      	{
      		PBody body = new PBody(this);
      		PVariable var_source = body.getOrCreateVariableByName("source");
      		PVariable var_target = body.getOrCreateVariableByName("target");
      		PVariable var_trace = body.getOrCreateVariableByName("trace");
      		PVariable var_edge = body.getOrCreateVariableByName("edge");
      		new TypeConstraint(body, new FlatTuple(var_edge), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/addon/viewers/notation/1.0", "Edge")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_source, parameter_pSource),
      		   new ExportedParameter(body, var_target, parameter_pTarget),
      		   new ExportedParameter(body, var_trace, parameter_pTrace),
      		   new ExportedParameter(body, var_edge, parameter_pEdge)
      		));
      		// 	Trace.params(trace, source)
      		new TypeConstraint(body, new FlatTuple(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var_trace, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace", "params")));
      		new Equality(body, var__virtual_0_, var_source);
      		// 	Trace.objects(trace, target)
      		new TypeConstraint(body, new FlatTuple(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
      		PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      		new TypeConstraint(body, new FlatTuple(var_trace, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace", "objects")));
      		new Equality(body, var__virtual_1_, var_target);
      		// 	Trace.targets(trace, edge)
      		new TypeConstraint(body, new FlatTuple(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
      		PVariable var__virtual_2_ = body.getOrCreateVariableByName(".virtual{2}");
      		new TypeConstraint(body, new FlatTuple(var_trace, var__virtual_2_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace", "targets")));
      		new Equality(body, var__virtual_2_, var_edge);
      		bodies.add(body);
      	}
      	{
      		PBody body = new PBody(this);
      		PVariable var_source = body.getOrCreateVariableByName("source");
      		PVariable var_target = body.getOrCreateVariableByName("target");
      		PVariable var_trace = body.getOrCreateVariableByName("trace");
      		PVariable var_edge = body.getOrCreateVariableByName("edge");
      		new TypeConstraint(body, new FlatTuple(var_edge), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/addon/viewers/notation/1.0", "Edge")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_source, parameter_pSource),
      		   new ExportedParameter(body, var_target, parameter_pTarget),
      		   new ExportedParameter(body, var_trace, parameter_pTrace),
      		   new ExportedParameter(body, var_edge, parameter_pEdge)
      		));
      		// 	Trace.objects(trace, source)
      		new TypeConstraint(body, new FlatTuple(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var_trace, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace", "objects")));
      		new Equality(body, var__virtual_0_, var_source);
      		// 	Trace.objects(trace, target)
      		new TypeConstraint(body, new FlatTuple(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
      		PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      		new TypeConstraint(body, new FlatTuple(var_trace, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace", "objects")));
      		new Equality(body, var__virtual_1_, var_target);
      		// 	Trace.targets(trace, edge)
      		new TypeConstraint(body, new FlatTuple(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
      		PVariable var__virtual_2_ = body.getOrCreateVariableByName(".virtual{2}");
      		new TypeConstraint(body, new FlatTuple(var_trace, var__virtual_2_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace", "targets")));
      		new Equality(body, var__virtual_2_, var_edge);
      		bodies.add(body);
      	}
      	{
      		PAnnotation annotation = new PAnnotation("QueryExplorer");
      		annotation.addAttribute("checked", false);
      		addAnnotation(annotation);
      	}
      	// to silence compiler error
      	if (false) throw new ViatraQueryException("Never", "happens");
      } catch (ViatraQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
