/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.runtime.zest.extensions;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.gef4.layout.LayoutAlgorithm;
import org.eclipse.gef4.layout.algorithms.CompositeLayoutAlgorithm;
import org.eclipse.gef4.layout.algorithms.HorizontalShiftAlgorithm;
import org.eclipse.gef4.layout.algorithms.RadialLayoutAlgorithm;
import org.eclipse.gef4.layout.algorithms.SpaceTreeLayoutAlgorithm;
import org.eclipse.gef4.layout.algorithms.SpringLayoutAlgorithm;
import org.eclipse.gef4.layout.algorithms.SugiyamaLayoutAlgorithm;
import org.eclipse.gef4.layout.algorithms.TreeLayoutAlgorithm;
import org.eclipse.gef4.zest.core.viewers.GraphViewer;
import org.eclipse.gef4.zest.core.viewers.IZoomableWorkbenchPart;
import org.eclipse.gef4.zest.core.viewers.ZoomContributionViewItem;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IViewPart;
import org.eclipse.viatra.addon.viewers.runtime.extensions.ViewersComponentConfiguration;
import org.eclipse.viatra.addon.viewers.runtime.extensions.jface.ViatraViewersJFaceViewSupport;
import org.eclipse.viatra.addon.viewers.runtime.model.ViatraViewerDataModel;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerDataFilter;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerState;
import org.eclipse.viatra.addon.viewers.runtime.zest.ViatraGraphViewers;
import org.eclipse.viatra.addon.viewers.runtime.zest.ViewersZestPlugin;
import org.eclipse.viatra.query.runtime.api.IModelConnectorTypeEnum;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;

public class ViatraViewersZestViewSupport
extends ViatraViewersJFaceViewSupport {
    private final GraphViewer graphViewer;
    protected Action refreshGraph = new Action("Refresh Graph"){

        public void run() {
            ViatraViewersZestViewSupport.this.getGraphViewer().applyLayout();
            ViatraViewersZestViewSupport.this.getGraphViewer().refresh();
        }
    };
    protected Action clearGraph = new Action("Clear Graph"){

        public void run() {
            ViatraViewersZestViewSupport.this.getGraphViewer().setInput(null);
        }
    };

    public GraphViewer getGraphViewer() {
        return this.graphViewer;
    }

    public ViatraViewersZestViewSupport(IViewPart _owner, ViewersComponentConfiguration _config, IModelConnectorTypeEnum _scope, GraphViewer _graphViewer) {
        super(_owner, _config, _scope, (StructuredViewer)_graphViewer);
        this.graphViewer = _graphViewer;
    }

    protected void init() {
        super.init();
        this.getGraphViewer().setConnectionStyle(2);
        this.getGraphViewer().setLayoutAlgorithm((LayoutAlgorithm)new RadialLayoutAlgorithm());
    }

    protected void bindModel() {
        ViatraQueryEngine engine;
        Assert.isNotNull((Object)this.configuration);
        Assert.isNotNull((Object)this.configuration.getPatterns());
        if (this.state != null && !this.state.isDisposed()) {
            this.state.dispose();
        }
        if ((engine = this.getEngine()) != null) {
            this.state = ViatraViewerDataModel.newViewerState((ViatraQueryEngine)engine, (Collection)this.configuration.getPatterns(), (ViewerDataFilter)this.configuration.getFilter(), (Collection)ImmutableSet.of((Object)ViewerState.ViewerStateFeature.EDGE, (Object)ViewerState.ViewerStateFeature.CONTAINMENT));
            ViatraGraphViewers.bindWithIsolatedNodes((GraphViewer)this.jfaceViewer, this.state);
        }
    }

    public void createToolbar() {
        this.refreshGraph.setImageDescriptor(ViewersZestPlugin.imageDescriptorFromPlugin((String)"org.eclipse.viatra.addon.viewers.runtime.zest", (String)"icons/refresh.gif"));
        this.clearGraph.setImageDescriptor(ViewersZestPlugin.imageDescriptorFromPlugin((String)"org.eclipse.viatra.addon.viewers.runtime.zest", (String)"icons/clear.gif"));
        IToolBarManager toolBarManager = this.getOwner().getViewSite().getActionBars().getToolBarManager();
        toolBarManager.removeAll();
        toolBarManager.add((IAction)this.refreshGraph);
        toolBarManager.add((IAction)this.clearGraph);
        if (this.owner instanceof IZoomableWorkbenchPart) {
            ZoomContributionViewItem toolbarZoomContributionViewItem = new ZoomContributionViewItem((IZoomableWorkbenchPart)this.owner);
            toolBarManager.add((IContributionItem)toolbarZoomContributionViewItem);
            toolBarManager.update(true);
        }
        IMenuManager menuManager = this.getOwner().getViewSite().getActionBars().getMenuManager();
        menuManager.removeAll();
        menuManager.add((IContributionItem)this.createLayoutMenu());
    }

    public MenuManager createLayoutMenu() {
        MenuManager mgr = new MenuManager("Layout");
        mgr.add((IAction)this.createLayoutAction("Tree", (LayoutAlgorithm)new TreeLayoutAlgorithm()));
        mgr.add((IAction)this.createLayoutAction("Spring", (LayoutAlgorithm)new SpringLayoutAlgorithm()));
        mgr.add((IAction)this.createLayoutAction("Radial", (LayoutAlgorithm)new RadialLayoutAlgorithm()));
        mgr.add((IAction)this.createLayoutAction("SpaceTree", (LayoutAlgorithm)new SpaceTreeLayoutAlgorithm()));
        SugiyamaLayoutAlgorithm sugiyamaAlgorithm = new SugiyamaLayoutAlgorithm();
        HorizontalShiftAlgorithm shiftAlgorithm = new HorizontalShiftAlgorithm();
        mgr.add((IAction)this.createLayoutAction("Sugiyama (unstable)", (LayoutAlgorithm)new CompositeLayoutAlgorithm(new LayoutAlgorithm[]{sugiyamaAlgorithm, shiftAlgorithm})));
        return mgr;
    }

    protected Action createLayoutAction(String name, final LayoutAlgorithm lay) {
        return new Action(name){

            public void run() {
                ViatraViewersZestViewSupport.this.getGraphViewer().setLayoutAlgorithm(lay);
                ViatraViewersZestViewSupport.this.getGraphViewer().applyLayout();
            }
        };
    }
}

