/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.runtime.model;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.viatra.addon.viewers.runtime.notation.NotationFactory;
import org.eclipse.viatra.addon.viewers.runtime.notation.NotationModel;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.scope.QueryScope;
import org.eclipse.viatra.query.runtime.base.api.NavigationHelper;
import org.eclipse.viatra.query.runtime.base.exception.ViatraBaseException;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;
import org.eclipse.viatra.transformation.views.core.ViewModelManager;

public abstract class ViewerDataModel {
    private final String NOTATION_RESOURCE = "org.eclipse.viatra.addon.viewers.notation.NotationResource";
    protected NotationModel model;
    protected ViatraQueryEngine engine;

    public ViewerDataModel(ResourceSet notifier) throws ViatraQueryException, ViatraBaseException {
        this(ViatraQueryEngine.on((QueryScope)new EMFScope((Notifier)notifier)));
    }

    public ViewerDataModel(ViatraQueryEngine engine) throws ViatraQueryException, ViatraBaseException {
        if (!(engine.getScope() instanceof EMFScope)) {
            ViatraQueryLoggingUtil.getLogger(ViewModelManager.class).error((Object)"Only EMFScope is supported currently for ViatraQueryEngine");
            return;
        }
        this.model = NotationFactory.eINSTANCE.createNotationModel();
        this.engine = engine;
        this.prepareBaseNotifier();
    }

    private void prepareBaseNotifier() throws ViatraQueryException, ViatraBaseException {
        Collection<? extends Notifier> notifiers = this.getNotifiers();
        Resource resource = null;
        block0: for (Notifier notifier : notifiers) {
            Resource r;
            if (notifier instanceof Resource && this.checkNotationResource(r = (Resource)notifier)) {
                resource = r;
                break;
            }
            if (!(notifier instanceof ResourceSet)) continue;
            ResourceSet resourceSet = (ResourceSet)notifier;
            for (Resource r2 : resourceSet.getResources()) {
                if (!this.checkNotationResource(r2)) continue;
                resource = r2;
                continue block0;
            }
        }
        if (resource == null) {
            resource = this.addNotationResource();
        }
        resource.getContents().add((Object)this.model);
    }

    private String getNotationResourceId() {
        return "org.eclipse.viatra.addon.viewers.notation.NotationResource";
    }

    public NotationModel getNotationModel() {
        return this.model;
    }

    public ViatraQueryEngine getEngine() {
        return this.engine;
    }

    public void dispose() {
        EcoreUtil.delete((EObject)this.model);
    }

    public abstract Collection<IQuerySpecification<?>> getPatterns();

    private Resource addNotationResource() throws ViatraQueryException, ViatraBaseException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createURI((String)this.getNotationResourceId()));
        NavigationHelper helper = EMFScope.extractUnderlyingEMFIndex((ViatraQueryEngine)this.engine);
        helper.addRoot((Notifier)resourceSet);
        return resource;
    }

    private boolean checkNotationResource(Resource r) {
        return r.getURI().toString().equals(this.getNotationResourceId());
    }

    private Collection<? extends Notifier> getNotifiers() {
        return ((EMFScope)this.engine.getScope()).getScopeRoots();
    }
}

