/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.runtime.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.viatra.addon.viewers.runtime.model.patterns.Param2containmentMatch;
import org.eclipse.viatra.addon.viewers.runtime.model.patterns.Param2containmentMatcher;
import org.eclipse.viatra.addon.viewers.runtime.model.patterns.Param2edgeMatch;
import org.eclipse.viatra.addon.viewers.runtime.model.patterns.Param2edgeMatcher;
import org.eclipse.viatra.addon.viewers.runtime.model.patterns.Param2itemMatch;
import org.eclipse.viatra.addon.viewers.runtime.model.patterns.Param2itemMatcher;
import org.eclipse.viatra.addon.viewers.runtime.notation.Containment;
import org.eclipse.viatra.addon.viewers.runtime.notation.Edge;
import org.eclipse.viatra.addon.viewers.runtime.notation.Item;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;

public final class ViewerTraceabilityUtil {
    private ViewerTraceabilityUtil() {
    }

    public static Collection<Item> traceToItem(ViatraQueryEngine engine, Object source) {
        ArrayList list = Lists.newArrayList();
        Collection<Param2itemMatch> allMatches = ViewerTraceabilityUtil.executeParam2itemMatcher(engine, source);
        for (Param2itemMatch match : allMatches) {
            list.add(match.getItem());
        }
        return list;
    }

    private static Collection<Param2itemMatch> executeParam2itemMatcher(ViatraQueryEngine engine, Object source) {
        try {
            Param2itemMatcher matcher = Param2itemMatcher.on(engine);
            return matcher.getAllMatches(source, null, null);
        }
        catch (ViatraQueryException e) {
            Logger logger = ViatraQueryLoggingUtil.getLogger(ViewerTraceabilityUtil.class);
            logger.error((Object)e.getMessage());
            return Collections.emptySet();
        }
    }

    public static Collection<Edge> traceToEdge(ViatraQueryEngine engine, Object source, Object target) {
        ArrayList list = Lists.newArrayList();
        Collection<Param2edgeMatch> allMatches = ViewerTraceabilityUtil.executeParam2edgeMatcher(engine, source, target);
        for (Param2edgeMatch match : allMatches) {
            list.add(match.getEdge());
        }
        return list;
    }

    private static Collection<Param2edgeMatch> executeParam2edgeMatcher(ViatraQueryEngine engine, Object source, Object target) {
        try {
            Param2edgeMatcher matcher = Param2edgeMatcher.on(engine);
            return matcher.getAllMatches(source, target, null, null);
        }
        catch (ViatraQueryException e) {
            Logger logger = ViatraQueryLoggingUtil.getLogger(ViewerTraceabilityUtil.class);
            logger.error((Object)e.getMessage());
            return Collections.emptySet();
        }
    }

    public static Collection<Containment> traceTocontainment(ViatraQueryEngine engine, Object source, Object target) {
        ArrayList list = Lists.newArrayList();
        Collection<Param2containmentMatch> allMatches = ViewerTraceabilityUtil.executeParam2containmentMatcher(engine, source, target);
        for (Param2containmentMatch match : allMatches) {
            list.add(match.getContainment());
        }
        return list;
    }

    private static Collection<Param2containmentMatch> executeParam2containmentMatcher(ViatraQueryEngine engine, Object source, Object target) {
        try {
            Param2containmentMatcher matcher = Param2containmentMatcher.on(engine);
            return matcher.getAllMatches(source, target, null, null);
        }
        catch (ViatraQueryException e) {
            Logger logger = ViatraQueryLoggingUtil.getLogger(ViewerTraceabilityUtil.class);
            logger.error((Object)e.getMessage());
            return Collections.emptySet();
        }
    }

    public static Collection<Item> deleteTracesAndItems(ViatraQueryEngine engine, Object source) {
        ArrayList list = Lists.newArrayList();
        Collection<Param2itemMatch> allMatches = ViewerTraceabilityUtil.executeParam2itemMatcher(engine, source);
        for (Param2itemMatch match : allMatches) {
            EcoreUtil.delete((EObject)match.getTrace());
            EcoreUtil.delete((EObject)match.getItem());
            list.add(match.getItem());
        }
        return list;
    }

    public static Collection<Edge> deleteTracesAndEdges(ViatraQueryEngine engine, Object source, Object target) {
        ArrayList list = Lists.newArrayList();
        Collection<Param2edgeMatch> allMatches = ViewerTraceabilityUtil.executeParam2edgeMatcher(engine, source, target);
        for (Param2edgeMatch match : allMatches) {
            EcoreUtil.delete((EObject)match.getTrace());
            EcoreUtil.delete((EObject)match.getEdge());
            list.add(match.getEdge());
        }
        return list;
    }

    public static Collection<Containment> deleteTracesAndContainments(ViatraQueryEngine engine, Object source, Object target) {
        ArrayList list = Lists.newArrayList();
        Collection<Param2containmentMatch> allMatches = ViewerTraceabilityUtil.executeParam2containmentMatcher(engine, source, target);
        for (Param2containmentMatch match : allMatches) {
            match.getContainment().getTarget().setParent(null);
            EcoreUtil.delete((EObject)match.getTrace());
            EcoreUtil.delete((EObject)match.getContainment());
            list.add(match.getContainment());
        }
        return list;
    }
}

