/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.tooling.ui.zest.views.tabs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef4.layout.LayoutAlgorithm;
import org.eclipse.gef4.layout.algorithms.CompositeLayoutAlgorithm;
import org.eclipse.gef4.layout.algorithms.HorizontalShiftAlgorithm;
import org.eclipse.gef4.layout.algorithms.RadialLayoutAlgorithm;
import org.eclipse.gef4.layout.algorithms.SpringLayoutAlgorithm;
import org.eclipse.gef4.layout.algorithms.SugiyamaLayoutAlgorithm;
import org.eclipse.gef4.layout.algorithms.TreeLayoutAlgorithm;
import org.eclipse.gef4.zest.core.viewers.AbstractZoomableViewer;
import org.eclipse.gef4.zest.core.viewers.GraphViewer;
import org.eclipse.gef4.zest.core.viewers.IZoomableWorkbenchPart;
import org.eclipse.gef4.zest.core.viewers.ZoomContributionViewItem;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerState;
import org.eclipse.viatra.addon.viewers.runtime.zest.ViatraGraphViewers;
import org.eclipse.viatra.addon.viewers.runtime.zest.ViewersZestPlugin;
import org.eclipse.viatra.addon.viewers.tooling.ui.views.tabs.AbstractViewerSandboxTab;

public class ZestGraphViewerSandboxTab
extends AbstractViewerSandboxTab
implements IZoomableWorkbenchPart {
    GraphViewer viewer;
    private Action refreshGraph = new Action("Refresh Graph"){

        public void run() {
            ZestGraphViewerSandboxTab.this.redraw();
        }
    };
    private Action clearGraph = new Action("Clear Graph"){

        public void run() {
            ZestGraphViewerSandboxTab.this.viewer.setInput(null);
        }
    };

    public String getTabTitle() {
        return "Zest Graph";
    }

    public void bindState(ViewerState state) {
        ViatraGraphViewers.bindWithIsolatedNodes((GraphViewer)this.viewer, (ViewerState)state, (boolean)true);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    protected StructuredViewer getViewer() {
        return this.viewer;
    }

    protected StructuredViewer createViewer(Composite parent) {
        this.viewer = new GraphViewer(parent, 0);
        this.viewer.setConnectionStyle(2);
        SpringLayoutAlgorithm layout = new SpringLayoutAlgorithm();
        this.viewer.setLayoutAlgorithm((LayoutAlgorithm)layout, true);
        this.refreshGraph.setImageDescriptor(ViewersZestPlugin.imageDescriptorFromPlugin((String)"org.eclipse.viatra.addon.viewers.runtime.zest", (String)"icons/refresh.gif"));
        this.clearGraph.setImageDescriptor(ViewersZestPlugin.imageDescriptorFromPlugin((String)"org.eclipse.viatra.addon.viewers.runtime.zest", (String)"icons/clear.gif"));
        return this.viewer;
    }

    private MenuManager createLayoutMenu() {
        MenuManager mgr = new MenuManager("Layout");
        mgr.add((IAction)this.createLayoutAction("Tree", (LayoutAlgorithm)new TreeLayoutAlgorithm()));
        mgr.add((IAction)this.createLayoutAction("Spring", (LayoutAlgorithm)new SpringLayoutAlgorithm()));
        mgr.add((IAction)this.createLayoutAction("Radial", (LayoutAlgorithm)new RadialLayoutAlgorithm()));
        SugiyamaLayoutAlgorithm sugiyamaAlgorithm = new SugiyamaLayoutAlgorithm();
        HorizontalShiftAlgorithm shiftAlgorithm = new HorizontalShiftAlgorithm();
        mgr.add((IAction)this.createLayoutAction("Sugiyama (unstable)", (LayoutAlgorithm)new CompositeLayoutAlgorithm(new LayoutAlgorithm[]{sugiyamaAlgorithm, shiftAlgorithm})));
        return mgr;
    }

    private Action createLayoutAction(String name, final LayoutAlgorithm lay) {
        return new Action(name){

            public void run() {
                ZestGraphViewerSandboxTab.this.viewer.setLayoutAlgorithm(lay);
                ZestGraphViewerSandboxTab.this.redraw();
            }
        };
    }

    private void redraw() {
        if (this.viewer != null) {
            this.viewer.applyLayout();
            this.viewer.refresh();
        }
    }

    public List<IContributionItem> getDropDownMenuContributions() {
        ArrayList<IContributionItem> r = new ArrayList<IContributionItem>();
        r.add((IContributionItem)this.createLayoutMenu());
        return r;
    }

    public List<IContributionItem> getToolBarContributions() {
        ArrayList<IContributionItem> r = new ArrayList<IContributionItem>();
        MenuManager mgr = new MenuManager();
        mgr.removeAll();
        mgr.add((IAction)this.refreshGraph);
        mgr.add((IAction)this.clearGraph);
        ZoomContributionViewItem toolbarZoomContributionViewItem = new ZoomContributionViewItem((IZoomableWorkbenchPart)this);
        mgr.add((IContributionItem)toolbarZoomContributionViewItem);
        mgr.update(true);
        r.add((IContributionItem)mgr);
        return r;
    }

    public AbstractZoomableViewer getZoomableViewer() {
        return this.viewer;
    }
}

