/**
 * 
 *   Copyright (c) 2004-2015, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.metamodels.derived;

import org.eclipse.viatra.cep.core.metamodels.derived.EventTokensInModelMatcher;
import org.eclipse.viatra.cep.core.metamodels.derived.FinalStatesMatcher;
import org.eclipse.viatra.cep.core.metamodels.derived.InitialStateMatcher;
import org.eclipse.viatra.cep.core.metamodels.derived.TrapStateMatcher;
import org.eclipse.viatra.cep.core.metamodels.derived.util.EventTokensInModelQuerySpecification;
import org.eclipse.viatra.cep.core.metamodels.derived.util.FinalStatesQuerySpecification;
import org.eclipse.viatra.cep.core.metamodels.derived.util.InitialStateQuerySpecification;
import org.eclipse.viatra.cep.core.metamodels.derived.util.TrapStateQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedPatternGroup;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;

/**
 * A pattern group formed of all patterns defined in derivedFeatures.vql.
 * 
 * <p>Use the static instance as any {@link org.eclipse.viatra.query.runtime.api.IPatternGroup}, to conveniently prepare
 * a VIATRA Query engine for matching all patterns originally defined in file derivedFeatures.vql,
 * in order to achieve better performance than one-by-one on-demand matcher initialization.
 * 
 * <p> From package org.eclipse.viatra.cep.core.metamodels.derived, the group contains the definition of the following patterns: <ul>
 * <li>initialState</li>
 * <li>finalStates</li>
 * <li>trapState</li>
 * <li>eventTokensInModel</li>
 * </ul>
 * 
 * @see IPatternGroup
 * 
 */
@SuppressWarnings("all")
public final class DerivedFeatures extends BaseGeneratedPatternGroup {
  /**
   * Access the pattern group.
   * 
   * @return the singleton instance of the group
   * @throws ViatraQueryException if there was an error loading the generated code of pattern specifications
   * 
   */
  public static DerivedFeatures instance() throws ViatraQueryException {
    if (INSTANCE == null) {
    	INSTANCE = new DerivedFeatures();
    }
    return INSTANCE;
  }
  
  private static DerivedFeatures INSTANCE;
  
  private DerivedFeatures() throws ViatraQueryException {
    querySpecifications.add(InitialStateQuerySpecification.instance());
    querySpecifications.add(FinalStatesQuerySpecification.instance());
    querySpecifications.add(TrapStateQuerySpecification.instance());
    querySpecifications.add(EventTokensInModelQuerySpecification.instance());
  }
  
  public InitialStateQuerySpecification getInitialState() throws ViatraQueryException {
    return InitialStateQuerySpecification.instance();
  }
  
  public InitialStateMatcher getInitialState(final ViatraQueryEngine engine) throws ViatraQueryException {
    return InitialStateMatcher.on(engine);
  }
  
  public FinalStatesQuerySpecification getFinalStates() throws ViatraQueryException {
    return FinalStatesQuerySpecification.instance();
  }
  
  public FinalStatesMatcher getFinalStates(final ViatraQueryEngine engine) throws ViatraQueryException {
    return FinalStatesMatcher.on(engine);
  }
  
  public TrapStateQuerySpecification getTrapState() throws ViatraQueryException {
    return TrapStateQuerySpecification.instance();
  }
  
  public TrapStateMatcher getTrapState(final ViatraQueryEngine engine) throws ViatraQueryException {
    return TrapStateMatcher.on(engine);
  }
  
  public EventTokensInModelQuerySpecification getEventTokensInModel() throws ViatraQueryException {
    return EventTokensInModelQuerySpecification.instance();
  }
  
  public EventTokensInModelMatcher getEventTokensInModel(final ViatraQueryEngine engine) throws ViatraQueryException {
    return EventTokensInModelMatcher.on(engine);
  }
}
