/**
 * 
 *   Copyright (c) 2004-2015, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.compiler;

import java.util.Arrays;
import java.util.List;
import org.eclipse.viatra.cep.core.engine.compiler.util.ComplexOrTransitionQuerySpecification;
import org.eclipse.viatra.cep.core.metamodels.automaton.Automaton;
import org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition;
import org.eclipse.viatra.cep.core.metamodels.events.ComplexEventPattern;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.impl.BasePatternMatch;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;

/**
 * Pattern-specific match representation of the org.eclipse.viatra.cep.core.engine.compiler.complexOrTransition pattern,
 * to be used in conjunction with {@link ComplexOrTransitionMatcher}.
 * 
 * <p>Class fields correspond to parameters of the pattern. Fields with value null are considered unassigned.
 * Each instance is a (possibly partial) substitution of pattern parameters,
 * usable to represent a match of the pattern in the result of a query,
 * or to specify the bound (fixed) input parameters when issuing a query.
 * 
 * @see ComplexOrTransitionMatcher
 * @see ComplexOrTransitionProcessor
 * 
 */
@SuppressWarnings("all")
public abstract class ComplexOrTransitionMatch extends BasePatternMatch {
  private Automaton fAutomaton;
  
  private TypedTransition fTransition;
  
  private ComplexEventPattern fEventPattern;
  
  private static List<String> parameterNames = makeImmutableList("automaton", "transition", "eventPattern");
  
  private ComplexOrTransitionMatch(final Automaton pAutomaton, final TypedTransition pTransition, final ComplexEventPattern pEventPattern) {
    this.fAutomaton = pAutomaton;
    this.fTransition = pTransition;
    this.fEventPattern = pEventPattern;
  }
  
  @Override
  public Object get(final String parameterName) {
    if ("automaton".equals(parameterName)) return this.fAutomaton;
    if ("transition".equals(parameterName)) return this.fTransition;
    if ("eventPattern".equals(parameterName)) return this.fEventPattern;
    return null;
  }
  
  public Automaton getAutomaton() {
    return this.fAutomaton;
  }
  
  public TypedTransition getTransition() {
    return this.fTransition;
  }
  
  public ComplexEventPattern getEventPattern() {
    return this.fEventPattern;
  }
  
  @Override
  public boolean set(final String parameterName, final Object newValue) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    if ("automaton".equals(parameterName) ) {
    	this.fAutomaton = (Automaton) newValue;
    	return true;
    }
    if ("transition".equals(parameterName) ) {
    	this.fTransition = (TypedTransition) newValue;
    	return true;
    }
    if ("eventPattern".equals(parameterName) ) {
    	this.fEventPattern = (ComplexEventPattern) newValue;
    	return true;
    }
    return false;
  }
  
  public void setAutomaton(final Automaton pAutomaton) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fAutomaton = pAutomaton;
  }
  
  public void setTransition(final TypedTransition pTransition) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fTransition = pTransition;
  }
  
  public void setEventPattern(final ComplexEventPattern pEventPattern) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fEventPattern = pEventPattern;
  }
  
  @Override
  public String patternName() {
    return "org.eclipse.viatra.cep.core.engine.compiler.complexOrTransition";
  }
  
  @Override
  public List<String> parameterNames() {
    return ComplexOrTransitionMatch.parameterNames;
  }
  
  @Override
  public Object[] toArray() {
    return new Object[]{fAutomaton, fTransition, fEventPattern};
  }
  
  @Override
  public ComplexOrTransitionMatch toImmutable() {
    return isMutable() ? newMatch(fAutomaton, fTransition, fEventPattern) : this;
  }
  
  @Override
  public String prettyPrint() {
    StringBuilder result = new StringBuilder();
    result.append("\"automaton\"=" + prettyPrintValue(fAutomaton) + ", ");
    
    result.append("\"transition\"=" + prettyPrintValue(fTransition) + ", ");
    
    result.append("\"eventPattern\"=" + prettyPrintValue(fEventPattern)
    );
    return result.toString();
  }
  
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((fAutomaton == null) ? 0 : fAutomaton.hashCode());
    result = prime * result + ((fTransition == null) ? 0 : fTransition.hashCode());
    result = prime * result + ((fEventPattern == null) ? 0 : fEventPattern.hashCode());
    return result;
  }
  
  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
    	return true;
    if (!(obj instanceof ComplexOrTransitionMatch)) { // this should be infrequent
    	if (obj == null) {
    		return false;
    	}
    	if (!(obj instanceof IPatternMatch)) {
    		return false;
    	}
    	IPatternMatch otherSig  = (IPatternMatch) obj;
    	if (!specification().equals(otherSig.specification()))
    		return false;
    	return Arrays.deepEquals(toArray(), otherSig.toArray());
    }
    ComplexOrTransitionMatch other = (ComplexOrTransitionMatch) obj;
    if (fAutomaton == null) {if (other.fAutomaton != null) return false;}
    else if (!fAutomaton.equals(other.fAutomaton)) return false;
    if (fTransition == null) {if (other.fTransition != null) return false;}
    else if (!fTransition.equals(other.fTransition)) return false;
    if (fEventPattern == null) {if (other.fEventPattern != null) return false;}
    else if (!fEventPattern.equals(other.fEventPattern)) return false;
    return true;
  }
  
  @Override
  public ComplexOrTransitionQuerySpecification specification() {
    try {
    	return ComplexOrTransitionQuerySpecification.instance();
    } catch (ViatraQueryException ex) {
     	// This cannot happen, as the match object can only be instantiated if the query specification exists
     	throw new IllegalStateException (ex);
    }
  }
  
  /**
   * Returns an empty, mutable match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @return the empty match.
   * 
   */
  public static ComplexOrTransitionMatch newEmptyMatch() {
    return new Mutable(null, null, null);
  }
  
  /**
   * Returns a mutable (partial) match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @return the new, mutable (partial) match object.
   * 
   */
  public static ComplexOrTransitionMatch newMutableMatch(final Automaton pAutomaton, final TypedTransition pTransition, final ComplexEventPattern pEventPattern) {
    return new Mutable(pAutomaton, pTransition, pEventPattern);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public static ComplexOrTransitionMatch newMatch(final Automaton pAutomaton, final TypedTransition pTransition, final ComplexEventPattern pEventPattern) {
    return new Immutable(pAutomaton, pTransition, pEventPattern);
  }
  
  private static final class Mutable extends ComplexOrTransitionMatch {
    Mutable(final Automaton pAutomaton, final TypedTransition pTransition, final ComplexEventPattern pEventPattern) {
      super(pAutomaton, pTransition, pEventPattern);
    }
    
    @Override
    public boolean isMutable() {
      return true;
    }
  }
  
  private static final class Immutable extends ComplexOrTransitionMatch {
    Immutable(final Automaton pAutomaton, final TypedTransition pTransition, final ComplexEventPattern pEventPattern) {
      super(pAutomaton, pTransition, pEventPattern);
    }
    
    @Override
    public boolean isMutable() {
      return false;
    }
  }
}
