/**
 * 
 *   Copyright (c) 2004-2015, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.compiler;

import java.util.Arrays;
import java.util.List;
import org.eclipse.viatra.cep.core.engine.compiler.util.EquivalentTransitionsQuerySpecification;
import org.eclipse.viatra.cep.core.metamodels.automaton.State;
import org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.impl.BasePatternMatch;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;

/**
 * Pattern-specific match representation of the org.eclipse.viatra.cep.core.engine.compiler.equivalentTransitions pattern,
 * to be used in conjunction with {@link EquivalentTransitionsMatcher}.
 * 
 * <p>Class fields correspond to parameters of the pattern. Fields with value null are considered unassigned.
 * Each instance is a (possibly partial) substitution of pattern parameters,
 * usable to represent a match of the pattern in the result of a query,
 * or to specify the bound (fixed) input parameters when issuing a query.
 * 
 * @see EquivalentTransitionsMatcher
 * @see EquivalentTransitionsProcessor
 * 
 */
@SuppressWarnings("all")
public abstract class EquivalentTransitionsMatch extends BasePatternMatch {
  private TypedTransition fTransition1;
  
  private TypedTransition fTransition2;
  
  private State fPreState;
  
  private State fPostState;
  
  private static List<String> parameterNames = makeImmutableList("transition1", "transition2", "preState", "postState");
  
  private EquivalentTransitionsMatch(final TypedTransition pTransition1, final TypedTransition pTransition2, final State pPreState, final State pPostState) {
    this.fTransition1 = pTransition1;
    this.fTransition2 = pTransition2;
    this.fPreState = pPreState;
    this.fPostState = pPostState;
  }
  
  @Override
  public Object get(final String parameterName) {
    if ("transition1".equals(parameterName)) return this.fTransition1;
    if ("transition2".equals(parameterName)) return this.fTransition2;
    if ("preState".equals(parameterName)) return this.fPreState;
    if ("postState".equals(parameterName)) return this.fPostState;
    return null;
  }
  
  public TypedTransition getTransition1() {
    return this.fTransition1;
  }
  
  public TypedTransition getTransition2() {
    return this.fTransition2;
  }
  
  public State getPreState() {
    return this.fPreState;
  }
  
  public State getPostState() {
    return this.fPostState;
  }
  
  @Override
  public boolean set(final String parameterName, final Object newValue) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    if ("transition1".equals(parameterName) ) {
    	this.fTransition1 = (TypedTransition) newValue;
    	return true;
    }
    if ("transition2".equals(parameterName) ) {
    	this.fTransition2 = (TypedTransition) newValue;
    	return true;
    }
    if ("preState".equals(parameterName) ) {
    	this.fPreState = (State) newValue;
    	return true;
    }
    if ("postState".equals(parameterName) ) {
    	this.fPostState = (State) newValue;
    	return true;
    }
    return false;
  }
  
  public void setTransition1(final TypedTransition pTransition1) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fTransition1 = pTransition1;
  }
  
  public void setTransition2(final TypedTransition pTransition2) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fTransition2 = pTransition2;
  }
  
  public void setPreState(final State pPreState) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fPreState = pPreState;
  }
  
  public void setPostState(final State pPostState) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fPostState = pPostState;
  }
  
  @Override
  public String patternName() {
    return "org.eclipse.viatra.cep.core.engine.compiler.equivalentTransitions";
  }
  
  @Override
  public List<String> parameterNames() {
    return EquivalentTransitionsMatch.parameterNames;
  }
  
  @Override
  public Object[] toArray() {
    return new Object[]{fTransition1, fTransition2, fPreState, fPostState};
  }
  
  @Override
  public EquivalentTransitionsMatch toImmutable() {
    return isMutable() ? newMatch(fTransition1, fTransition2, fPreState, fPostState) : this;
  }
  
  @Override
  public String prettyPrint() {
    StringBuilder result = new StringBuilder();
    result.append("\"transition1\"=" + prettyPrintValue(fTransition1) + ", ");
    
    result.append("\"transition2\"=" + prettyPrintValue(fTransition2) + ", ");
    
    result.append("\"preState\"=" + prettyPrintValue(fPreState) + ", ");
    
    result.append("\"postState\"=" + prettyPrintValue(fPostState)
    );
    return result.toString();
  }
  
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((fTransition1 == null) ? 0 : fTransition1.hashCode());
    result = prime * result + ((fTransition2 == null) ? 0 : fTransition2.hashCode());
    result = prime * result + ((fPreState == null) ? 0 : fPreState.hashCode());
    result = prime * result + ((fPostState == null) ? 0 : fPostState.hashCode());
    return result;
  }
  
  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
    	return true;
    if (!(obj instanceof EquivalentTransitionsMatch)) { // this should be infrequent
    	if (obj == null) {
    		return false;
    	}
    	if (!(obj instanceof IPatternMatch)) {
    		return false;
    	}
    	IPatternMatch otherSig  = (IPatternMatch) obj;
    	if (!specification().equals(otherSig.specification()))
    		return false;
    	return Arrays.deepEquals(toArray(), otherSig.toArray());
    }
    EquivalentTransitionsMatch other = (EquivalentTransitionsMatch) obj;
    if (fTransition1 == null) {if (other.fTransition1 != null) return false;}
    else if (!fTransition1.equals(other.fTransition1)) return false;
    if (fTransition2 == null) {if (other.fTransition2 != null) return false;}
    else if (!fTransition2.equals(other.fTransition2)) return false;
    if (fPreState == null) {if (other.fPreState != null) return false;}
    else if (!fPreState.equals(other.fPreState)) return false;
    if (fPostState == null) {if (other.fPostState != null) return false;}
    else if (!fPostState.equals(other.fPostState)) return false;
    return true;
  }
  
  @Override
  public EquivalentTransitionsQuerySpecification specification() {
    try {
    	return EquivalentTransitionsQuerySpecification.instance();
    } catch (ViatraQueryException ex) {
     	// This cannot happen, as the match object can only be instantiated if the query specification exists
     	throw new IllegalStateException (ex);
    }
  }
  
  /**
   * Returns an empty, mutable match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @return the empty match.
   * 
   */
  public static EquivalentTransitionsMatch newEmptyMatch() {
    return new Mutable(null, null, null, null);
  }
  
  /**
   * Returns a mutable (partial) match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @param pTransition1 the fixed value of pattern parameter transition1, or null if not bound.
   * @param pTransition2 the fixed value of pattern parameter transition2, or null if not bound.
   * @param pPreState the fixed value of pattern parameter preState, or null if not bound.
   * @param pPostState the fixed value of pattern parameter postState, or null if not bound.
   * @return the new, mutable (partial) match object.
   * 
   */
  public static EquivalentTransitionsMatch newMutableMatch(final TypedTransition pTransition1, final TypedTransition pTransition2, final State pPreState, final State pPostState) {
    return new Mutable(pTransition1, pTransition2, pPreState, pPostState);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pTransition1 the fixed value of pattern parameter transition1, or null if not bound.
   * @param pTransition2 the fixed value of pattern parameter transition2, or null if not bound.
   * @param pPreState the fixed value of pattern parameter preState, or null if not bound.
   * @param pPostState the fixed value of pattern parameter postState, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public static EquivalentTransitionsMatch newMatch(final TypedTransition pTransition1, final TypedTransition pTransition2, final State pPreState, final State pPostState) {
    return new Immutable(pTransition1, pTransition2, pPreState, pPostState);
  }
  
  private static final class Mutable extends EquivalentTransitionsMatch {
    Mutable(final TypedTransition pTransition1, final TypedTransition pTransition2, final State pPreState, final State pPostState) {
      super(pTransition1, pTransition2, pPreState, pPostState);
    }
    
    @Override
    public boolean isMutable() {
      return true;
    }
  }
  
  private static final class Immutable extends EquivalentTransitionsMatch {
    Immutable(final TypedTransition pTransition1, final TypedTransition pTransition2, final State pPreState, final State pPostState) {
      super(pTransition1, pTransition2, pPreState, pPostState);
    }
    
    @Override
    public boolean isMutable() {
      return false;
    }
  }
}
