/**
 * 
 *   Copyright (c) 2004-2015, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.compiler.util;

import org.eclipse.viatra.cep.core.engine.compiler.SameBooleanTransitionTypeMatch;
import org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;

/**
 * A match processor tailored for the org.eclipse.viatra.cep.core.engine.compiler.sameBooleanTransitionType pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class SameBooleanTransitionTypeProcessor implements IMatchProcessor<SameBooleanTransitionTypeMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pTransition1 the value of pattern parameter transition1 in the currently processed match
   * @param pTransition2 the value of pattern parameter transition2 in the currently processed match
   * 
   */
  public abstract void process(final TypedTransition pTransition1, final TypedTransition pTransition2);
  
  @Override
  public void process(final SameBooleanTransitionTypeMatch match) {
    process(match.getTransition1(), match.getTransition2());
  }
}
