/**
 * 
 *   Copyright (c) 2004-2015, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.compiler.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.viatra.cep.core.engine.compiler.SameBooleanTransitionTypeMatch;
import org.eclipse.viatra.cep.core.engine.compiler.SameBooleanTransitionTypeMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.util.NegativeTransitionQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.NegativePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameterDirection;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.viatra.query.runtime.matchers.tuple.FlatTuple;

/**
 * A pattern-specific query specification that can instantiate SameBooleanTransitionTypeMatcher in a type-safe way.
 * 
 * @see SameBooleanTransitionTypeMatcher
 * @see SameBooleanTransitionTypeMatch
 * 
 */
@SuppressWarnings("all")
public final class SameBooleanTransitionTypeQuerySpecification extends BaseGeneratedEMFQuerySpecification<SameBooleanTransitionTypeMatcher> {
  private SameBooleanTransitionTypeQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws ViatraQueryException if the pattern definition could not be loaded
   * 
   */
  public static SameBooleanTransitionTypeQuerySpecification instance() throws ViatraQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected SameBooleanTransitionTypeMatcher instantiate(final ViatraQueryEngine engine) throws ViatraQueryException {
    return SameBooleanTransitionTypeMatcher.on(engine);
  }
  
  @Override
  public SameBooleanTransitionTypeMatcher instantiate() throws ViatraQueryException {
    return SameBooleanTransitionTypeMatcher.create();
  }
  
  @Override
  public SameBooleanTransitionTypeMatch newEmptyMatch() {
    return SameBooleanTransitionTypeMatch.newEmptyMatch();
  }
  
  @Override
  public SameBooleanTransitionTypeMatch newMatch(final Object... parameters) {
    return SameBooleanTransitionTypeMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition) parameters[0], (org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition) parameters[1]);
  }
  
  /**
   * Inner class allowing the singleton instance of {@link SameBooleanTransitionTypeQuerySpecification} to be created 
   * 	<b>not</b> at the class load time of the outer class, 
   * 	but rather at the first call to {@link SameBooleanTransitionTypeQuerySpecification#instance()}.
   * 
   * <p> This workaround is required e.g. to support recursion.
   * 
   */
  private static class LazyHolder {
    private final static SameBooleanTransitionTypeQuerySpecification INSTANCE = new SameBooleanTransitionTypeQuerySpecification();
    
    /**
     * Statically initializes the query specification <b>after</b> the field {@link #INSTANCE} is assigned.
     * This initialization order is required to support indirect recursion.
     * 
     * <p> The static initializer is defined using a helper field to work around limitations of the code generator.
     * 
     */
    private final static Object STATIC_INITIALIZER = ensureInitialized();
    
    public static Object ensureInitialized() {
      INSTANCE.ensureInitializedInternalSneaky();
      return null;
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static SameBooleanTransitionTypeQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    private final PParameter parameter_pTransition1 = new PParameter("transition1", "org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("automaton.meta", "TypedTransition")), PParameterDirection.INOUT);
    
    private final PParameter parameter_pTransition2 = new PParameter("transition2", "org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("automaton.meta", "TypedTransition")), PParameterDirection.INOUT);
    
    private final List<PParameter> parameters = Arrays.asList(parameter_pTransition1, parameter_pTransition2);
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.cep.core.engine.compiler.sameBooleanTransitionType";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("transition1","transition2");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return parameters;
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      setEvaluationHints(new QueryEvaluationHint(null, Collections.<String,Object>emptyMap()));
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_transition1 = body.getOrCreateVariableByName("transition1");
      		PVariable var_transition2 = body.getOrCreateVariableByName("transition2");
      		new TypeConstraint(body, new FlatTuple(var_transition1), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "TypedTransition")));
      		new TypeConstraint(body, new FlatTuple(var_transition2), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "TypedTransition")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_transition1, parameter_pTransition1),
      		   new ExportedParameter(body, var_transition2, parameter_pTransition2)
      		));
      		// 	find negativeTransition(transition1)
      		new PositivePatternCall(body, new FlatTuple(var_transition1), NegativeTransitionQuerySpecification.instance().getInternalQueryRepresentation());
      		// 	find negativeTransition(transition2)
      		new PositivePatternCall(body, new FlatTuple(var_transition2), NegativeTransitionQuerySpecification.instance().getInternalQueryRepresentation());
      		bodies.add(body);
      	}
      	{
      		PBody body = new PBody(this);
      		PVariable var_transition1 = body.getOrCreateVariableByName("transition1");
      		PVariable var_transition2 = body.getOrCreateVariableByName("transition2");
      		new TypeConstraint(body, new FlatTuple(var_transition1), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "TypedTransition")));
      		new TypeConstraint(body, new FlatTuple(var_transition2), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "TypedTransition")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_transition1, parameter_pTransition1),
      		   new ExportedParameter(body, var_transition2, parameter_pTransition2)
      		));
      		// 	neg find negativeTransition(transition1)
      		new NegativePatternCall(body, new FlatTuple(var_transition1), NegativeTransitionQuerySpecification.instance().getInternalQueryRepresentation());
      		// 	neg find negativeTransition(transition2)
      		new NegativePatternCall(body, new FlatTuple(var_transition2), NegativeTransitionQuerySpecification.instance().getInternalQueryRepresentation());
      		bodies.add(body);
      	}
      	// to silence compiler error
      	if (false) throw new ViatraQueryException("Never", "happens");
      } catch (ViatraQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
