/**
 * 
 *   Copyright (c) 2004-2014, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.runtime;

import java.util.Arrays;
import java.util.List;
import org.eclipse.viatra.cep.core.engine.runtime.util.InitStateQuerySpecification;
import org.eclipse.viatra.cep.core.metamodels.automaton.Automaton;
import org.eclipse.viatra.cep.core.metamodels.automaton.InitState;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.impl.BasePatternMatch;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;

/**
 * Pattern-specific match representation of the org.eclipse.viatra.cep.core.engine.runtime.initState pattern,
 * to be used in conjunction with {@link InitStateMatcher}.
 * 
 * <p>Class fields correspond to parameters of the pattern. Fields with value null are considered unassigned.
 * Each instance is a (possibly partial) substitution of pattern parameters,
 * usable to represent a match of the pattern in the result of a query,
 * or to specify the bound (fixed) input parameters when issuing a query.
 * 
 * @see InitStateMatcher
 * @see InitStateProcessor
 * 
 */
@SuppressWarnings("all")
public abstract class InitStateMatch extends BasePatternMatch {
  private Automaton fAutomaton;
  
  private InitState fInitState;
  
  private static List<String> parameterNames = makeImmutableList("automaton", "initState");
  
  private InitStateMatch(final Automaton pAutomaton, final InitState pInitState) {
    this.fAutomaton = pAutomaton;
    this.fInitState = pInitState;
  }
  
  @Override
  public Object get(final String parameterName) {
    if ("automaton".equals(parameterName)) return this.fAutomaton;
    if ("initState".equals(parameterName)) return this.fInitState;
    return null;
  }
  
  public Automaton getAutomaton() {
    return this.fAutomaton;
  }
  
  public InitState getInitState() {
    return this.fInitState;
  }
  
  @Override
  public boolean set(final String parameterName, final Object newValue) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    if ("automaton".equals(parameterName) ) {
    	this.fAutomaton = (Automaton) newValue;
    	return true;
    }
    if ("initState".equals(parameterName) ) {
    	this.fInitState = (InitState) newValue;
    	return true;
    }
    return false;
  }
  
  public void setAutomaton(final Automaton pAutomaton) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fAutomaton = pAutomaton;
  }
  
  public void setInitState(final InitState pInitState) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fInitState = pInitState;
  }
  
  @Override
  public String patternName() {
    return "org.eclipse.viatra.cep.core.engine.runtime.initState";
  }
  
  @Override
  public List<String> parameterNames() {
    return InitStateMatch.parameterNames;
  }
  
  @Override
  public Object[] toArray() {
    return new Object[]{fAutomaton, fInitState};
  }
  
  @Override
  public InitStateMatch toImmutable() {
    return isMutable() ? newMatch(fAutomaton, fInitState) : this;
  }
  
  @Override
  public String prettyPrint() {
    StringBuilder result = new StringBuilder();
    result.append("\"automaton\"=" + prettyPrintValue(fAutomaton) + ", ");
    
    result.append("\"initState\"=" + prettyPrintValue(fInitState)
    );
    return result.toString();
  }
  
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((fAutomaton == null) ? 0 : fAutomaton.hashCode());
    result = prime * result + ((fInitState == null) ? 0 : fInitState.hashCode());
    return result;
  }
  
  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
    	return true;
    if (!(obj instanceof InitStateMatch)) { // this should be infrequent
    	if (obj == null) {
    		return false;
    	}
    	if (!(obj instanceof IPatternMatch)) {
    		return false;
    	}
    	IPatternMatch otherSig  = (IPatternMatch) obj;
    	if (!specification().equals(otherSig.specification()))
    		return false;
    	return Arrays.deepEquals(toArray(), otherSig.toArray());
    }
    InitStateMatch other = (InitStateMatch) obj;
    if (fAutomaton == null) {if (other.fAutomaton != null) return false;}
    else if (!fAutomaton.equals(other.fAutomaton)) return false;
    if (fInitState == null) {if (other.fInitState != null) return false;}
    else if (!fInitState.equals(other.fInitState)) return false;
    return true;
  }
  
  @Override
  public InitStateQuerySpecification specification() {
    try {
    	return InitStateQuerySpecification.instance();
    } catch (ViatraQueryException ex) {
     	// This cannot happen, as the match object can only be instantiated if the query specification exists
     	throw new IllegalStateException (ex);
    }
  }
  
  /**
   * Returns an empty, mutable match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @return the empty match.
   * 
   */
  public static InitStateMatch newEmptyMatch() {
    return new Mutable(null, null);
  }
  
  /**
   * Returns a mutable (partial) match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pInitState the fixed value of pattern parameter initState, or null if not bound.
   * @return the new, mutable (partial) match object.
   * 
   */
  public static InitStateMatch newMutableMatch(final Automaton pAutomaton, final InitState pInitState) {
    return new Mutable(pAutomaton, pInitState);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pInitState the fixed value of pattern parameter initState, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public static InitStateMatch newMatch(final Automaton pAutomaton, final InitState pInitState) {
    return new Immutable(pAutomaton, pInitState);
  }
  
  private static final class Mutable extends InitStateMatch {
    Mutable(final Automaton pAutomaton, final InitState pInitState) {
      super(pAutomaton, pInitState);
    }
    
    @Override
    public boolean isMutable() {
      return true;
    }
  }
  
  private static final class Immutable extends InitStateMatch {
    Immutable(final Automaton pAutomaton, final InitState pInitState) {
      super(pAutomaton, pInitState);
    }
    
    @Override
    public boolean isMutable() {
      return false;
    }
  }
}
