/**
 * 
 *   Copyright (c) 2004-2014, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.runtime;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.viatra.cep.core.engine.runtime.TokenEntersTimedZoneMatch;
import org.eclipse.viatra.cep.core.engine.runtime.util.TokenEntersTimedZoneQuerySpecification;
import org.eclipse.viatra.cep.core.metamodels.automaton.EventToken;
import org.eclipse.viatra.cep.core.metamodels.automaton.State;
import org.eclipse.viatra.cep.core.metamodels.automaton.TimedZone;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseMatcher;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;

/**
 * Generated pattern matcher API of the org.eclipse.viatra.cep.core.engine.runtime.tokenEntersTimedZone pattern,
 * providing pattern-specific query methods.
 * 
 * <p>Use the pattern matcher on a given model via {@link #on(ViatraQueryEngine)},
 * e.g. in conjunction with {@link ViatraQueryEngine#on(Notifier)}.
 * 
 * <p>Matches of the pattern will be represented as {@link TokenEntersTimedZoneMatch}.
 * 
 * <p>Original source:
 * <code><pre>
 * ////////////TIMING PATTERNS////////////
 * 
 * pattern tokenEntersTimedZone(eventToken : EventToken, state : State, timedZone : TimedZone) {
 * 	EventToken.currentState(eventToken, state);
 * 	State.inStateOf(state, timedZone);
 * }
 * </pre></code>
 * 
 * @see TokenEntersTimedZoneMatch
 * @see TokenEntersTimedZoneProcessor
 * @see TokenEntersTimedZoneQuerySpecification
 * 
 */
@SuppressWarnings("all")
public class TokenEntersTimedZoneMatcher extends BaseMatcher<TokenEntersTimedZoneMatch> {
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static TokenEntersTimedZoneMatcher on(final ViatraQueryEngine engine) throws ViatraQueryException {
    // check if matcher already exists
    TokenEntersTimedZoneMatcher matcher = engine.getExistingMatcher(querySpecification());
    if (matcher == null) {
    	matcher = (TokenEntersTimedZoneMatcher)engine.getMatcher(querySpecification());
    }
    return matcher;
  }
  
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static TokenEntersTimedZoneMatcher create() throws ViatraQueryException {
    return new TokenEntersTimedZoneMatcher();
  }
  
  private final static int POSITION_EVENTTOKEN = 0;
  
  private final static int POSITION_STATE = 1;
  
  private final static int POSITION_TIMEDZONE = 2;
  
  private final static Logger LOGGER = ViatraQueryLoggingUtil.getLogger(TokenEntersTimedZoneMatcher.class);
  
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  private TokenEntersTimedZoneMatcher() throws ViatraQueryException {
    super(querySpecification());
  }
  
  /**
   * Returns the set of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pState the fixed value of pattern parameter state, or null if not bound.
   * @param pTimedZone the fixed value of pattern parameter timedZone, or null if not bound.
   * @return matches represented as a TokenEntersTimedZoneMatch object.
   * 
   */
  public Collection<TokenEntersTimedZoneMatch> getAllMatches(final EventToken pEventToken, final State pState, final TimedZone pTimedZone) {
    return rawGetAllMatches(new Object[]{pEventToken, pState, pTimedZone});
  }
  
  /**
   * Returns an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pState the fixed value of pattern parameter state, or null if not bound.
   * @param pTimedZone the fixed value of pattern parameter timedZone, or null if not bound.
   * @return a match represented as a TokenEntersTimedZoneMatch object, or null if no match is found.
   * 
   */
  public TokenEntersTimedZoneMatch getOneArbitraryMatch(final EventToken pEventToken, final State pState, final TimedZone pTimedZone) {
    return rawGetOneArbitraryMatch(new Object[]{pEventToken, pState, pTimedZone});
  }
  
  /**
   * Indicates whether the given combination of specified pattern parameters constitute a valid pattern match,
   * under any possible substitution of the unspecified parameters (if any).
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pState the fixed value of pattern parameter state, or null if not bound.
   * @param pTimedZone the fixed value of pattern parameter timedZone, or null if not bound.
   * @return true if the input is a valid (partial) match of the pattern.
   * 
   */
  public boolean hasMatch(final EventToken pEventToken, final State pState, final TimedZone pTimedZone) {
    return rawHasMatch(new Object[]{pEventToken, pState, pTimedZone});
  }
  
  /**
   * Returns the number of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pState the fixed value of pattern parameter state, or null if not bound.
   * @param pTimedZone the fixed value of pattern parameter timedZone, or null if not bound.
   * @return the number of pattern matches found.
   * 
   */
  public int countMatches(final EventToken pEventToken, final State pState, final TimedZone pTimedZone) {
    return rawCountMatches(new Object[]{pEventToken, pState, pTimedZone});
  }
  
  /**
   * Executes the given processor on each match of the pattern that conforms to the given fixed values of some parameters.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pState the fixed value of pattern parameter state, or null if not bound.
   * @param pTimedZone the fixed value of pattern parameter timedZone, or null if not bound.
   * @param processor the action that will process each pattern match.
   * 
   */
  public void forEachMatch(final EventToken pEventToken, final State pState, final TimedZone pTimedZone, final IMatchProcessor<? super TokenEntersTimedZoneMatch> processor) {
    rawForEachMatch(new Object[]{pEventToken, pState, pTimedZone}, processor);
  }
  
  /**
   * Executes the given processor on an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pState the fixed value of pattern parameter state, or null if not bound.
   * @param pTimedZone the fixed value of pattern parameter timedZone, or null if not bound.
   * @param processor the action that will process the selected match.
   * @return true if the pattern has at least one match with the given parameter values, false if the processor was not invoked
   * 
   */
  public boolean forOneArbitraryMatch(final EventToken pEventToken, final State pState, final TimedZone pTimedZone, final IMatchProcessor<? super TokenEntersTimedZoneMatch> processor) {
    return rawForOneArbitraryMatch(new Object[]{pEventToken, pState, pTimedZone}, processor);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pState the fixed value of pattern parameter state, or null if not bound.
   * @param pTimedZone the fixed value of pattern parameter timedZone, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public TokenEntersTimedZoneMatch newMatch(final EventToken pEventToken, final State pState, final TimedZone pTimedZone) {
    return TokenEntersTimedZoneMatch.newMatch(pEventToken, pState, pTimedZone);
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventToken.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<EventToken> rawAccumulateAllValuesOfeventToken(final Object[] parameters) {
    Set<EventToken> results = new HashSet<EventToken>();
    rawAccumulateAllValues(POSITION_EVENTTOKEN, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventToken.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<EventToken> getAllValuesOfeventToken() {
    return rawAccumulateAllValuesOfeventToken(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventToken.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<EventToken> getAllValuesOfeventToken(final TokenEntersTimedZoneMatch partialMatch) {
    return rawAccumulateAllValuesOfeventToken(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventToken.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<EventToken> getAllValuesOfeventToken(final State pState, final TimedZone pTimedZone) {
    return rawAccumulateAllValuesOfeventToken(new Object[]{
    null, 
    pState, 
    pTimedZone
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for state.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<State> rawAccumulateAllValuesOfstate(final Object[] parameters) {
    Set<State> results = new HashSet<State>();
    rawAccumulateAllValues(POSITION_STATE, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for state.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<State> getAllValuesOfstate() {
    return rawAccumulateAllValuesOfstate(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for state.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<State> getAllValuesOfstate(final TokenEntersTimedZoneMatch partialMatch) {
    return rawAccumulateAllValuesOfstate(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for state.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<State> getAllValuesOfstate(final EventToken pEventToken, final TimedZone pTimedZone) {
    return rawAccumulateAllValuesOfstate(new Object[]{
    pEventToken, 
    null, 
    pTimedZone
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for timedZone.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<TimedZone> rawAccumulateAllValuesOftimedZone(final Object[] parameters) {
    Set<TimedZone> results = new HashSet<TimedZone>();
    rawAccumulateAllValues(POSITION_TIMEDZONE, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for timedZone.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<TimedZone> getAllValuesOftimedZone() {
    return rawAccumulateAllValuesOftimedZone(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for timedZone.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<TimedZone> getAllValuesOftimedZone(final TokenEntersTimedZoneMatch partialMatch) {
    return rawAccumulateAllValuesOftimedZone(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for timedZone.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<TimedZone> getAllValuesOftimedZone(final EventToken pEventToken, final State pState) {
    return rawAccumulateAllValuesOftimedZone(new Object[]{
    pEventToken, 
    pState, 
    null
    });
  }
  
  @Override
  protected TokenEntersTimedZoneMatch tupleToMatch(final Tuple t) {
    try {
    	return TokenEntersTimedZoneMatch.newMatch((EventToken) t.get(POSITION_EVENTTOKEN), (State) t.get(POSITION_STATE), (TimedZone) t.get(POSITION_TIMEDZONE));
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in tuple not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected TokenEntersTimedZoneMatch arrayToMatch(final Object[] match) {
    try {
    	return TokenEntersTimedZoneMatch.newMatch((EventToken) match[POSITION_EVENTTOKEN], (State) match[POSITION_STATE], (TimedZone) match[POSITION_TIMEDZONE]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected TokenEntersTimedZoneMatch arrayToMatchMutable(final Object[] match) {
    try {
    	return TokenEntersTimedZoneMatch.newMutableMatch((EventToken) match[POSITION_EVENTTOKEN], (State) match[POSITION_STATE], (TimedZone) match[POSITION_TIMEDZONE]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  /**
   * @return the singleton instance of the query specification of this pattern
   * @throws ViatraQueryException if the pattern definition could not be loaded
   * 
   */
  public static IQuerySpecification<TokenEntersTimedZoneMatcher> querySpecification() throws ViatraQueryException {
    return TokenEntersTimedZoneQuerySpecification.instance();
  }
}
