/**
 * 
 *   Copyright (c) 2004-2014, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.runtime.util;

import org.eclipse.viatra.cep.core.engine.runtime.EnabledTransitionMatch;
import org.eclipse.viatra.cep.core.metamodels.automaton.Automaton;
import org.eclipse.viatra.cep.core.metamodels.automaton.EventToken;
import org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition;
import org.eclipse.viatra.cep.core.metamodels.events.Event;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;

/**
 * A match processor tailored for the org.eclipse.viatra.cep.core.engine.runtime.enabledTransition pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class EnabledTransitionProcessor implements IMatchProcessor<EnabledTransitionMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pTransition the value of pattern parameter transition in the currently processed match
   * @param pEventToken the value of pattern parameter eventToken in the currently processed match
   * @param pEvent the value of pattern parameter event in the currently processed match
   * @param pAutomaton the value of pattern parameter automaton in the currently processed match
   * 
   */
  public abstract void process(final TypedTransition pTransition, final EventToken pEventToken, final Event pEvent, final Automaton pAutomaton);
  
  @Override
  public void process(final EnabledTransitionMatch match) {
    process(match.getTransition(), match.getEventToken(), match.getEvent(), match.getAutomaton());
  }
}
