/**
 * 
 *   Copyright (c) 2004-2015, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.compiler;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.viatra.cep.core.engine.compiler.AtomicEventPatternMatch;
import org.eclipse.viatra.cep.core.engine.compiler.util.AtomicEventPatternQuerySpecification;
import org.eclipse.viatra.cep.core.metamodels.events.AtomicEventPattern;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseMatcher;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;

/**
 * Generated pattern matcher API of the org.eclipse.viatra.cep.core.engine.compiler.atomicEventPattern pattern,
 * providing pattern-specific query methods.
 * 
 * <p>Use the pattern matcher on a given model via {@link #on(ViatraQueryEngine)},
 * e.g. in conjunction with {@link ViatraQueryEngine#on(Notifier)}.
 * 
 * <p>Matches of the pattern will be represented as {@link AtomicEventPatternMatch}.
 * 
 * <p>Original source:
 * <code><pre>
 * pattern atomicEventPattern(eventPattern : AtomicEventPattern) {
 * 	EventModel.eventPatterns(_, eventPattern);
 * 	neg find translatedEventPattern(eventPattern);
 * }
 * </pre></code>
 * 
 * @see AtomicEventPatternMatch
 * @see AtomicEventPatternProcessor
 * @see AtomicEventPatternQuerySpecification
 * 
 */
@SuppressWarnings("all")
public class AtomicEventPatternMatcher extends BaseMatcher<AtomicEventPatternMatch> {
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static AtomicEventPatternMatcher on(final ViatraQueryEngine engine) throws ViatraQueryException {
    // check if matcher already exists
    AtomicEventPatternMatcher matcher = engine.getExistingMatcher(querySpecification());
    if (matcher == null) {
    	matcher = (AtomicEventPatternMatcher)engine.getMatcher(querySpecification());
    }
    return matcher;
  }
  
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static AtomicEventPatternMatcher create() throws ViatraQueryException {
    return new AtomicEventPatternMatcher();
  }
  
  private final static int POSITION_EVENTPATTERN = 0;
  
  private final static Logger LOGGER = ViatraQueryLoggingUtil.getLogger(AtomicEventPatternMatcher.class);
  
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  private AtomicEventPatternMatcher() throws ViatraQueryException {
    super(querySpecification());
  }
  
  /**
   * Returns the set of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @return matches represented as a AtomicEventPatternMatch object.
   * 
   */
  public Collection<AtomicEventPatternMatch> getAllMatches(final AtomicEventPattern pEventPattern) {
    return rawGetAllMatches(new Object[]{pEventPattern});
  }
  
  /**
   * Returns an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @return a match represented as a AtomicEventPatternMatch object, or null if no match is found.
   * 
   */
  public AtomicEventPatternMatch getOneArbitraryMatch(final AtomicEventPattern pEventPattern) {
    return rawGetOneArbitraryMatch(new Object[]{pEventPattern});
  }
  
  /**
   * Indicates whether the given combination of specified pattern parameters constitute a valid pattern match,
   * under any possible substitution of the unspecified parameters (if any).
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @return true if the input is a valid (partial) match of the pattern.
   * 
   */
  public boolean hasMatch(final AtomicEventPattern pEventPattern) {
    return rawHasMatch(new Object[]{pEventPattern});
  }
  
  /**
   * Returns the number of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @return the number of pattern matches found.
   * 
   */
  public int countMatches(final AtomicEventPattern pEventPattern) {
    return rawCountMatches(new Object[]{pEventPattern});
  }
  
  /**
   * Executes the given processor on each match of the pattern that conforms to the given fixed values of some parameters.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @param processor the action that will process each pattern match.
   * 
   */
  public void forEachMatch(final AtomicEventPattern pEventPattern, final IMatchProcessor<? super AtomicEventPatternMatch> processor) {
    rawForEachMatch(new Object[]{pEventPattern}, processor);
  }
  
  /**
   * Executes the given processor on an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @param processor the action that will process the selected match.
   * @return true if the pattern has at least one match with the given parameter values, false if the processor was not invoked
   * 
   */
  public boolean forOneArbitraryMatch(final AtomicEventPattern pEventPattern, final IMatchProcessor<? super AtomicEventPatternMatch> processor) {
    return rawForOneArbitraryMatch(new Object[]{pEventPattern}, processor);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public AtomicEventPatternMatch newMatch(final AtomicEventPattern pEventPattern) {
    return AtomicEventPatternMatch.newMatch(pEventPattern);
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventPattern.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<AtomicEventPattern> rawAccumulateAllValuesOfeventPattern(final Object[] parameters) {
    Set<AtomicEventPattern> results = new HashSet<AtomicEventPattern>();
    rawAccumulateAllValues(POSITION_EVENTPATTERN, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventPattern.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<AtomicEventPattern> getAllValuesOfeventPattern() {
    return rawAccumulateAllValuesOfeventPattern(emptyArray());
  }
  
  @Override
  protected AtomicEventPatternMatch tupleToMatch(final Tuple t) {
    try {
    	return AtomicEventPatternMatch.newMatch((AtomicEventPattern) t.get(POSITION_EVENTPATTERN));
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in tuple not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected AtomicEventPatternMatch arrayToMatch(final Object[] match) {
    try {
    	return AtomicEventPatternMatch.newMatch((AtomicEventPattern) match[POSITION_EVENTPATTERN]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected AtomicEventPatternMatch arrayToMatchMutable(final Object[] match) {
    try {
    	return AtomicEventPatternMatch.newMutableMatch((AtomicEventPattern) match[POSITION_EVENTPATTERN]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  /**
   * @return the singleton instance of the query specification of this pattern
   * @throws ViatraQueryException if the pattern definition could not be loaded
   * 
   */
  public static IQuerySpecification<AtomicEventPatternMatcher> querySpecification() throws ViatraQueryException {
    return AtomicEventPatternQuerySpecification.instance();
  }
}
