/**
 * 
 *   Copyright (c) 2004-2015, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.compiler;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.viatra.cep.core.engine.compiler.EquivalentTransitionsMatch;
import org.eclipse.viatra.cep.core.engine.compiler.util.EquivalentTransitionsQuerySpecification;
import org.eclipse.viatra.cep.core.metamodels.automaton.State;
import org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseMatcher;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;

/**
 * Generated pattern matcher API of the org.eclipse.viatra.cep.core.engine.compiler.equivalentTransitions pattern,
 * providing pattern-specific query methods.
 * 
 * <p>Use the pattern matcher on a given model via {@link #on(ViatraQueryEngine)},
 * e.g. in conjunction with {@link ViatraQueryEngine#on(Notifier)}.
 * 
 * <p>Matches of the pattern will be represented as {@link EquivalentTransitionsMatch}.
 * 
 * <p>Original source:
 * <code><pre>
 * pattern
 * equivalentTransitions(transition1 : TypedTransition, transition2 : TypedTransition, preState : State, postState : State) {
 * 	transition1 != transition2;
 * 	
 * 	find sameBooleanTransitionType(transition1, transition2);
 * 	
 * 	Transition.preState(transition1, preState);
 * 	Transition.preState(transition2, preState);
 * 
 * 	Transition.postState(transition1, postState);
 * 	Transition.postState(transition2, postState);
 * 
 * 	TypedTransition.guards(transition1, guard1);
 * 	TypedTransition.guards(transition2, guard2);
 * 
 * 	Guard.eventType(guard1, et1);
 * 	Guard.eventType(guard2, et2);
 * 
 * 	et1 == et2;
 * 
 * 	Automaton.states(automaton, preState);
 * 	Automaton.states(automaton, postState);
 * }
 * </pre></code>
 * 
 * @see EquivalentTransitionsMatch
 * @see EquivalentTransitionsProcessor
 * @see EquivalentTransitionsQuerySpecification
 * 
 */
@SuppressWarnings("all")
public class EquivalentTransitionsMatcher extends BaseMatcher<EquivalentTransitionsMatch> {
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static EquivalentTransitionsMatcher on(final ViatraQueryEngine engine) throws ViatraQueryException {
    // check if matcher already exists
    EquivalentTransitionsMatcher matcher = engine.getExistingMatcher(querySpecification());
    if (matcher == null) {
    	matcher = (EquivalentTransitionsMatcher)engine.getMatcher(querySpecification());
    }
    return matcher;
  }
  
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static EquivalentTransitionsMatcher create() throws ViatraQueryException {
    return new EquivalentTransitionsMatcher();
  }
  
  private final static int POSITION_TRANSITION1 = 0;
  
  private final static int POSITION_TRANSITION2 = 1;
  
  private final static int POSITION_PRESTATE = 2;
  
  private final static int POSITION_POSTSTATE = 3;
  
  private final static Logger LOGGER = ViatraQueryLoggingUtil.getLogger(EquivalentTransitionsMatcher.class);
  
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  private EquivalentTransitionsMatcher() throws ViatraQueryException {
    super(querySpecification());
  }
  
  /**
   * Returns the set of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pTransition1 the fixed value of pattern parameter transition1, or null if not bound.
   * @param pTransition2 the fixed value of pattern parameter transition2, or null if not bound.
   * @param pPreState the fixed value of pattern parameter preState, or null if not bound.
   * @param pPostState the fixed value of pattern parameter postState, or null if not bound.
   * @return matches represented as a EquivalentTransitionsMatch object.
   * 
   */
  public Collection<EquivalentTransitionsMatch> getAllMatches(final TypedTransition pTransition1, final TypedTransition pTransition2, final State pPreState, final State pPostState) {
    return rawGetAllMatches(new Object[]{pTransition1, pTransition2, pPreState, pPostState});
  }
  
  /**
   * Returns an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pTransition1 the fixed value of pattern parameter transition1, or null if not bound.
   * @param pTransition2 the fixed value of pattern parameter transition2, or null if not bound.
   * @param pPreState the fixed value of pattern parameter preState, or null if not bound.
   * @param pPostState the fixed value of pattern parameter postState, or null if not bound.
   * @return a match represented as a EquivalentTransitionsMatch object, or null if no match is found.
   * 
   */
  public EquivalentTransitionsMatch getOneArbitraryMatch(final TypedTransition pTransition1, final TypedTransition pTransition2, final State pPreState, final State pPostState) {
    return rawGetOneArbitraryMatch(new Object[]{pTransition1, pTransition2, pPreState, pPostState});
  }
  
  /**
   * Indicates whether the given combination of specified pattern parameters constitute a valid pattern match,
   * under any possible substitution of the unspecified parameters (if any).
   * @param pTransition1 the fixed value of pattern parameter transition1, or null if not bound.
   * @param pTransition2 the fixed value of pattern parameter transition2, or null if not bound.
   * @param pPreState the fixed value of pattern parameter preState, or null if not bound.
   * @param pPostState the fixed value of pattern parameter postState, or null if not bound.
   * @return true if the input is a valid (partial) match of the pattern.
   * 
   */
  public boolean hasMatch(final TypedTransition pTransition1, final TypedTransition pTransition2, final State pPreState, final State pPostState) {
    return rawHasMatch(new Object[]{pTransition1, pTransition2, pPreState, pPostState});
  }
  
  /**
   * Returns the number of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pTransition1 the fixed value of pattern parameter transition1, or null if not bound.
   * @param pTransition2 the fixed value of pattern parameter transition2, or null if not bound.
   * @param pPreState the fixed value of pattern parameter preState, or null if not bound.
   * @param pPostState the fixed value of pattern parameter postState, or null if not bound.
   * @return the number of pattern matches found.
   * 
   */
  public int countMatches(final TypedTransition pTransition1, final TypedTransition pTransition2, final State pPreState, final State pPostState) {
    return rawCountMatches(new Object[]{pTransition1, pTransition2, pPreState, pPostState});
  }
  
  /**
   * Executes the given processor on each match of the pattern that conforms to the given fixed values of some parameters.
   * @param pTransition1 the fixed value of pattern parameter transition1, or null if not bound.
   * @param pTransition2 the fixed value of pattern parameter transition2, or null if not bound.
   * @param pPreState the fixed value of pattern parameter preState, or null if not bound.
   * @param pPostState the fixed value of pattern parameter postState, or null if not bound.
   * @param processor the action that will process each pattern match.
   * 
   */
  public void forEachMatch(final TypedTransition pTransition1, final TypedTransition pTransition2, final State pPreState, final State pPostState, final IMatchProcessor<? super EquivalentTransitionsMatch> processor) {
    rawForEachMatch(new Object[]{pTransition1, pTransition2, pPreState, pPostState}, processor);
  }
  
  /**
   * Executes the given processor on an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pTransition1 the fixed value of pattern parameter transition1, or null if not bound.
   * @param pTransition2 the fixed value of pattern parameter transition2, or null if not bound.
   * @param pPreState the fixed value of pattern parameter preState, or null if not bound.
   * @param pPostState the fixed value of pattern parameter postState, or null if not bound.
   * @param processor the action that will process the selected match.
   * @return true if the pattern has at least one match with the given parameter values, false if the processor was not invoked
   * 
   */
  public boolean forOneArbitraryMatch(final TypedTransition pTransition1, final TypedTransition pTransition2, final State pPreState, final State pPostState, final IMatchProcessor<? super EquivalentTransitionsMatch> processor) {
    return rawForOneArbitraryMatch(new Object[]{pTransition1, pTransition2, pPreState, pPostState}, processor);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pTransition1 the fixed value of pattern parameter transition1, or null if not bound.
   * @param pTransition2 the fixed value of pattern parameter transition2, or null if not bound.
   * @param pPreState the fixed value of pattern parameter preState, or null if not bound.
   * @param pPostState the fixed value of pattern parameter postState, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public EquivalentTransitionsMatch newMatch(final TypedTransition pTransition1, final TypedTransition pTransition2, final State pPreState, final State pPostState) {
    return EquivalentTransitionsMatch.newMatch(pTransition1, pTransition2, pPreState, pPostState);
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition1.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<TypedTransition> rawAccumulateAllValuesOftransition1(final Object[] parameters) {
    Set<TypedTransition> results = new HashSet<TypedTransition>();
    rawAccumulateAllValues(POSITION_TRANSITION1, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition1.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<TypedTransition> getAllValuesOftransition1() {
    return rawAccumulateAllValuesOftransition1(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition1.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<TypedTransition> getAllValuesOftransition1(final EquivalentTransitionsMatch partialMatch) {
    return rawAccumulateAllValuesOftransition1(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition1.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<TypedTransition> getAllValuesOftransition1(final TypedTransition pTransition2, final State pPreState, final State pPostState) {
    return rawAccumulateAllValuesOftransition1(new Object[]{
    null, 
    pTransition2, 
    pPreState, 
    pPostState
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition2.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<TypedTransition> rawAccumulateAllValuesOftransition2(final Object[] parameters) {
    Set<TypedTransition> results = new HashSet<TypedTransition>();
    rawAccumulateAllValues(POSITION_TRANSITION2, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition2.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<TypedTransition> getAllValuesOftransition2() {
    return rawAccumulateAllValuesOftransition2(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition2.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<TypedTransition> getAllValuesOftransition2(final EquivalentTransitionsMatch partialMatch) {
    return rawAccumulateAllValuesOftransition2(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition2.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<TypedTransition> getAllValuesOftransition2(final TypedTransition pTransition1, final State pPreState, final State pPostState) {
    return rawAccumulateAllValuesOftransition2(new Object[]{
    pTransition1, 
    null, 
    pPreState, 
    pPostState
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for preState.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<State> rawAccumulateAllValuesOfpreState(final Object[] parameters) {
    Set<State> results = new HashSet<State>();
    rawAccumulateAllValues(POSITION_PRESTATE, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for preState.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<State> getAllValuesOfpreState() {
    return rawAccumulateAllValuesOfpreState(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for preState.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<State> getAllValuesOfpreState(final EquivalentTransitionsMatch partialMatch) {
    return rawAccumulateAllValuesOfpreState(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for preState.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<State> getAllValuesOfpreState(final TypedTransition pTransition1, final TypedTransition pTransition2, final State pPostState) {
    return rawAccumulateAllValuesOfpreState(new Object[]{
    pTransition1, 
    pTransition2, 
    null, 
    pPostState
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for postState.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<State> rawAccumulateAllValuesOfpostState(final Object[] parameters) {
    Set<State> results = new HashSet<State>();
    rawAccumulateAllValues(POSITION_POSTSTATE, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for postState.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<State> getAllValuesOfpostState() {
    return rawAccumulateAllValuesOfpostState(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for postState.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<State> getAllValuesOfpostState(final EquivalentTransitionsMatch partialMatch) {
    return rawAccumulateAllValuesOfpostState(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for postState.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<State> getAllValuesOfpostState(final TypedTransition pTransition1, final TypedTransition pTransition2, final State pPreState) {
    return rawAccumulateAllValuesOfpostState(new Object[]{
    pTransition1, 
    pTransition2, 
    pPreState, 
    null
    });
  }
  
  @Override
  protected EquivalentTransitionsMatch tupleToMatch(final Tuple t) {
    try {
    	return EquivalentTransitionsMatch.newMatch((TypedTransition) t.get(POSITION_TRANSITION1), (TypedTransition) t.get(POSITION_TRANSITION2), (State) t.get(POSITION_PRESTATE), (State) t.get(POSITION_POSTSTATE));
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in tuple not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected EquivalentTransitionsMatch arrayToMatch(final Object[] match) {
    try {
    	return EquivalentTransitionsMatch.newMatch((TypedTransition) match[POSITION_TRANSITION1], (TypedTransition) match[POSITION_TRANSITION2], (State) match[POSITION_PRESTATE], (State) match[POSITION_POSTSTATE]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected EquivalentTransitionsMatch arrayToMatchMutable(final Object[] match) {
    try {
    	return EquivalentTransitionsMatch.newMutableMatch((TypedTransition) match[POSITION_TRANSITION1], (TypedTransition) match[POSITION_TRANSITION2], (State) match[POSITION_PRESTATE], (State) match[POSITION_POSTSTATE]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  /**
   * @return the singleton instance of the query specification of this pattern
   * @throws ViatraQueryException if the pattern definition could not be loaded
   * 
   */
  public static IQuerySpecification<EquivalentTransitionsMatcher> querySpecification() throws ViatraQueryException {
    return EquivalentTransitionsQuerySpecification.instance();
  }
}
