/**
 * 
 *   Copyright (c) 2004-2015, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.compiler;

import org.eclipse.viatra.cep.core.engine.compiler.AndPatternMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.AtomicEventPatternMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.ComplexAndTransitionMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.ComplexFollowsTransitionMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.ComplexNotTransitionMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.ComplexOrTransitionMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.FollowsPatternMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.NegativeTransitionMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.NonUnfoldedNotTransitionMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.NotPatternMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.OrPatternMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.TranslatedEventPatternMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.util.AndPatternQuerySpecification;
import org.eclipse.viatra.cep.core.engine.compiler.util.AtomicEventPatternQuerySpecification;
import org.eclipse.viatra.cep.core.engine.compiler.util.ComplexAndTransitionQuerySpecification;
import org.eclipse.viatra.cep.core.engine.compiler.util.ComplexFollowsTransitionQuerySpecification;
import org.eclipse.viatra.cep.core.engine.compiler.util.ComplexNotTransitionQuerySpecification;
import org.eclipse.viatra.cep.core.engine.compiler.util.ComplexOrTransitionQuerySpecification;
import org.eclipse.viatra.cep.core.engine.compiler.util.FollowsPatternQuerySpecification;
import org.eclipse.viatra.cep.core.engine.compiler.util.NegativeTransitionQuerySpecification;
import org.eclipse.viatra.cep.core.engine.compiler.util.NonUnfoldedNotTransitionQuerySpecification;
import org.eclipse.viatra.cep.core.engine.compiler.util.NotPatternQuerySpecification;
import org.eclipse.viatra.cep.core.engine.compiler.util.OrPatternQuerySpecification;
import org.eclipse.viatra.cep.core.engine.compiler.util.TranslatedEventPatternQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedPatternGroup;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;

/**
 * A pattern group formed of all patterns defined in mappingPatterns.vql.
 * 
 * <p>Use the static instance as any {@link org.eclipse.viatra.query.runtime.api.IPatternGroup}, to conveniently prepare
 * a VIATRA Query engine for matching all patterns originally defined in file mappingPatterns.vql,
 * in order to achieve better performance than one-by-one on-demand matcher initialization.
 * 
 * <p> From package org.eclipse.viatra.cep.core.engine.compiler, the group contains the definition of the following patterns: <ul>
 * <li>translatedEventPattern</li>
 * <li>atomicEventPattern</li>
 * <li>complexPattern</li>
 * <li>followsPattern</li>
 * <li>orPattern</li>
 * <li>andPattern</li>
 * <li>notPattern</li>
 * <li>complexTransition</li>
 * <li>negativeTransition</li>
 * <li>complexFollowsTransition</li>
 * <li>complexOrTransition</li>
 * <li>complexAndTransition</li>
 * <li>nonUnfoldedNotTransition</li>
 * <li>complexNotTransition</li>
 * </ul>
 * 
 * @see IPatternGroup
 * 
 */
@SuppressWarnings("all")
public final class MappingPatterns extends BaseGeneratedPatternGroup {
  /**
   * Access the pattern group.
   * 
   * @return the singleton instance of the group
   * @throws ViatraQueryException if there was an error loading the generated code of pattern specifications
   * 
   */
  public static MappingPatterns instance() throws ViatraQueryException {
    if (INSTANCE == null) {
    	INSTANCE = new MappingPatterns();
    }
    return INSTANCE;
  }
  
  private static MappingPatterns INSTANCE;
  
  private MappingPatterns() throws ViatraQueryException {
    querySpecifications.add(TranslatedEventPatternQuerySpecification.instance());
    querySpecifications.add(AtomicEventPatternQuerySpecification.instance());
    querySpecifications.add(FollowsPatternQuerySpecification.instance());
    querySpecifications.add(OrPatternQuerySpecification.instance());
    querySpecifications.add(AndPatternQuerySpecification.instance());
    querySpecifications.add(NotPatternQuerySpecification.instance());
    querySpecifications.add(NegativeTransitionQuerySpecification.instance());
    querySpecifications.add(ComplexFollowsTransitionQuerySpecification.instance());
    querySpecifications.add(ComplexOrTransitionQuerySpecification.instance());
    querySpecifications.add(ComplexAndTransitionQuerySpecification.instance());
    querySpecifications.add(NonUnfoldedNotTransitionQuerySpecification.instance());
    querySpecifications.add(ComplexNotTransitionQuerySpecification.instance());
  }
  
  public TranslatedEventPatternQuerySpecification getTranslatedEventPattern() throws ViatraQueryException {
    return TranslatedEventPatternQuerySpecification.instance();
  }
  
  public TranslatedEventPatternMatcher getTranslatedEventPattern(final ViatraQueryEngine engine) throws ViatraQueryException {
    return TranslatedEventPatternMatcher.on(engine);
  }
  
  public AtomicEventPatternQuerySpecification getAtomicEventPattern() throws ViatraQueryException {
    return AtomicEventPatternQuerySpecification.instance();
  }
  
  public AtomicEventPatternMatcher getAtomicEventPattern(final ViatraQueryEngine engine) throws ViatraQueryException {
    return AtomicEventPatternMatcher.on(engine);
  }
  
  public FollowsPatternQuerySpecification getFollowsPattern() throws ViatraQueryException {
    return FollowsPatternQuerySpecification.instance();
  }
  
  public FollowsPatternMatcher getFollowsPattern(final ViatraQueryEngine engine) throws ViatraQueryException {
    return FollowsPatternMatcher.on(engine);
  }
  
  public OrPatternQuerySpecification getOrPattern() throws ViatraQueryException {
    return OrPatternQuerySpecification.instance();
  }
  
  public OrPatternMatcher getOrPattern(final ViatraQueryEngine engine) throws ViatraQueryException {
    return OrPatternMatcher.on(engine);
  }
  
  public AndPatternQuerySpecification getAndPattern() throws ViatraQueryException {
    return AndPatternQuerySpecification.instance();
  }
  
  public AndPatternMatcher getAndPattern(final ViatraQueryEngine engine) throws ViatraQueryException {
    return AndPatternMatcher.on(engine);
  }
  
  public NotPatternQuerySpecification getNotPattern() throws ViatraQueryException {
    return NotPatternQuerySpecification.instance();
  }
  
  public NotPatternMatcher getNotPattern(final ViatraQueryEngine engine) throws ViatraQueryException {
    return NotPatternMatcher.on(engine);
  }
  
  public NegativeTransitionQuerySpecification getNegativeTransition() throws ViatraQueryException {
    return NegativeTransitionQuerySpecification.instance();
  }
  
  public NegativeTransitionMatcher getNegativeTransition(final ViatraQueryEngine engine) throws ViatraQueryException {
    return NegativeTransitionMatcher.on(engine);
  }
  
  public ComplexFollowsTransitionQuerySpecification getComplexFollowsTransition() throws ViatraQueryException {
    return ComplexFollowsTransitionQuerySpecification.instance();
  }
  
  public ComplexFollowsTransitionMatcher getComplexFollowsTransition(final ViatraQueryEngine engine) throws ViatraQueryException {
    return ComplexFollowsTransitionMatcher.on(engine);
  }
  
  public ComplexOrTransitionQuerySpecification getComplexOrTransition() throws ViatraQueryException {
    return ComplexOrTransitionQuerySpecification.instance();
  }
  
  public ComplexOrTransitionMatcher getComplexOrTransition(final ViatraQueryEngine engine) throws ViatraQueryException {
    return ComplexOrTransitionMatcher.on(engine);
  }
  
  public ComplexAndTransitionQuerySpecification getComplexAndTransition() throws ViatraQueryException {
    return ComplexAndTransitionQuerySpecification.instance();
  }
  
  public ComplexAndTransitionMatcher getComplexAndTransition(final ViatraQueryEngine engine) throws ViatraQueryException {
    return ComplexAndTransitionMatcher.on(engine);
  }
  
  public NonUnfoldedNotTransitionQuerySpecification getNonUnfoldedNotTransition() throws ViatraQueryException {
    return NonUnfoldedNotTransitionQuerySpecification.instance();
  }
  
  public NonUnfoldedNotTransitionMatcher getNonUnfoldedNotTransition(final ViatraQueryEngine engine) throws ViatraQueryException {
    return NonUnfoldedNotTransitionMatcher.on(engine);
  }
  
  public ComplexNotTransitionQuerySpecification getComplexNotTransition() throws ViatraQueryException {
    return ComplexNotTransitionQuerySpecification.instance();
  }
  
  public ComplexNotTransitionMatcher getComplexNotTransition(final ViatraQueryEngine engine) throws ViatraQueryException {
    return ComplexNotTransitionMatcher.on(engine);
  }
}
