/**
 * 
 *   Copyright (c) 2004-2015, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.compiler;

import org.eclipse.viatra.cep.core.engine.compiler.EpsilonTransitionMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.EquivalentStatesMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.EquivalentTransitionsMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.SameBooleanTransitionTypeMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.util.EpsilonTransitionQuerySpecification;
import org.eclipse.viatra.cep.core.engine.compiler.util.EquivalentStatesQuerySpecification;
import org.eclipse.viatra.cep.core.engine.compiler.util.EquivalentTransitionsQuerySpecification;
import org.eclipse.viatra.cep.core.engine.compiler.util.SameBooleanTransitionTypeQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedPatternGroup;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;

/**
 * A pattern group formed of all patterns defined in optimizationPatterns.vql.
 * 
 * <p>Use the static instance as any {@link org.eclipse.viatra.query.runtime.api.IPatternGroup}, to conveniently prepare
 * a VIATRA Query engine for matching all patterns originally defined in file optimizationPatterns.vql,
 * in order to achieve better performance than one-by-one on-demand matcher initialization.
 * 
 * <p> From package org.eclipse.viatra.cep.core.engine.compiler, the group contains the definition of the following patterns: <ul>
 * <li>epsilonTransition</li>
 * <li>sameBooleanTransitionType</li>
 * <li>equivalentTransitions</li>
 * <li>equivalentStates</li>
 * </ul>
 * 
 * @see IPatternGroup
 * 
 */
@SuppressWarnings("all")
public final class OptimizationPatterns extends BaseGeneratedPatternGroup {
  /**
   * Access the pattern group.
   * 
   * @return the singleton instance of the group
   * @throws ViatraQueryException if there was an error loading the generated code of pattern specifications
   * 
   */
  public static OptimizationPatterns instance() throws ViatraQueryException {
    if (INSTANCE == null) {
    	INSTANCE = new OptimizationPatterns();
    }
    return INSTANCE;
  }
  
  private static OptimizationPatterns INSTANCE;
  
  private OptimizationPatterns() throws ViatraQueryException {
    querySpecifications.add(EpsilonTransitionQuerySpecification.instance());
    querySpecifications.add(SameBooleanTransitionTypeQuerySpecification.instance());
    querySpecifications.add(EquivalentTransitionsQuerySpecification.instance());
    querySpecifications.add(EquivalentStatesQuerySpecification.instance());
  }
  
  public EpsilonTransitionQuerySpecification getEpsilonTransition() throws ViatraQueryException {
    return EpsilonTransitionQuerySpecification.instance();
  }
  
  public EpsilonTransitionMatcher getEpsilonTransition(final ViatraQueryEngine engine) throws ViatraQueryException {
    return EpsilonTransitionMatcher.on(engine);
  }
  
  public SameBooleanTransitionTypeQuerySpecification getSameBooleanTransitionType() throws ViatraQueryException {
    return SameBooleanTransitionTypeQuerySpecification.instance();
  }
  
  public SameBooleanTransitionTypeMatcher getSameBooleanTransitionType(final ViatraQueryEngine engine) throws ViatraQueryException {
    return SameBooleanTransitionTypeMatcher.on(engine);
  }
  
  public EquivalentTransitionsQuerySpecification getEquivalentTransitions() throws ViatraQueryException {
    return EquivalentTransitionsQuerySpecification.instance();
  }
  
  public EquivalentTransitionsMatcher getEquivalentTransitions(final ViatraQueryEngine engine) throws ViatraQueryException {
    return EquivalentTransitionsMatcher.on(engine);
  }
  
  public EquivalentStatesQuerySpecification getEquivalentStates() throws ViatraQueryException {
    return EquivalentStatesQuerySpecification.instance();
  }
  
  public EquivalentStatesMatcher getEquivalentStates(final ViatraQueryEngine engine) throws ViatraQueryException {
    return EquivalentStatesMatcher.on(engine);
  }
}
