/**
 * Copyright (c) 2004-2015, Istvan David, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Istvan David - initial API and implementation
 */
package org.eclipse.viatra.cep.core.engine.compiler.rules;

import com.google.common.base.Objects;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra.cep.core.engine.compiler.TransformationBasedCompiler;
import org.eclipse.viatra.cep.core.logging.LoggerUtils;
import org.eclipse.viatra.cep.core.metamodels.automaton.Automaton;
import org.eclipse.viatra.cep.core.metamodels.automaton.AutomatonFactory;
import org.eclipse.viatra.cep.core.metamodels.automaton.InitState;
import org.eclipse.viatra.cep.core.metamodels.automaton.InternalModel;
import org.eclipse.viatra.cep.core.metamodels.automaton.State;
import org.eclipse.viatra.cep.core.metamodels.automaton.TrapState;
import org.eclipse.viatra.cep.core.metamodels.events.EventPattern;
import org.eclipse.viatra.cep.core.metamodels.trace.Trace;
import org.eclipse.viatra.cep.core.metamodels.trace.TraceFactory;
import org.eclipse.viatra.cep.core.metamodels.trace.TraceModel;
import org.eclipse.viatra.query.runtime.api.impl.BaseMatcher;
import org.eclipse.viatra.query.runtime.api.impl.BasePatternMatch;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRule;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRuleFactory;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Superclass for specific mapping rules of the {@link TransformationBasedCompiler}.
 */
@SuppressWarnings("all")
public abstract class MappingRules {
  @Extension
  protected final Logger LOGGER = LoggerUtils.getInstance().getLogger();
  
  @Extension
  protected final BatchTransformationRuleFactory ruleFactory = new BatchTransformationRuleFactory();
  
  @Extension
  protected final AutomatonFactory automatonFactory = AutomatonFactory.eINSTANCE;
  
  @Extension
  protected final TraceFactory traceFactory = TraceFactory.eINSTANCE;
  
  private InternalModel internalModel;
  
  private TraceModel traceModel;
  
  public MappingRules(final InternalModel internalModel, final TraceModel traceModel) {
    this.internalModel = internalModel;
    this.traceModel = traceModel;
  }
  
  public abstract List<? extends BatchTransformationRule<? extends BasePatternMatch, ? extends BaseMatcher<? extends BasePatternMatch>>> getAllRules();
  
  public Automaton checkForMappedAutomaton(final EventPattern eventPattern) {
    EList<Trace> _traces = this.traceModel.getTraces();
    boolean _isEmpty = _traces.isEmpty();
    if (_isEmpty) {
      return null;
    } else {
      EList<Trace> _traces_1 = this.traceModel.getTraces();
      final Function1<Trace, Boolean> _function = new Function1<Trace, Boolean>() {
        @Override
        public Boolean apply(final Trace trace) {
          EventPattern _eventPattern = trace.getEventPattern();
          String _id = _eventPattern.getId();
          String _id_1 = eventPattern.getId();
          return Boolean.valueOf(_id.equals(_id_1));
        }
      };
      final Trace existingMapping = IterableExtensions.<Trace>findFirst(_traces_1, _function);
      boolean _equals = Objects.equal(existingMapping, null);
      if (_equals) {
        return null;
      }
      return existingMapping.getAutomaton();
    }
  }
  
  public Automaton initializeAutomaton(final EventPattern eventPattern) {
    Automaton _xblockexpression = null;
    {
      Automaton automaton = this.automatonFactory.createAutomaton();
      EList<Automaton> _automata = this.internalModel.getAutomata();
      _automata.add(automaton);
      String _id = eventPattern.getId();
      automaton.setEventPatternId(_id);
      EList<State> _states = automaton.getStates();
      InitState _createInitState = this.automatonFactory.createInitState();
      _states.add(_createInitState);
      EList<State> _states_1 = automaton.getStates();
      TrapState _createTrapState = this.automatonFactory.createTrapState();
      _states_1.add(_createTrapState);
      _xblockexpression = automaton;
    }
    return _xblockexpression;
  }
  
  public boolean createTrace(final EventPattern eventPattern, final Automaton automaton) {
    boolean _xblockexpression = false;
    {
      Trace trace = this.traceFactory.createTrace();
      trace.setAutomaton(automaton);
      trace.setEventPattern(eventPattern);
      EList<Trace> _traces = this.traceModel.getTraces();
      _xblockexpression = _traces.add(trace);
    }
    return _xblockexpression;
  }
}
