/**
 * 
 *   Copyright (c) 2004-2015, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.compiler.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameterDirection;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.viatra.query.runtime.matchers.tuple.FlatTuple;

/**
 * A pattern-specific query specification that can instantiate ComplexTransitionMatcher in a type-safe way.
 * 
 * @see ComplexTransitionMatcher
 * @see ComplexTransitionMatch
 * 
 */
@SuppressWarnings("all")
final class ComplexTransitionQuerySpecification extends BaseGeneratedEMFQuerySpecification<ViatraQueryMatcher<IPatternMatch>> {
  private ComplexTransitionQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws ViatraQueryException if the pattern definition could not be loaded
   * 
   */
  public static ComplexTransitionQuerySpecification instance() throws ViatraQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected ViatraQueryMatcher instantiate(final ViatraQueryEngine engine) throws ViatraQueryException {
    throw new UnsupportedOperationException();
  }
  
  @Override
  public ViatraQueryMatcher instantiate() throws ViatraQueryException {
    throw new UnsupportedOperationException();
  }
  
  @Override
  public IPatternMatch newEmptyMatch() {
    throw new UnsupportedOperationException();
  }
  
  @Override
  public IPatternMatch newMatch(final Object... parameters) {
    throw new UnsupportedOperationException();
  }
  
  /**
   * Inner class allowing the singleton instance of {@link ComplexTransitionQuerySpecification} to be created 
   * 	<b>not</b> at the class load time of the outer class, 
   * 	but rather at the first call to {@link ComplexTransitionQuerySpecification#instance()}.
   * 
   * <p> This workaround is required e.g. to support recursion.
   * 
   */
  private static class LazyHolder {
    private final static ComplexTransitionQuerySpecification INSTANCE = new ComplexTransitionQuerySpecification();
    
    /**
     * Statically initializes the query specification <b>after</b> the field {@link #INSTANCE} is assigned.
     * This initialization order is required to support indirect recursion.
     * 
     * <p> The static initializer is defined using a helper field to work around limitations of the code generator.
     * 
     */
    private final static Object STATIC_INITIALIZER = ensureInitialized();
    
    public static Object ensureInitialized() {
      INSTANCE.ensureInitializedInternalSneaky();
      return null;
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static ComplexTransitionQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    private final PParameter parameter_pAutomaton = new PParameter("automaton", "org.eclipse.viatra.cep.core.metamodels.automaton.Automaton", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("automaton.meta", "Automaton")), PParameterDirection.INOUT);
    
    private final PParameter parameter_pTransition = new PParameter("transition", "org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("automaton.meta", "TypedTransition")), PParameterDirection.INOUT);
    
    private final PParameter parameter_pEventPattern = new PParameter("eventPattern", "org.eclipse.viatra.cep.core.metamodels.events.ComplexEventPattern", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("cep.meta", "ComplexEventPattern")), PParameterDirection.INOUT);
    
    private final PParameter parameter_pOperator = new PParameter("operator", "org.eclipse.viatra.cep.core.metamodels.events.ComplexEventOperator", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("cep.meta", "ComplexEventOperator")), PParameterDirection.INOUT);
    
    private final List<PParameter> parameters = Arrays.asList(parameter_pAutomaton, parameter_pTransition, parameter_pEventPattern, parameter_pOperator);
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.cep.core.engine.compiler.complexTransition";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("automaton","transition","eventPattern","operator");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return parameters;
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      setEvaluationHints(new QueryEvaluationHint(null, Collections.<String,Object>emptyMap()));
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_automaton = body.getOrCreateVariableByName("automaton");
      		PVariable var_transition = body.getOrCreateVariableByName("transition");
      		PVariable var_eventPattern = body.getOrCreateVariableByName("eventPattern");
      		PVariable var_operator = body.getOrCreateVariableByName("operator");
      		PVariable var_preState = body.getOrCreateVariableByName("preState");
      		PVariable var_postState = body.getOrCreateVariableByName("postState");
      		PVariable var_guard = body.getOrCreateVariableByName("guard");
      		new TypeConstraint(body, new FlatTuple(var_automaton), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		new TypeConstraint(body, new FlatTuple(var_transition), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "TypedTransition")));
      		new TypeConstraint(body, new FlatTuple(var_eventPattern), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("cep.meta", "ComplexEventPattern")));
      		new TypeConstraint(body, new FlatTuple(var_operator), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("cep.meta", "ComplexEventOperator")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_automaton, parameter_pAutomaton),
      		   new ExportedParameter(body, var_transition, parameter_pTransition),
      		   new ExportedParameter(body, var_eventPattern, parameter_pEventPattern),
      		   new ExportedParameter(body, var_operator, parameter_pOperator)
      		));
      		// 	Automaton.states(automaton, preState)
      		new TypeConstraint(body, new FlatTuple(var_automaton), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var_automaton, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Automaton", "states")));
      		new Equality(body, var__virtual_0_, var_preState);
      		// 	Automaton.states(automaton, postState)
      		new TypeConstraint(body, new FlatTuple(var_automaton), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      		new TypeConstraint(body, new FlatTuple(var_automaton, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Automaton", "states")));
      		new Equality(body, var__virtual_1_, var_postState);
      		// 	State.outTransitions(preState, transition)
      		new TypeConstraint(body, new FlatTuple(var_preState), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "State")));
      		PVariable var__virtual_2_ = body.getOrCreateVariableByName(".virtual{2}");
      		new TypeConstraint(body, new FlatTuple(var_preState, var__virtual_2_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "State", "outTransitions")));
      		new Equality(body, var__virtual_2_, var_transition);
      		// 	State.inTransitions(postState, transition)
      		new TypeConstraint(body, new FlatTuple(var_postState), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "State")));
      		PVariable var__virtual_3_ = body.getOrCreateVariableByName(".virtual{3}");
      		new TypeConstraint(body, new FlatTuple(var_postState, var__virtual_3_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "State", "inTransitions")));
      		new Equality(body, var__virtual_3_, var_transition);
      		// 	TypedTransition.guards(transition, guard)
      		new TypeConstraint(body, new FlatTuple(var_transition), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "TypedTransition")));
      		PVariable var__virtual_4_ = body.getOrCreateVariableByName(".virtual{4}");
      		new TypeConstraint(body, new FlatTuple(var_transition, var__virtual_4_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "TypedTransition", "guards")));
      		new Equality(body, var__virtual_4_, var_guard);
      		// 	Guard.eventType(guard, eventPattern)
      		new TypeConstraint(body, new FlatTuple(var_guard), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Guard")));
      		PVariable var__virtual_5_ = body.getOrCreateVariableByName(".virtual{5}");
      		new TypeConstraint(body, new FlatTuple(var_guard, var__virtual_5_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Guard", "eventType")));
      		new Equality(body, var__virtual_5_, var_eventPattern);
      		// 	ComplexEventPattern.operator(eventPattern, operator)
      		new TypeConstraint(body, new FlatTuple(var_eventPattern), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("cep.meta", "ComplexEventPattern")));
      		PVariable var__virtual_6_ = body.getOrCreateVariableByName(".virtual{6}");
      		new TypeConstraint(body, new FlatTuple(var_eventPattern, var__virtual_6_), new EStructuralFeatureInstancesKey(getFeatureLiteral("cep.meta", "ComplexEventPattern", "operator")));
      		new Equality(body, var__virtual_6_, var_operator);
      		bodies.add(body);
      	}
      	// to silence compiler error
      	if (false) throw new ViatraQueryException("Never", "happens");
      } catch (ViatraQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
