/**
 * 
 *   Copyright (c) 2004-2015, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.compiler.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.viatra.cep.core.engine.compiler.EpsilonTransitionMatch;
import org.eclipse.viatra.cep.core.engine.compiler.EpsilonTransitionMatcher;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameterDirection;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.viatra.query.runtime.matchers.tuple.FlatTuple;

/**
 * A pattern-specific query specification that can instantiate EpsilonTransitionMatcher in a type-safe way.
 * 
 * @see EpsilonTransitionMatcher
 * @see EpsilonTransitionMatch
 * 
 */
@SuppressWarnings("all")
public final class EpsilonTransitionQuerySpecification extends BaseGeneratedEMFQuerySpecification<EpsilonTransitionMatcher> {
  private EpsilonTransitionQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws ViatraQueryException if the pattern definition could not be loaded
   * 
   */
  public static EpsilonTransitionQuerySpecification instance() throws ViatraQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected EpsilonTransitionMatcher instantiate(final ViatraQueryEngine engine) throws ViatraQueryException {
    return EpsilonTransitionMatcher.on(engine);
  }
  
  @Override
  public EpsilonTransitionMatcher instantiate() throws ViatraQueryException {
    return EpsilonTransitionMatcher.create();
  }
  
  @Override
  public EpsilonTransitionMatch newEmptyMatch() {
    return EpsilonTransitionMatch.newEmptyMatch();
  }
  
  @Override
  public EpsilonTransitionMatch newMatch(final Object... parameters) {
    return EpsilonTransitionMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.automaton.Automaton) parameters[0], (org.eclipse.viatra.cep.core.metamodels.automaton.EpsilonTransition) parameters[1], (org.eclipse.viatra.cep.core.metamodels.automaton.State) parameters[2], (org.eclipse.viatra.cep.core.metamodels.automaton.State) parameters[3]);
  }
  
  /**
   * Inner class allowing the singleton instance of {@link EpsilonTransitionQuerySpecification} to be created 
   * 	<b>not</b> at the class load time of the outer class, 
   * 	but rather at the first call to {@link EpsilonTransitionQuerySpecification#instance()}.
   * 
   * <p> This workaround is required e.g. to support recursion.
   * 
   */
  private static class LazyHolder {
    private final static EpsilonTransitionQuerySpecification INSTANCE = new EpsilonTransitionQuerySpecification();
    
    /**
     * Statically initializes the query specification <b>after</b> the field {@link #INSTANCE} is assigned.
     * This initialization order is required to support indirect recursion.
     * 
     * <p> The static initializer is defined using a helper field to work around limitations of the code generator.
     * 
     */
    private final static Object STATIC_INITIALIZER = ensureInitialized();
    
    public static Object ensureInitialized() {
      INSTANCE.ensureInitializedInternalSneaky();
      return null;
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static EpsilonTransitionQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    private final PParameter parameter_pAutomaton = new PParameter("automaton", "org.eclipse.viatra.cep.core.metamodels.automaton.Automaton", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("automaton.meta", "Automaton")), PParameterDirection.INOUT);
    
    private final PParameter parameter_pTransition = new PParameter("transition", "org.eclipse.viatra.cep.core.metamodels.automaton.EpsilonTransition", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("automaton.meta", "EpsilonTransition")), PParameterDirection.INOUT);
    
    private final PParameter parameter_pPreState = new PParameter("preState", "org.eclipse.viatra.cep.core.metamodels.automaton.State", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("automaton.meta", "State")), PParameterDirection.INOUT);
    
    private final PParameter parameter_pPostState = new PParameter("postState", "org.eclipse.viatra.cep.core.metamodels.automaton.State", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("automaton.meta", "State")), PParameterDirection.INOUT);
    
    private final List<PParameter> parameters = Arrays.asList(parameter_pAutomaton, parameter_pTransition, parameter_pPreState, parameter_pPostState);
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.cep.core.engine.compiler.epsilonTransition";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("automaton","transition","preState","postState");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return parameters;
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      setEvaluationHints(new QueryEvaluationHint(null, Collections.<String,Object>emptyMap()));
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_automaton = body.getOrCreateVariableByName("automaton");
      		PVariable var_transition = body.getOrCreateVariableByName("transition");
      		PVariable var_preState = body.getOrCreateVariableByName("preState");
      		PVariable var_postState = body.getOrCreateVariableByName("postState");
      		new TypeConstraint(body, new FlatTuple(var_automaton), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		new TypeConstraint(body, new FlatTuple(var_transition), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "EpsilonTransition")));
      		new TypeConstraint(body, new FlatTuple(var_preState), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "State")));
      		new TypeConstraint(body, new FlatTuple(var_postState), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "State")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_automaton, parameter_pAutomaton),
      		   new ExportedParameter(body, var_transition, parameter_pTransition),
      		   new ExportedParameter(body, var_preState, parameter_pPreState),
      		   new ExportedParameter(body, var_postState, parameter_pPostState)
      		));
      		// 	Automaton.states(automaton, preState)
      		new TypeConstraint(body, new FlatTuple(var_automaton), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var_automaton, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Automaton", "states")));
      		new Equality(body, var__virtual_0_, var_preState);
      		// 	Automaton.states(automaton, postState)
      		new TypeConstraint(body, new FlatTuple(var_automaton), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      		new TypeConstraint(body, new FlatTuple(var_automaton, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Automaton", "states")));
      		new Equality(body, var__virtual_1_, var_postState);
      		// 	State.outTransitions(preState, transition)
      		new TypeConstraint(body, new FlatTuple(var_preState), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "State")));
      		PVariable var__virtual_2_ = body.getOrCreateVariableByName(".virtual{2}");
      		new TypeConstraint(body, new FlatTuple(var_preState, var__virtual_2_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "State", "outTransitions")));
      		new Equality(body, var__virtual_2_, var_transition);
      		// 	State.inTransitions(postState, transition)
      		new TypeConstraint(body, new FlatTuple(var_postState), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "State")));
      		PVariable var__virtual_3_ = body.getOrCreateVariableByName(".virtual{3}");
      		new TypeConstraint(body, new FlatTuple(var_postState, var__virtual_3_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "State", "inTransitions")));
      		new Equality(body, var__virtual_3_, var_transition);
      		bodies.add(body);
      	}
      	// to silence compiler error
      	if (false) throw new ViatraQueryException("Never", "happens");
      } catch (ViatraQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
