/**
 * 
 *   Copyright (c) 2004-2014, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.runtime;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.viatra.cep.core.engine.runtime.EnabledNegativeTransitionMatch;
import org.eclipse.viatra.cep.core.engine.runtime.util.EnabledNegativeTransitionQuerySpecification;
import org.eclipse.viatra.cep.core.metamodels.automaton.Automaton;
import org.eclipse.viatra.cep.core.metamodels.automaton.EventToken;
import org.eclipse.viatra.cep.core.metamodels.automaton.NegativeTransition;
import org.eclipse.viatra.cep.core.metamodels.events.Event;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseMatcher;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;

/**
 * Generated pattern matcher API of the org.eclipse.viatra.cep.core.engine.runtime.enabledNegativeTransition pattern,
 * providing pattern-specific query methods.
 * 
 * <p>Use the pattern matcher on a given model via {@link #on(ViatraQueryEngine)},
 * e.g. in conjunction with {@link ViatraQueryEngine#on(Notifier)}.
 * 
 * <p>Matches of the pattern will be represented as {@link EnabledNegativeTransitionMatch}.
 * 
 * <p>Original source:
 * <code><pre>
 * pattern enabledNegativeTransition(transition : NegativeTransition, eventToken : EventToken, event : Event, automaton : Automaton) {
 * 	find latestEvent(event);
 * 	Event.type(event, eventType);
 * 	neg find transitionWithEventType(transition, eventType);
 * 	NegativeTransition.preState.eventTokens(transition, eventToken);
 * 	neg find eventProcessedByEventToken(event, eventToken);
 * 	
 * 	Automaton.states(automaton, state);
 * 	State.outTransitions(state, transition);
 * }
 * </pre></code>
 * 
 * @see EnabledNegativeTransitionMatch
 * @see EnabledNegativeTransitionProcessor
 * @see EnabledNegativeTransitionQuerySpecification
 * 
 */
@SuppressWarnings("all")
public class EnabledNegativeTransitionMatcher extends BaseMatcher<EnabledNegativeTransitionMatch> {
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static EnabledNegativeTransitionMatcher on(final ViatraQueryEngine engine) throws ViatraQueryException {
    // check if matcher already exists
    EnabledNegativeTransitionMatcher matcher = engine.getExistingMatcher(querySpecification());
    if (matcher == null) {
    	matcher = (EnabledNegativeTransitionMatcher)engine.getMatcher(querySpecification());
    }
    return matcher;
  }
  
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static EnabledNegativeTransitionMatcher create() throws ViatraQueryException {
    return new EnabledNegativeTransitionMatcher();
  }
  
  private final static int POSITION_TRANSITION = 0;
  
  private final static int POSITION_EVENTTOKEN = 1;
  
  private final static int POSITION_EVENT = 2;
  
  private final static int POSITION_AUTOMATON = 3;
  
  private final static Logger LOGGER = ViatraQueryLoggingUtil.getLogger(EnabledNegativeTransitionMatcher.class);
  
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  private EnabledNegativeTransitionMatcher() throws ViatraQueryException {
    super(querySpecification());
  }
  
  /**
   * Returns the set of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pEvent the fixed value of pattern parameter event, or null if not bound.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @return matches represented as a EnabledNegativeTransitionMatch object.
   * 
   */
  public Collection<EnabledNegativeTransitionMatch> getAllMatches(final NegativeTransition pTransition, final EventToken pEventToken, final Event pEvent, final Automaton pAutomaton) {
    return rawGetAllMatches(new Object[]{pTransition, pEventToken, pEvent, pAutomaton});
  }
  
  /**
   * Returns an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pEvent the fixed value of pattern parameter event, or null if not bound.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @return a match represented as a EnabledNegativeTransitionMatch object, or null if no match is found.
   * 
   */
  public EnabledNegativeTransitionMatch getOneArbitraryMatch(final NegativeTransition pTransition, final EventToken pEventToken, final Event pEvent, final Automaton pAutomaton) {
    return rawGetOneArbitraryMatch(new Object[]{pTransition, pEventToken, pEvent, pAutomaton});
  }
  
  /**
   * Indicates whether the given combination of specified pattern parameters constitute a valid pattern match,
   * under any possible substitution of the unspecified parameters (if any).
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pEvent the fixed value of pattern parameter event, or null if not bound.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @return true if the input is a valid (partial) match of the pattern.
   * 
   */
  public boolean hasMatch(final NegativeTransition pTransition, final EventToken pEventToken, final Event pEvent, final Automaton pAutomaton) {
    return rawHasMatch(new Object[]{pTransition, pEventToken, pEvent, pAutomaton});
  }
  
  /**
   * Returns the number of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pEvent the fixed value of pattern parameter event, or null if not bound.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @return the number of pattern matches found.
   * 
   */
  public int countMatches(final NegativeTransition pTransition, final EventToken pEventToken, final Event pEvent, final Automaton pAutomaton) {
    return rawCountMatches(new Object[]{pTransition, pEventToken, pEvent, pAutomaton});
  }
  
  /**
   * Executes the given processor on each match of the pattern that conforms to the given fixed values of some parameters.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pEvent the fixed value of pattern parameter event, or null if not bound.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param processor the action that will process each pattern match.
   * 
   */
  public void forEachMatch(final NegativeTransition pTransition, final EventToken pEventToken, final Event pEvent, final Automaton pAutomaton, final IMatchProcessor<? super EnabledNegativeTransitionMatch> processor) {
    rawForEachMatch(new Object[]{pTransition, pEventToken, pEvent, pAutomaton}, processor);
  }
  
  /**
   * Executes the given processor on an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pEvent the fixed value of pattern parameter event, or null if not bound.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param processor the action that will process the selected match.
   * @return true if the pattern has at least one match with the given parameter values, false if the processor was not invoked
   * 
   */
  public boolean forOneArbitraryMatch(final NegativeTransition pTransition, final EventToken pEventToken, final Event pEvent, final Automaton pAutomaton, final IMatchProcessor<? super EnabledNegativeTransitionMatch> processor) {
    return rawForOneArbitraryMatch(new Object[]{pTransition, pEventToken, pEvent, pAutomaton}, processor);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pEvent the fixed value of pattern parameter event, or null if not bound.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public EnabledNegativeTransitionMatch newMatch(final NegativeTransition pTransition, final EventToken pEventToken, final Event pEvent, final Automaton pAutomaton) {
    return EnabledNegativeTransitionMatch.newMatch(pTransition, pEventToken, pEvent, pAutomaton);
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<NegativeTransition> rawAccumulateAllValuesOftransition(final Object[] parameters) {
    Set<NegativeTransition> results = new HashSet<NegativeTransition>();
    rawAccumulateAllValues(POSITION_TRANSITION, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<NegativeTransition> getAllValuesOftransition() {
    return rawAccumulateAllValuesOftransition(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<NegativeTransition> getAllValuesOftransition(final EnabledNegativeTransitionMatch partialMatch) {
    return rawAccumulateAllValuesOftransition(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<NegativeTransition> getAllValuesOftransition(final EventToken pEventToken, final Event pEvent, final Automaton pAutomaton) {
    return rawAccumulateAllValuesOftransition(new Object[]{
    null, 
    pEventToken, 
    pEvent, 
    pAutomaton
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventToken.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<EventToken> rawAccumulateAllValuesOfeventToken(final Object[] parameters) {
    Set<EventToken> results = new HashSet<EventToken>();
    rawAccumulateAllValues(POSITION_EVENTTOKEN, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventToken.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<EventToken> getAllValuesOfeventToken() {
    return rawAccumulateAllValuesOfeventToken(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventToken.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<EventToken> getAllValuesOfeventToken(final EnabledNegativeTransitionMatch partialMatch) {
    return rawAccumulateAllValuesOfeventToken(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventToken.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<EventToken> getAllValuesOfeventToken(final NegativeTransition pTransition, final Event pEvent, final Automaton pAutomaton) {
    return rawAccumulateAllValuesOfeventToken(new Object[]{
    pTransition, 
    null, 
    pEvent, 
    pAutomaton
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for event.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<Event> rawAccumulateAllValuesOfevent(final Object[] parameters) {
    Set<Event> results = new HashSet<Event>();
    rawAccumulateAllValues(POSITION_EVENT, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for event.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Event> getAllValuesOfevent() {
    return rawAccumulateAllValuesOfevent(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for event.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Event> getAllValuesOfevent(final EnabledNegativeTransitionMatch partialMatch) {
    return rawAccumulateAllValuesOfevent(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for event.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Event> getAllValuesOfevent(final NegativeTransition pTransition, final EventToken pEventToken, final Automaton pAutomaton) {
    return rawAccumulateAllValuesOfevent(new Object[]{
    pTransition, 
    pEventToken, 
    null, 
    pAutomaton
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for automaton.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<Automaton> rawAccumulateAllValuesOfautomaton(final Object[] parameters) {
    Set<Automaton> results = new HashSet<Automaton>();
    rawAccumulateAllValues(POSITION_AUTOMATON, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for automaton.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Automaton> getAllValuesOfautomaton() {
    return rawAccumulateAllValuesOfautomaton(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for automaton.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Automaton> getAllValuesOfautomaton(final EnabledNegativeTransitionMatch partialMatch) {
    return rawAccumulateAllValuesOfautomaton(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for automaton.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Automaton> getAllValuesOfautomaton(final NegativeTransition pTransition, final EventToken pEventToken, final Event pEvent) {
    return rawAccumulateAllValuesOfautomaton(new Object[]{
    pTransition, 
    pEventToken, 
    pEvent, 
    null
    });
  }
  
  @Override
  protected EnabledNegativeTransitionMatch tupleToMatch(final Tuple t) {
    try {
    	return EnabledNegativeTransitionMatch.newMatch((NegativeTransition) t.get(POSITION_TRANSITION), (EventToken) t.get(POSITION_EVENTTOKEN), (Event) t.get(POSITION_EVENT), (Automaton) t.get(POSITION_AUTOMATON));
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in tuple not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected EnabledNegativeTransitionMatch arrayToMatch(final Object[] match) {
    try {
    	return EnabledNegativeTransitionMatch.newMatch((NegativeTransition) match[POSITION_TRANSITION], (EventToken) match[POSITION_EVENTTOKEN], (Event) match[POSITION_EVENT], (Automaton) match[POSITION_AUTOMATON]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected EnabledNegativeTransitionMatch arrayToMatchMutable(final Object[] match) {
    try {
    	return EnabledNegativeTransitionMatch.newMutableMatch((NegativeTransition) match[POSITION_TRANSITION], (EventToken) match[POSITION_EVENTTOKEN], (Event) match[POSITION_EVENT], (Automaton) match[POSITION_AUTOMATON]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  /**
   * @return the singleton instance of the query specification of this pattern
   * @throws ViatraQueryException if the pattern definition could not be loaded
   * 
   */
  public static IQuerySpecification<EnabledNegativeTransitionMatcher> querySpecification() throws ViatraQueryException {
    return EnabledNegativeTransitionQuerySpecification.instance();
  }
}
