/**
 * 
 *   Copyright (c) 2004-2014, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.runtime;

import java.util.Arrays;
import java.util.List;
import org.eclipse.viatra.cep.core.engine.runtime.util.PartiallyMatchedEventPatternQuerySpecification;
import org.eclipse.viatra.cep.core.metamodels.automaton.Automaton;
import org.eclipse.viatra.cep.core.metamodels.automaton.EventToken;
import org.eclipse.viatra.cep.core.metamodels.automaton.State;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.impl.BasePatternMatch;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;

/**
 * Pattern-specific match representation of the org.eclipse.viatra.cep.core.engine.runtime.partiallyMatchedEventPattern pattern,
 * to be used in conjunction with {@link PartiallyMatchedEventPatternMatcher}.
 * 
 * <p>Class fields correspond to parameters of the pattern. Fields with value null are considered unassigned.
 * Each instance is a (possibly partial) substitution of pattern parameters,
 * usable to represent a match of the pattern in the result of a query,
 * or to specify the bound (fixed) input parameters when issuing a query.
 * 
 * @see PartiallyMatchedEventPatternMatcher
 * @see PartiallyMatchedEventPatternProcessor
 * 
 */
@SuppressWarnings("all")
public abstract class PartiallyMatchedEventPatternMatch extends BasePatternMatch {
  private Automaton fAutomaton;
  
  private EventToken fEventToken;
  
  private State fState;
  
  private static List<String> parameterNames = makeImmutableList("automaton", "eventToken", "state");
  
  private PartiallyMatchedEventPatternMatch(final Automaton pAutomaton, final EventToken pEventToken, final State pState) {
    this.fAutomaton = pAutomaton;
    this.fEventToken = pEventToken;
    this.fState = pState;
  }
  
  @Override
  public Object get(final String parameterName) {
    if ("automaton".equals(parameterName)) return this.fAutomaton;
    if ("eventToken".equals(parameterName)) return this.fEventToken;
    if ("state".equals(parameterName)) return this.fState;
    return null;
  }
  
  public Automaton getAutomaton() {
    return this.fAutomaton;
  }
  
  public EventToken getEventToken() {
    return this.fEventToken;
  }
  
  public State getState() {
    return this.fState;
  }
  
  @Override
  public boolean set(final String parameterName, final Object newValue) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    if ("automaton".equals(parameterName) ) {
    	this.fAutomaton = (Automaton) newValue;
    	return true;
    }
    if ("eventToken".equals(parameterName) ) {
    	this.fEventToken = (EventToken) newValue;
    	return true;
    }
    if ("state".equals(parameterName) ) {
    	this.fState = (State) newValue;
    	return true;
    }
    return false;
  }
  
  public void setAutomaton(final Automaton pAutomaton) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fAutomaton = pAutomaton;
  }
  
  public void setEventToken(final EventToken pEventToken) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fEventToken = pEventToken;
  }
  
  public void setState(final State pState) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fState = pState;
  }
  
  @Override
  public String patternName() {
    return "org.eclipse.viatra.cep.core.engine.runtime.partiallyMatchedEventPattern";
  }
  
  @Override
  public List<String> parameterNames() {
    return PartiallyMatchedEventPatternMatch.parameterNames;
  }
  
  @Override
  public Object[] toArray() {
    return new Object[]{fAutomaton, fEventToken, fState};
  }
  
  @Override
  public PartiallyMatchedEventPatternMatch toImmutable() {
    return isMutable() ? newMatch(fAutomaton, fEventToken, fState) : this;
  }
  
  @Override
  public String prettyPrint() {
    StringBuilder result = new StringBuilder();
    result.append("\"automaton\"=" + prettyPrintValue(fAutomaton) + ", ");
    
    result.append("\"eventToken\"=" + prettyPrintValue(fEventToken) + ", ");
    
    result.append("\"state\"=" + prettyPrintValue(fState)
    );
    return result.toString();
  }
  
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((fAutomaton == null) ? 0 : fAutomaton.hashCode());
    result = prime * result + ((fEventToken == null) ? 0 : fEventToken.hashCode());
    result = prime * result + ((fState == null) ? 0 : fState.hashCode());
    return result;
  }
  
  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
    	return true;
    if (!(obj instanceof PartiallyMatchedEventPatternMatch)) { // this should be infrequent
    	if (obj == null) {
    		return false;
    	}
    	if (!(obj instanceof IPatternMatch)) {
    		return false;
    	}
    	IPatternMatch otherSig  = (IPatternMatch) obj;
    	if (!specification().equals(otherSig.specification()))
    		return false;
    	return Arrays.deepEquals(toArray(), otherSig.toArray());
    }
    PartiallyMatchedEventPatternMatch other = (PartiallyMatchedEventPatternMatch) obj;
    if (fAutomaton == null) {if (other.fAutomaton != null) return false;}
    else if (!fAutomaton.equals(other.fAutomaton)) return false;
    if (fEventToken == null) {if (other.fEventToken != null) return false;}
    else if (!fEventToken.equals(other.fEventToken)) return false;
    if (fState == null) {if (other.fState != null) return false;}
    else if (!fState.equals(other.fState)) return false;
    return true;
  }
  
  @Override
  public PartiallyMatchedEventPatternQuerySpecification specification() {
    try {
    	return PartiallyMatchedEventPatternQuerySpecification.instance();
    } catch (ViatraQueryException ex) {
     	// This cannot happen, as the match object can only be instantiated if the query specification exists
     	throw new IllegalStateException (ex);
    }
  }
  
  /**
   * Returns an empty, mutable match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @return the empty match.
   * 
   */
  public static PartiallyMatchedEventPatternMatch newEmptyMatch() {
    return new Mutable(null, null, null);
  }
  
  /**
   * Returns a mutable (partial) match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pState the fixed value of pattern parameter state, or null if not bound.
   * @return the new, mutable (partial) match object.
   * 
   */
  public static PartiallyMatchedEventPatternMatch newMutableMatch(final Automaton pAutomaton, final EventToken pEventToken, final State pState) {
    return new Mutable(pAutomaton, pEventToken, pState);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pState the fixed value of pattern parameter state, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public static PartiallyMatchedEventPatternMatch newMatch(final Automaton pAutomaton, final EventToken pEventToken, final State pState) {
    return new Immutable(pAutomaton, pEventToken, pState);
  }
  
  private static final class Mutable extends PartiallyMatchedEventPatternMatch {
    Mutable(final Automaton pAutomaton, final EventToken pEventToken, final State pState) {
      super(pAutomaton, pEventToken, pState);
    }
    
    @Override
    public boolean isMutable() {
      return true;
    }
  }
  
  private static final class Immutable extends PartiallyMatchedEventPatternMatch {
    Immutable(final Automaton pAutomaton, final EventToken pEventToken, final State pState) {
      super(pAutomaton, pEventToken, pState);
    }
    
    @Override
    public boolean isMutable() {
      return false;
    }
  }
}
