/**
 * 
 *   Copyright (c) 2004-2014, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.runtime.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.viatra.cep.core.engine.runtime.FinishedAutomatonMatch;
import org.eclipse.viatra.cep.core.engine.runtime.FinishedAutomatonMatcher;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameterDirection;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.viatra.query.runtime.matchers.tuple.FlatTuple;

/**
 * A pattern-specific query specification that can instantiate FinishedAutomatonMatcher in a type-safe way.
 * 
 * @see FinishedAutomatonMatcher
 * @see FinishedAutomatonMatch
 * 
 */
@SuppressWarnings("all")
public final class FinishedAutomatonQuerySpecification extends BaseGeneratedEMFQuerySpecification<FinishedAutomatonMatcher> {
  private FinishedAutomatonQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws ViatraQueryException if the pattern definition could not be loaded
   * 
   */
  public static FinishedAutomatonQuerySpecification instance() throws ViatraQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected FinishedAutomatonMatcher instantiate(final ViatraQueryEngine engine) throws ViatraQueryException {
    return FinishedAutomatonMatcher.on(engine);
  }
  
  @Override
  public FinishedAutomatonMatcher instantiate() throws ViatraQueryException {
    return FinishedAutomatonMatcher.create();
  }
  
  @Override
  public FinishedAutomatonMatch newEmptyMatch() {
    return FinishedAutomatonMatch.newEmptyMatch();
  }
  
  @Override
  public FinishedAutomatonMatch newMatch(final Object... parameters) {
    return FinishedAutomatonMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.automaton.Automaton) parameters[0], (org.eclipse.viatra.cep.core.metamodels.automaton.EventToken) parameters[1]);
  }
  
  /**
   * Inner class allowing the singleton instance of {@link FinishedAutomatonQuerySpecification} to be created 
   * 	<b>not</b> at the class load time of the outer class, 
   * 	but rather at the first call to {@link FinishedAutomatonQuerySpecification#instance()}.
   * 
   * <p> This workaround is required e.g. to support recursion.
   * 
   */
  private static class LazyHolder {
    private final static FinishedAutomatonQuerySpecification INSTANCE = new FinishedAutomatonQuerySpecification();
    
    /**
     * Statically initializes the query specification <b>after</b> the field {@link #INSTANCE} is assigned.
     * This initialization order is required to support indirect recursion.
     * 
     * <p> The static initializer is defined using a helper field to work around limitations of the code generator.
     * 
     */
    private final static Object STATIC_INITIALIZER = ensureInitialized();
    
    public static Object ensureInitialized() {
      INSTANCE.ensureInitializedInternalSneaky();
      return null;
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static FinishedAutomatonQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    private final PParameter parameter_pAutomaton = new PParameter("automaton", "org.eclipse.viatra.cep.core.metamodels.automaton.Automaton", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("automaton.meta", "Automaton")), PParameterDirection.INOUT);
    
    private final PParameter parameter_pEventToken = new PParameter("eventToken", "org.eclipse.viatra.cep.core.metamodels.automaton.EventToken", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("automaton.meta", "EventToken")), PParameterDirection.INOUT);
    
    private final List<PParameter> parameters = Arrays.asList(parameter_pAutomaton, parameter_pEventToken);
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.cep.core.engine.runtime.finishedAutomaton";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("automaton","eventToken");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return parameters;
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      setEvaluationHints(new QueryEvaluationHint(null, Collections.<String,Object>emptyMap()));
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_automaton = body.getOrCreateVariableByName("automaton");
      		PVariable var_eventToken = body.getOrCreateVariableByName("eventToken");
      		PVariable var_finalState = body.getOrCreateVariableByName("finalState");
      		new TypeConstraint(body, new FlatTuple(var_automaton), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		new TypeConstraint(body, new FlatTuple(var_eventToken), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "EventToken")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_automaton, parameter_pAutomaton),
      		   new ExportedParameter(body, var_eventToken, parameter_pEventToken)
      		));
      		// 	Automaton.finalStates(automaton, finalState)
      		new TypeConstraint(body, new FlatTuple(var_automaton), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var_automaton, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Automaton", "finalStates")));
      		new Equality(body, var__virtual_0_, var_finalState);
      		// 	EventToken.currentState(eventToken, finalState)
      		new TypeConstraint(body, new FlatTuple(var_eventToken), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "EventToken")));
      		PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      		new TypeConstraint(body, new FlatTuple(var_eventToken, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "EventToken", "currentState")));
      		new Equality(body, var__virtual_1_, var_finalState);
      		bodies.add(body);
      	}
      	// to silence compiler error
      	if (false) throw new ViatraQueryException("Never", "happens");
      } catch (ViatraQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
