/**
 * 
 *   Copyright (c) 2004-2014, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.runtime.util;

import org.eclipse.viatra.cep.core.engine.runtime.InitStateMatch;
import org.eclipse.viatra.cep.core.metamodels.automaton.Automaton;
import org.eclipse.viatra.cep.core.metamodels.automaton.InitState;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;

/**
 * A match processor tailored for the org.eclipse.viatra.cep.core.engine.runtime.initState pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class InitStateProcessor implements IMatchProcessor<InitStateMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pAutomaton the value of pattern parameter automaton in the currently processed match
   * @param pInitState the value of pattern parameter initState in the currently processed match
   * 
   */
  public abstract void process(final Automaton pAutomaton, final InitState pInitState);
  
  @Override
  public void process(final InitStateMatch match) {
    process(match.getAutomaton(), match.getInitState());
  }
}
