/**
 * 
 *   Copyright (c) 2004-2014, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.runtime.util;

import org.eclipse.viatra.cep.core.engine.runtime.TokenEntersTimedZoneMatch;
import org.eclipse.viatra.cep.core.metamodels.automaton.EventToken;
import org.eclipse.viatra.cep.core.metamodels.automaton.State;
import org.eclipse.viatra.cep.core.metamodels.automaton.TimedZone;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;

/**
 * A match processor tailored for the org.eclipse.viatra.cep.core.engine.runtime.tokenEntersTimedZone pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class TokenEntersTimedZoneProcessor implements IMatchProcessor<TokenEntersTimedZoneMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pEventToken the value of pattern parameter eventToken in the currently processed match
   * @param pState the value of pattern parameter state in the currently processed match
   * @param pTimedZone the value of pattern parameter timedZone in the currently processed match
   * 
   */
  public abstract void process(final EventToken pEventToken, final State pState, final TimedZone pTimedZone);
  
  @Override
  public void process(final TokenEntersTimedZoneMatch match) {
    process(match.getEventToken(), match.getState(), match.getTimedZone());
  }
}
