/**
 * 
 *   Copyright (c) 2004-2014, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.runtime.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.viatra.cep.core.engine.runtime.TokenLeavesTimedZoneMatch;
import org.eclipse.viatra.cep.core.engine.runtime.TokenLeavesTimedZoneMatcher;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameterDirection;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.viatra.query.runtime.matchers.tuple.FlatTuple;

/**
 * A pattern-specific query specification that can instantiate TokenLeavesTimedZoneMatcher in a type-safe way.
 * 
 * @see TokenLeavesTimedZoneMatcher
 * @see TokenLeavesTimedZoneMatch
 * 
 */
@SuppressWarnings("all")
public final class TokenLeavesTimedZoneQuerySpecification extends BaseGeneratedEMFQuerySpecification<TokenLeavesTimedZoneMatcher> {
  private TokenLeavesTimedZoneQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws ViatraQueryException if the pattern definition could not be loaded
   * 
   */
  public static TokenLeavesTimedZoneQuerySpecification instance() throws ViatraQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected TokenLeavesTimedZoneMatcher instantiate(final ViatraQueryEngine engine) throws ViatraQueryException {
    return TokenLeavesTimedZoneMatcher.on(engine);
  }
  
  @Override
  public TokenLeavesTimedZoneMatcher instantiate() throws ViatraQueryException {
    return TokenLeavesTimedZoneMatcher.create();
  }
  
  @Override
  public TokenLeavesTimedZoneMatch newEmptyMatch() {
    return TokenLeavesTimedZoneMatch.newEmptyMatch();
  }
  
  @Override
  public TokenLeavesTimedZoneMatch newMatch(final Object... parameters) {
    return TokenLeavesTimedZoneMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.automaton.EventToken) parameters[0], (org.eclipse.viatra.cep.core.metamodels.automaton.State) parameters[1], (org.eclipse.viatra.cep.core.metamodels.automaton.TimedZone) parameters[2], (org.eclipse.viatra.cep.core.metamodels.automaton.TrapState) parameters[3]);
  }
  
  /**
   * Inner class allowing the singleton instance of {@link TokenLeavesTimedZoneQuerySpecification} to be created 
   * 	<b>not</b> at the class load time of the outer class, 
   * 	but rather at the first call to {@link TokenLeavesTimedZoneQuerySpecification#instance()}.
   * 
   * <p> This workaround is required e.g. to support recursion.
   * 
   */
  private static class LazyHolder {
    private final static TokenLeavesTimedZoneQuerySpecification INSTANCE = new TokenLeavesTimedZoneQuerySpecification();
    
    /**
     * Statically initializes the query specification <b>after</b> the field {@link #INSTANCE} is assigned.
     * This initialization order is required to support indirect recursion.
     * 
     * <p> The static initializer is defined using a helper field to work around limitations of the code generator.
     * 
     */
    private final static Object STATIC_INITIALIZER = ensureInitialized();
    
    public static Object ensureInitialized() {
      INSTANCE.ensureInitializedInternalSneaky();
      return null;
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static TokenLeavesTimedZoneQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    private final PParameter parameter_pEventToken = new PParameter("eventToken", "org.eclipse.viatra.cep.core.metamodels.automaton.EventToken", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("automaton.meta", "EventToken")), PParameterDirection.INOUT);
    
    private final PParameter parameter_pState = new PParameter("state", "org.eclipse.viatra.cep.core.metamodels.automaton.State", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("automaton.meta", "State")), PParameterDirection.INOUT);
    
    private final PParameter parameter_pTimedZone = new PParameter("timedZone", "org.eclipse.viatra.cep.core.metamodels.automaton.TimedZone", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("automaton.meta", "TimedZone")), PParameterDirection.INOUT);
    
    private final PParameter parameter_pTrapState = new PParameter("trapState", "org.eclipse.viatra.cep.core.metamodels.automaton.TrapState", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("automaton.meta", "TrapState")), PParameterDirection.INOUT);
    
    private final List<PParameter> parameters = Arrays.asList(parameter_pEventToken, parameter_pState, parameter_pTimedZone, parameter_pTrapState);
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.cep.core.engine.runtime.tokenLeavesTimedZone";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("eventToken","state","timedZone","trapState");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return parameters;
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      setEvaluationHints(new QueryEvaluationHint(null, Collections.<String,Object>emptyMap()));
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_eventToken = body.getOrCreateVariableByName("eventToken");
      		PVariable var_state = body.getOrCreateVariableByName("state");
      		PVariable var_timedZone = body.getOrCreateVariableByName("timedZone");
      		PVariable var_trapState = body.getOrCreateVariableByName("trapState");
      		PVariable var_automaton = body.getOrCreateVariableByName("automaton");
      		new TypeConstraint(body, new FlatTuple(var_eventToken), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "EventToken")));
      		new TypeConstraint(body, new FlatTuple(var_state), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "State")));
      		new TypeConstraint(body, new FlatTuple(var_timedZone), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "TimedZone")));
      		new TypeConstraint(body, new FlatTuple(var_trapState), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "TrapState")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_eventToken, parameter_pEventToken),
      		   new ExportedParameter(body, var_state, parameter_pState),
      		   new ExportedParameter(body, var_timedZone, parameter_pTimedZone),
      		   new ExportedParameter(body, var_trapState, parameter_pTrapState)
      		));
      		// 	EventToken.currentState(eventToken, state)
      		new TypeConstraint(body, new FlatTuple(var_eventToken), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "EventToken")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var_eventToken, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "EventToken", "currentState")));
      		new Equality(body, var__virtual_0_, var_state);
      		// 	EventToken.timedZones(eventToken, timedZone)
      		new TypeConstraint(body, new FlatTuple(var_eventToken), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "EventToken")));
      		PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      		new TypeConstraint(body, new FlatTuple(var_eventToken, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "EventToken", "timedZones")));
      		new Equality(body, var__virtual_1_, var_timedZone);
      		// 	State.outStateOf(state, timedZone)
      		new TypeConstraint(body, new FlatTuple(var_state), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "State")));
      		PVariable var__virtual_2_ = body.getOrCreateVariableByName(".virtual{2}");
      		new TypeConstraint(body, new FlatTuple(var_state, var__virtual_2_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "State", "outStateOf")));
      		new Equality(body, var__virtual_2_, var_timedZone);
      		// 		Automaton.eventTokens(automaton, eventToken)
      		new TypeConstraint(body, new FlatTuple(var_automaton), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		PVariable var__virtual_3_ = body.getOrCreateVariableByName(".virtual{3}");
      		new TypeConstraint(body, new FlatTuple(var_automaton, var__virtual_3_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Automaton", "eventTokens")));
      		new Equality(body, var__virtual_3_, var_eventToken);
      		// 	Automaton.states(automaton, trapState)
      		new TypeConstraint(body, new FlatTuple(var_automaton), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		PVariable var__virtual_4_ = body.getOrCreateVariableByName(".virtual{4}");
      		new TypeConstraint(body, new FlatTuple(var_automaton, var__virtual_4_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Automaton", "states")));
      		new Equality(body, var__virtual_4_, var_trapState);
      		bodies.add(body);
      	}
      	// to silence compiler error
      	if (false) throw new ViatraQueryException("Never", "happens");
      } catch (ViatraQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
