package org.eclipse.viatra.cep.core.utils;

import com.google.common.base.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra.cep.core.metamodels.automaton.Automaton;
import org.eclipse.viatra.cep.core.metamodels.automaton.AutomatonFactory;
import org.eclipse.viatra.cep.core.metamodels.automaton.EventToken;
import org.eclipse.viatra.cep.core.metamodels.automaton.FinalState;
import org.eclipse.viatra.cep.core.metamodels.automaton.InitState;
import org.eclipse.viatra.cep.core.metamodels.automaton.ParameterTable;
import org.eclipse.viatra.cep.core.metamodels.automaton.State;
import org.eclipse.viatra.cep.core.metamodels.automaton.TrapState;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class AutomatonUtils {
  public static Iterable<State> getNormalStates(final Automaton automaton) {
    EList<State> _states = automaton.getStates();
    final Function1<State, Boolean> _function = new Function1<State, Boolean>() {
      @Override
      public Boolean apply(final State s) {
        return Boolean.valueOf(AutomatonUtils.isNormal(s));
      }
    };
    return IterableExtensions.<State>filter(_states, _function);
  }
  
  public static boolean isNormal(final State state) {
    return (!(((state instanceof InitState) || (state instanceof FinalState)) || (state instanceof TrapState)));
  }
  
  public static boolean enablesStrictInitTokenCreation(final State state) {
    return ((Objects.equal(state, null) || (state instanceof FinalState)) || (state instanceof TrapState));
  }
  
  public static boolean notEmpty(final State state) {
    boolean _isEmpty = AutomatonUtils.isEmpty(state);
    return (!_isEmpty);
  }
  
  public static boolean isEmpty(final State state) {
    EList<EventToken> _eventTokens = state.getEventTokens();
    return _eventTokens.isEmpty();
  }
  
  public static boolean newEventToken(final Automaton automaton, final State state) {
    boolean _xblockexpression = false;
    {
      final EventToken token = AutomatonFactory.eINSTANCE.createEventToken();
      final ParameterTable parameterTable = AutomatonFactory.eINSTANCE.createParameterTable();
      token.setParameterTable(parameterTable);
      token.setCurrentState(state);
      EList<EventToken> _eventTokens = automaton.getEventTokens();
      _xblockexpression = _eventTokens.add(token);
    }
    return _xblockexpression;
  }
}
