/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.evolutionary;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.viatra.dse.evolutionary.Row;

public class CsvFile {
    protected String fileBasePath = "";
    protected String fileName;
    protected Character delimeter = Character.valueOf(',');
    private File csvFile;
    private Path path;
    protected List<String> columnNamesInOrder = new ArrayList<String>();
    protected List<Row> loadedRows;

    public String getHeaderString() {
        StringBuilder sb = new StringBuilder();
        for (String string : this.columnNamesInOrder) {
            sb.append(string);
            sb.append(this.delimeter);
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public String rowIntoString(Row row) {
        StringBuilder sb = new StringBuilder();
        for (String key : this.columnNamesInOrder) {
            String value = (String)row.get(key);
            sb.append(value);
            sb.append(this.delimeter);
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public boolean createCsvFile() {
        this.path = Paths.get(this.fileBasePath, String.valueOf(this.fileName) + ".csv");
        this.csvFile = new File(this.path.toUri());
        if (this.csvFile.exists()) {
            Logger.getLogger(this.getClass()).warn((Object)("File " + this.fileName + ".csv already exists!"));
            return false;
        }
        try (PrintWriter out = null;){
            out = new PrintWriter(new BufferedWriter(new FileWriter(this.path.toString(), true)));
            out.println(this.getHeaderString());
            return true;
        }
        return false;
    }

    public boolean appendRow(Row row) {
        if (this.csvFile == null) {
            throw new RuntimeException("Csv file is not created yet.");
        }
        try (PrintWriter out = null;){
            out = new PrintWriter(new BufferedWriter(new FileWriter(this.path.toString(), true)));
            out.println(this.rowIntoString(row));
            return true;
        }
        return false;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileBasePath(String fileBasePath) {
        this.fileBasePath = fileBasePath;
    }

    public String getFileBasePath() {
        return this.fileBasePath;
    }

    public List<String> getColumnNamesInOrder() {
        return this.columnNamesInOrder;
    }

    public void setColumnNamesInOrder(List<String> columnNamesInOrder) {
        this.columnNamesInOrder = columnNamesInOrder;
    }
}

