/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.evolutionary;

import com.google.common.base.Stopwatch;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.evolutionary.CsvFile;
import org.eclipse.viatra.dse.evolutionary.DseCsvConstants;
import org.eclipse.viatra.dse.evolutionary.Row;
import org.eclipse.viatra.dse.evolutionary.interfaces.IEvolutionaryStrategyAdapter;
import org.eclipse.viatra.dse.objectives.TrajectoryFitness;

public class EvolutionaryStrategyLogAdapter
implements IEvolutionaryStrategyAdapter {
    protected CsvFile csv;
    private int configId = -1;
    private int runId = -1;
    private int iteration = 1;
    private Stopwatch stopwatch;
    private Row row = new Row();

    public EvolutionaryStrategyLogAdapter() {
        this.csv = new CsvFile();
        this.csv.columnNamesInOrder = DseCsvConstants.resultConstants;
        this.csv.fileName = "evolutionary-log";
    }

    @Override
    public void init(ThreadContext context) {
        this.csv.createCsvFile();
        this.stopwatch = Stopwatch.createStarted();
    }

    @Override
    public void iterationCompleted(List<TrajectoryFitness> currentPopulation, List<? extends List<TrajectoryFitness>> frontsOfCurrentPopulation, List<TrajectoryFitness> survivedPopulation, boolean stop) {
        this.stopwatch.stop();
        long elapsedTime = this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
        for (TrajectoryFitness trajectoryFitness : currentPopulation) {
            this.row.add("ConfigId", this.configId);
            this.row.add("RunId", this.runId);
            this.row.add("Iteration", this.iteration);
            this.row.add("RunTime[ms]", elapsedTime);
            this.row.add("Length", trajectoryFitness.trajectory.length);
            this.row.add("Fitness", "\"" + trajectoryFitness.fitness + "\"");
            this.row.add("Trajectory", "\"" + Arrays.toString(trajectoryFitness.trajectory) + "\"");
            this.row.add("Rank", trajectoryFitness.rank - 1);
            this.row.add("Survive", trajectoryFitness.survive);
            this.csv.appendRow(this.row);
        }
        ++this.iteration;
        this.stopwatch = Stopwatch.createStarted();
    }

    public CsvFile getCsvFile() {
        return this.csv;
    }

    public void setCsvFileName(String fileName) {
        this.csv.setFileName(fileName);
    }

    public void setCsvFileName(String basePath, String fileName) {
        this.csv.setFileBasePath(basePath);
        this.csv.setFileName(fileName);
    }

    public int getConfigId() {
        return this.configId;
    }

    public void setConfigId(int configId) {
        this.configId = configId;
    }

    public int getRunId() {
        return this.runId;
    }

    public void setRunId(int runId) {
        this.runId = runId;
    }
}

