/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.evolutionary.crossovers;

import java.util.Random;
import org.eclipse.viatra.dse.base.DesignSpaceManager;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.designspace.api.TrajectoryInfo;
import org.eclipse.viatra.dse.evolutionary.GeneticHelper;
import org.eclipse.viatra.dse.evolutionary.TrajectoryWithStateFitness;
import org.eclipse.viatra.dse.evolutionary.interfaces.ICrossover;
import org.eclipse.viatra.dse.objectives.Fitness;
import org.eclipse.viatra.dse.objectives.TrajectoryFitness;

public class PermutationCrossover
implements ICrossover {
    private Random random = new Random();

    @Override
    public TrajectoryFitness[] mutate(TrajectoryFitness parent1, TrajectoryFitness parent2, ThreadContext context) {
        TrajectoryFitness[] children = new TrajectoryWithStateFitness[2];
        DesignSpaceManager dsm = context.getDesignSpaceManager();
        TrajectoryInfo trajectoryInfo = dsm.getTrajectoryInfo();
        Object[] parent1t = parent1.trajectory;
        Object[] parent2t = parent2.trajectory;
        int p1Size = parent1t.length;
        int p2Size = parent2t.length;
        if (p1Size < 2 || p2Size < 2) {
            dsm.undoUntilRoot();
            return null;
        }
        int minSize = Math.min(p1Size, p2Size);
        int index = this.random.nextInt(minSize);
        dsm.executeTrajectoryWithoutStateCoding(parent1t, index);
        this.addPermutation(dsm, trajectoryInfo, parent2t);
        Fitness fitness = context.calculateFitness();
        children[0] = new TrajectoryWithStateFitness(dsm.getTrajectoryInfo(), fitness);
        dsm.undoUntilRoot();
        dsm.executeTrajectoryWithoutStateCoding(parent2t, index);
        this.addPermutation(dsm, trajectoryInfo, parent1t);
        fitness = context.calculateFitness();
        children[1] = new TrajectoryWithStateFitness(dsm.getTrajectoryInfo(), fitness);
        dsm.undoUntilRoot();
        return children;
    }

    private void addPermutation(DesignSpaceManager dsm, TrajectoryInfo trajectoryInfo, Object[] parent2t) {
        Object[] objectArray = parent2t;
        int n = parent2t.length;
        int n2 = 0;
        while (n2 < n) {
            block3: {
                Object transitionToAddId = objectArray[n2];
                for (Object childTransition : trajectoryInfo.getTrajectory()) {
                    Object id = childTransition;
                    if (!transitionToAddId.equals(id)) {
                        continue;
                    }
                    break block3;
                }
                GeneticHelper.tryFireRightTransition(dsm, transitionToAddId);
            }
            ++n2;
        }
    }
}

