/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.evolutionary.initialselectors;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import org.eclipse.viatra.dse.base.DesignSpaceManager;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.designspace.api.TrajectoryInfo;
import org.eclipse.viatra.dse.evolutionary.TrajectoryWithStateFitness;
import org.eclipse.viatra.dse.evolutionary.interfaces.IInitialPopulationSelector;
import org.eclipse.viatra.dse.objectives.Fitness;
import org.eclipse.viatra.dse.objectives.TrajectoryFitness;

public class BfsInitialSelector
implements IInitialPopulationSelector {
    private DesignSpaceManager dsm;
    private Queue<Object[]> queue = new ArrayDeque<Object[]>();
    private int minDepthOfFirstPopulation;
    private int populationSize;
    private float chanceOfSelection = 1.0f;
    private List<TrajectoryFitness> initialPopulation;
    private Random random = new Random();
    private boolean isInterrupted = false;
    private ThreadContext context;
    private TrajectoryInfo trajectoryInfo;

    public BfsInitialSelector() {
        this(2.0f, 1);
    }

    public BfsInitialSelector(float chanceOfSelection) {
        this(chanceOfSelection, 2);
    }

    public BfsInitialSelector(float chanceOfSelection, int minDepthOfFirstPopulation) {
        this.minDepthOfFirstPopulation = minDepthOfFirstPopulation;
        this.chanceOfSelection = chanceOfSelection;
    }

    public void initStrategy(ThreadContext context) {
        this.context = context;
        this.initialPopulation = new ArrayList<TrajectoryFitness>(this.populationSize);
        this.dsm = context.getDesignSpaceManager();
        this.trajectoryInfo = this.dsm.getTrajectoryInfo();
    }

    public void explore() {
        while (!this.isInterrupted && this.initialPopulation.size() < this.populationSize) {
            Object[] nextTrajectory;
            Object[] transitions;
            Object[] objectArray = transitions = this.dsm.getTransitionsFromCurrentState().toArray();
            int n = transitions.length;
            int n2 = 0;
            while (n2 < n) {
                Object iTransition = objectArray[n2];
                this.dsm.fireActivation(iTransition);
                if (!this.dsm.isNewModelStateAlreadyTraversed()) {
                    Object[] trajectory = this.trajectoryInfo.getTrajectory().toArray(new Object[0]);
                    this.queue.add(trajectory);
                    if (this.minDepthOfFirstPopulation <= trajectory.length && this.random.nextFloat() < this.chanceOfSelection) {
                        Fitness fitness = this.context.calculateFitness();
                        this.initialPopulation.add(new TrajectoryWithStateFitness(this.trajectoryInfo, fitness));
                        if (this.populationSize <= this.initialPopulation.size()) {
                            this.dsm.undoUntilRoot();
                            return;
                        }
                    }
                }
                this.dsm.undoLastTransformation();
                ++n2;
            }
            this.dsm.undoUntilRoot();
            Object[] objectArray2 = nextTrajectory = this.queue.poll();
            int n3 = nextTrajectory.length;
            n = 0;
            while (n < n3) {
                Object iTransition = objectArray2[n];
                this.dsm.fireActivation(iTransition);
                ++n;
            }
        }
        this.dsm.undoUntilRoot();
    }

    @Override
    public void setPopulationSize(int populationSize) {
        this.populationSize = populationSize;
    }

    public void interruptStrategy() {
        this.isInterrupted = true;
    }

    @Override
    public List<TrajectoryFitness> getInitialPopulation() {
        return this.initialPopulation;
    }
}

