/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.evolutionary.mutations;

import java.util.Arrays;
import java.util.Random;
import org.eclipse.viatra.dse.base.DesignSpaceManager;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.designspace.api.TrajectoryInfo;
import org.eclipse.viatra.dse.evolutionary.TrajectoryWithStateFitness;
import org.eclipse.viatra.dse.evolutionary.interfaces.IMutation;
import org.eclipse.viatra.dse.objectives.Fitness;
import org.eclipse.viatra.dse.objectives.TrajectoryFitness;

public class DeleteRandomTransitionMutation
implements IMutation {
    private Random rnd = new Random();

    @Override
    public TrajectoryFitness mutate(TrajectoryFitness parent, ThreadContext context) {
        DesignSpaceManager dsm = context.getDesignSpaceManager();
        Object[] trajectory = parent.trajectory;
        int trajectorySize = trajectory.length;
        int index = this.rnd.nextInt(trajectorySize);
        dsm.executeTrajectoryWithoutStateCoding(trajectory, index);
        Object[] trajectoryEnd = Arrays.copyOfRange(trajectory, index + 1, trajectory.length);
        dsm.executeTrajectoryByTryingWithoutStateCoding(trajectoryEnd);
        Fitness calculateFitness = context.calculateFitness();
        TrajectoryInfo trajectoryInfo = dsm.getTrajectoryInfo();
        TrajectoryWithStateFitness child = new TrajectoryWithStateFitness(trajectoryInfo, calculateFitness);
        dsm.undoUntilRoot();
        return child;
    }
}

