/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.evolutionary.mutations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import org.eclipse.viatra.dse.base.DesignSpaceManager;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.designspace.api.TrajectoryInfo;
import org.eclipse.viatra.dse.evolutionary.GeneticHelper;
import org.eclipse.viatra.dse.evolutionary.TrajectoryWithStateFitness;
import org.eclipse.viatra.dse.evolutionary.interfaces.IMutation;
import org.eclipse.viatra.dse.objectives.Fitness;
import org.eclipse.viatra.dse.objectives.TrajectoryFitness;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRule;

public class ModifyTransitionByPriorityMutation
implements IMutation {
    private Random rnd = new Random();
    private Map<BatchTransformationRule<?, ?>, Integer> priorities;

    public ModifyTransitionByPriorityMutation(Map<BatchTransformationRule<?, ?>, Integer> priorities) {
        this.priorities = priorities;
    }

    @Override
    public TrajectoryFitness mutate(TrajectoryFitness parent, ThreadContext context) {
        DesignSpaceManager dsm = context.getDesignSpaceManager();
        Object[] trajectory = parent.trajectory;
        int trajectorySize = trajectory.length;
        int index = this.rnd.nextInt(trajectorySize);
        dsm.executeTrajectoryWithoutStateCoding(trajectory, index);
        Collection transitions = dsm.getTransitionsFromCurrentState();
        int transitionsSize = transitions.size();
        if (transitionsSize == 0) {
            dsm.undoUntilRoot();
            return null;
        }
        int bestPriority = Integer.MIN_VALUE;
        for (Object iTransition : transitions) {
            int priority = this.priorities.get(dsm.getRuleByActivationId(iTransition));
            if (priority <= bestPriority) continue;
            bestPriority = priority;
        }
        ArrayList bestTrasitions = new ArrayList();
        for (Object iTransition : transitions) {
            if (this.priorities.get(dsm.getRuleByActivationId(iTransition)) != bestPriority) continue;
            bestTrasitions.add(iTransition);
        }
        index = this.rnd.nextInt(bestTrasitions.size());
        Object transition = bestTrasitions.get(index);
        dsm.fireActivation(transition);
        int i = index + 1;
        while (i < trajectorySize) {
            GeneticHelper.tryFireRightTransition(dsm, trajectory[i]);
            ++i;
        }
        Fitness calculateFitness = context.calculateFitness();
        TrajectoryInfo trajectoryInfo = dsm.getTrajectoryInfo();
        TrajectoryWithStateFitness child = new TrajectoryWithStateFitness(trajectoryInfo, calculateFitness);
        dsm.undoUntilRoot();
        return child;
    }
}

