/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.evolutionary.survival;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.evolutionary.interfaces.ISurvivalStrategy;
import org.eclipse.viatra.dse.objectives.TrajectoryFitness;

public class FirstNSolutionsSurvivalStrategy
implements ISurvivalStrategy {
    private int numberOfSelectedInstances = -1;

    public FirstNSolutionsSurvivalStrategy() {
    }

    public FirstNSolutionsSurvivalStrategy(int numberOfSelectedInstances) {
        this.numberOfSelectedInstances = numberOfSelectedInstances;
    }

    public void setNumberOfSelectedInstances(int numberOfSelectedInstances) {
        this.numberOfSelectedInstances = numberOfSelectedInstances;
    }

    @Override
    public void init(ThreadContext context) {
        Preconditions.checkArgument((this.numberOfSelectedInstances > 0 ? 1 : 0) != 0, (Object)"Number of selected instances is not correctly set.");
    }

    @Override
    public List<TrajectoryFitness> selectSurvivedPopulation(List<? extends List<TrajectoryFitness>> frontsOfCurrentPopulation) {
        ArrayList<TrajectoryFitness> survivedPopulation = new ArrayList<TrajectoryFitness>();
        for (List<TrajectoryFitness> list : frontsOfCurrentPopulation) {
            int newSize = survivedPopulation.size() + list.size();
            if (newSize <= this.numberOfSelectedInstances) {
                survivedPopulation.addAll(list);
                if (newSize != this.numberOfSelectedInstances) continue;
                break;
            }
            TrajectoryFitness[] sortedFront = new TrajectoryFitness[list.size()];
            Arrays.sort(list.toArray(sortedFront), new Comparator<TrajectoryFitness>(){

                @Override
                public int compare(TrajectoryFitness o1, TrajectoryFitness o2) {
                    return Double.compare(o1.crowdingDistance, o2.crowdingDistance);
                }
            });
            int size = survivedPopulation.size();
            int i = 0;
            while (i < this.numberOfSelectedInstances - size) {
                survivedPopulation.add(sortedFront[i]);
                ++i;
            }
            break block0;
        }
        return survivedPopulation;
    }
}

