/*******************************************************************************
 * Copyright (c) 2010-2014, Miklos Foldenyi, Andras Szabolcs Nagy, Abel Hegedus, Akos Horvath, Zoltan Ujhelyi and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 *   Miklos Foldenyi - initial API and implementation
 *   Andras Szabolcs Nagy - initial API and implementation
 *******************************************************************************/
package org.eclipse.viatra.dse.api;

import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRule;

import com.google.common.base.Preconditions;

/**
 * An instance of this class is a specification of a graph transformation rule on a given metamodel. Such a rule
 * consists of a left hand side (LHS), which is specified by an {@link IQuerySpecification} and a right hand side (RHS),
 * which is specified by an {@link IMatchProcessor}.
 * 
 * @author Andras Szabolcs Nagy
 * 
 * @param <Match>
 *            A VIATRA Query pattern match - left hand side of the rule
 * @param <Matcher>
 *            A VIATRA Query pattern matcher - left hand side of the rule
 * 
 */
@Deprecated
public class DSETransformationRule<Match extends IPatternMatch, Matcher extends ViatraQueryMatcher<Match>> extends
        BatchTransformationRule<Match, Matcher> {

    public DSETransformationRule(String name, IQuerySpecification<Matcher> querySpec,
            IMatchProcessor<Match> action) {
        super(name, querySpec, BatchTransformationRule.STATELESS_RULE_LIFECYCLE, action);

        Preconditions.checkNotNull(name);
        Preconditions.checkNotNull(querySpec);
        Preconditions.checkNotNull(action);

    }

    public DSETransformationRule(IQuerySpecification<Matcher> querySpec,
            IMatchProcessor<Match> action) {
        this(querySpec.getFullyQualifiedName(), querySpec, action);
    }

}
