/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.viatra.dse.api.SolutionTrajectory;

public class Solution {
    private List<SolutionTrajectory> trajectories;
    private final Object stateId;

    public Solution(Object stateId, SolutionTrajectory trajectory) {
        this.stateId = stateId;
        this.trajectories = new ArrayList<SolutionTrajectory>();
        this.trajectories.add(trajectory);
    }

    public void addTrajectory(SolutionTrajectory trajectory) {
        this.trajectories.add(trajectory);
    }

    public SolutionTrajectory getArbitraryTrajectory() {
        return this.trajectories.get(0);
    }

    public SolutionTrajectory getShortestTrajectory() {
        if (this.trajectories.size() == 1) {
            return this.trajectories.get(0);
        }
        SolutionTrajectory shortestTrajecotry = this.trajectories.get(0);
        int minSize = shortestTrajecotry.getTrajectoryLength();
        for (SolutionTrajectory traj : this.trajectories) {
            int size = traj.getTrajectoryLength();
            if (size >= minSize) continue;
            shortestTrajecotry = traj;
            minSize = size;
        }
        return shortestTrajecotry;
    }

    public Collection<SolutionTrajectory> getTrajectories() {
        return this.trajectories;
    }

    public Object getStateCode() {
        return this.stateId;
    }
}

