/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.api.strategy.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.eclipse.viatra.dse.api.DSEException;
import org.eclipse.viatra.dse.api.strategy.interfaces.IStrategy;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.objectives.Fitness;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRule;

public class FixedPriorityStrategy
implements IStrategy {
    private int maxDepth = Integer.MAX_VALUE;
    private AtomicBoolean isInterrupted = new AtomicBoolean(false);
    private ThreadContext context;
    private Logger logger = Logger.getLogger(IStrategy.class);
    private Map<BatchTransformationRule<?, ?>, Integer> priorities = new HashMap();
    private Random random = new Random();
    private Map<Object, List<Object>> bestPriorityInState = new HashMap<Object, List<Object>>();

    public FixedPriorityStrategy withDepthLimit(int maxDepth) {
        this.maxDepth = maxDepth <= 0 ? Integer.MAX_VALUE : maxDepth;
        return this;
    }

    public FixedPriorityStrategy withRulePriority(BatchTransformationRule<?, ?> rule, int priority) {
        this.priorities.put(rule, priority);
        return this;
    }

    public Map<BatchTransformationRule<?, ?>, Integer> getPriorities() {
        return this.priorities;
    }

    @Override
    public void initStrategy(ThreadContext context) {
        this.context = context;
        this.logger.info((Object)"Fixed priority exploration strategy is initied.");
    }

    @Override
    public void explore() {
        block0: while (true) {
            ArrayList transitions;
            boolean globalConstraintsAreSatisfied;
            if (!(globalConstraintsAreSatisfied = this.context.checkGlobalConstraints())) {
                boolean isSuccessfulUndo = this.context.backtrack();
                if (!isSuccessfulUndo) {
                    this.logger.info((Object)"Global contraint is not satisifed and cannot backtrack.");
                    break;
                }
                this.logger.debug((Object)"Global contraint is not satisifed, backtrack.");
                continue;
            }
            Fitness fitness = this.context.calculateFitness();
            if (fitness.isSatisifiesHardObjectives()) {
                this.context.newSolution();
                boolean isSuccessfulUndo = this.context.backtrack();
                if (!isSuccessfulUndo) {
                    this.logger.info((Object)"Found a solution but cannot backtrack.");
                    break;
                }
                this.logger.debug((Object)"Found a solution, backtrack.");
                continue;
            }
            if (this.context.getDepth() >= this.maxDepth) {
                boolean isSuccessfulUndo = this.context.backtrack();
                if (!isSuccessfulUndo) {
                    this.logger.info((Object)"Reached max depth but cannot bactrack.");
                    break;
                }
                this.logger.debug((Object)"Reached max depth, bactrack.");
                continue;
            }
            if (this.isInterrupted.get()) {
                this.logger.info((Object)"Interrupted, stop exploration.");
                break;
            }
            do {
                if ((transitions = this.bestPriorityInState.get(this.context.getCurrentStateId())) == null) {
                    Integer bestPriority = this.getBestPriority(this.context.getCurrentActivationIds());
                    transitions = Lists.newArrayList();
                    for (Object iTransition : this.context.getCurrentActivationIds()) {
                        if (!this.priorities.get(this.context.getRuleByActivationId(iTransition)).equals(bestPriority)) continue;
                        transitions.add(iTransition);
                    }
                    this.bestPriorityInState.put(this.context.getCurrentStateId(), transitions);
                }
                if (!transitions.isEmpty()) continue;
                boolean isSuccessfulUndo = this.context.backtrack();
                if (!isSuccessfulUndo) {
                    this.logger.info((Object)"No more transitions from current state and cannot backtrack.");
                    break block0;
                }
                this.logger.debug((Object)"No more transitions from current state, backtrack.");
            } while (transitions.isEmpty());
            int index = this.random.nextInt(transitions.size());
            Object transition = transitions.remove(index);
            this.context.executeAcitvationId(transition);
            boolean loopInTrajectory = this.context.isCurrentStateInTrajectory();
            if (!loopInTrajectory) continue;
            boolean isSuccessfulUndo = this.context.backtrack();
            if (!isSuccessfulUndo) {
                throw new DSEException("The new state is present in the trajectoy but cannot bactkrack. Should never happen!");
            }
            this.logger.info((Object)"The new state is already visited in the trajectory, backtrack.");
        }
        this.logger.info((Object)"Terminated.");
    }

    @Override
    public void interruptStrategy() {
        this.isInterrupted.set(true);
    }

    private Integer getBestPriority(Collection<? extends Object> transitions) {
        Integer bestPriority = Integer.MIN_VALUE;
        for (Object object : transitions) {
            Integer priority = this.priorities.get(this.context.getRuleByActivationId(object));
            if (priority <= bestPriority) continue;
            bestPriority = priority;
        }
        return bestPriority;
    }
}

