/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.base;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.viatra.dse.api.DSEException;
import org.eclipse.viatra.dse.api.SolutionTrajectory;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.designspace.api.IDesignSpace;
import org.eclipse.viatra.dse.designspace.api.TrajectoryInfo;
import org.eclipse.viatra.dse.objectives.ActivationFitnessProcessor;
import org.eclipse.viatra.dse.statecode.IStateCoder;
import org.eclipse.viatra.dse.statecode.IStateCoderFactory;
import org.eclipse.viatra.dse.visualizer.IExploreEventHandler;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.transformation.evm.api.Activation;
import org.eclipse.viatra.transformation.evm.api.Context;
import org.eclipse.viatra.transformation.evm.api.resolver.ChangeableConflictSet;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRule;

public class DesignSpaceManager {
    private final IStateCoder stateCoder;
    private final IStateCoderFactory serializerFactory;
    private final EditingDomain domain;
    private Notifier model;
    private IDesignSpace designSpace;
    private final TrajectoryInfo trajectory;
    private List<IExploreEventHandler> handlers;
    private final Context evmContext = Context.create();
    private Logger logger = Logger.getLogger(this.getClass());
    private boolean isNewState = false;
    private Map<BatchTransformationRule<?, ?>, ActivationFitnessProcessor> activationFitnessProcessors;
    private Map<BatchTransformationRule<?, ?>, String> activationFitnessProcessorNames;
    private ThreadContext context;
    private BiMap<Activation<?>, Object> activationIds;
    private ChangeableConflictSet conflictSet;
    private Random random = new Random();

    public DesignSpaceManager(ThreadContext context, Notifier model, EditingDomain domain, IStateCoderFactory factory, IDesignSpace designSpace, ViatraQueryEngine engine) {
        Preconditions.checkNotNull((Object)designSpace, (Object)"Cannot initialize crawler on a null design space!");
        Preconditions.checkNotNull((Object)domain, (Object)"Cannot initialize crawler on a null editing domain!");
        Preconditions.checkNotNull((Object)factory, (Object)"Cannot initialize crawler without a serializer factory!");
        this.context = context;
        this.model = model;
        this.designSpace = designSpace;
        this.domain = domain;
        this.serializerFactory = factory;
        this.activationIds = HashBiMap.create();
        this.conflictSet = context.getConflictResolver().conflictSet;
        this.stateCoder = factory.createStateCoder();
        this.stateCoder.init(model);
        Object initialStateId = this.stateCoder.createStateCode();
        this.generateTransitions();
        designSpace.addState(null, null, initialStateId);
        this.trajectory = new TrajectoryInfo(initialStateId);
        this.logger.debug((Object)("DesignSpaceManager initialized with initial model: " + initialStateId));
    }

    public void fireActivation(Object transition) {
        if (this.fireActivationSilent(transition)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("A retrieved Transition SHOULD have a matching Activation. Possible causes: the state serializer is faulty; the algorithm choosed a wrong Transition.");
        sb.append("\nSought transition: ");
        sb.append(transition);
        Object currentStateId = this.getCurrentState();
        sb.append("\nCurrent known state: ");
        sb.append(currentStateId);
        Object actualStateId = this.stateCoder.createStateCode();
        sb.append("\nActual state: ");
        sb.append(actualStateId.equals(currentStateId) ? "same as current" : actualStateId);
        sb.append("\n");
        sb.append(this.trajectory);
        sb.append("\nAvailable transitions:");
        for (Activation act : this.conflictSet.getNextActivations()) {
            IPatternMatch match = (IPatternMatch)act.getAtom();
            Object code = this.generateMatchCode(match);
            sb.append("\n\t");
            sb.append(code);
        }
        throw new DSEException(sb.toString());
    }

    public boolean tryFireActivation(Object transition) {
        return this.fireActivationSilent(transition);
    }

    private boolean fireActivationSilent(Object transition) {
        final Activation<?> activation = this.getActivationById(transition);
        if (activation == null) {
            return false;
        }
        BatchTransformationRule<?, ?> rule = this.getRuleByActivation(activation);
        HashMap<String, Double> measureCosts = null;
        if (this.activationFitnessProcessors != null && this.activationFitnessProcessors.containsKey(rule)) {
            IPatternMatch match = (IPatternMatch)activation.getAtom();
            ActivationFitnessProcessor processor = this.activationFitnessProcessors.get(rule);
            double fitness = processor.process(match);
            if (measureCosts == null) {
                measureCosts = new HashMap<String, Double>();
            }
            measureCosts.put(this.activationFitnessProcessorNames.get(rule), fitness);
        }
        ChangeCommand rc = new ChangeCommand(this.model){

            protected void doExecute() {
                activation.fire(DesignSpaceManager.this.evmContext);
            }
        };
        Object previousState = this.trajectory.getCurrentStateId();
        this.domain.getCommandStack().execute((Command)rc);
        Object newStateId = this.stateCoder.createStateCode();
        this.generateTransitions();
        if (this.designSpace != null) {
            this.isNewState = !this.designSpace.isTraversed(newStateId);
            this.designSpace.addState(previousState, transition, newStateId);
        }
        this.trajectory.addStep(transition, rule, newStateId, measureCosts);
        if (this.handlers != null) {
            for (IExploreEventHandler iExploreEventHandler : this.handlers) {
                iExploreEventHandler.transitionFired(transition);
            }
        }
        this.logger.debug((Object)("Executed activation: " + transition + " from state: " + previousState + " to " + newStateId));
        return true;
    }

    public boolean executeRandomActivationId() {
        Collection<Object> transitions = this.getTransitionsFromCurrentState();
        int size = transitions.size();
        if (size == 0) {
            return false;
        }
        int index = this.random.nextInt(size);
        Iterator<Object> iterator = transitions.iterator();
        int i = 0;
        while (i < index) {
            iterator.next();
            ++i;
        }
        Object transition = iterator.next();
        this.fireActivation(transition);
        return true;
    }

    public int executeTrajectory(Object[] trajectoryToExecute) {
        return this.executeTrajectory(trajectoryToExecute, trajectoryToExecute.length, false, true);
    }

    public int executeTrajectory(Object[] trajectoryToExecute, int excludedIndex) {
        return this.executeTrajectory(trajectoryToExecute, excludedIndex, false, true);
    }

    public int executeTrajectoryByTrying(Object[] trajectoryToExecute) {
        return this.executeTrajectory(trajectoryToExecute, trajectoryToExecute.length, true, true);
    }

    public int executeTrajectoryByTrying(Object[] trajectoryToExecute, int excludedIndex) {
        return this.executeTrajectory(trajectoryToExecute, excludedIndex, true, true);
    }

    public int executeTrajectoryWithoutStateCoding(Object[] trajectoryToExecute) {
        return this.executeTrajectory(trajectoryToExecute, trajectoryToExecute.length, false, false);
    }

    public int executeTrajectoryWithoutStateCoding(Object[] trajectoryToExecute, int excludedIndex) {
        return this.executeTrajectory(trajectoryToExecute, excludedIndex, false, false);
    }

    public int executeTrajectoryByTryingWithoutStateCoding(Object[] trajectoryToExecute) {
        return this.executeTrajectory(trajectoryToExecute, trajectoryToExecute.length, true, false);
    }

    public int executeTrajectoryByTryingWithoutStateCoding(Object[] trajectoryToExecute, int excludedIndex) {
        return this.executeTrajectory(trajectoryToExecute, excludedIndex, true, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int executeTrajectory(Object[] trajectoryToExecute, int excludedIndex, boolean tryAllActivations, boolean createStateCode) {
        this.logger.debug((Object)"Executing trajectory.");
        int unsuccesfulIndex = -1;
        if (tryAllActivations) {
            unsuccesfulIndex = 0;
        }
        int i = 0;
        while (i < excludedIndex) {
            block9: {
                Object activationId = trajectoryToExecute[i];
                final Activation<?> activation = this.getActivationByIdFromConflictSet(activationId);
                if (activation == null) {
                    this.logger.debug((Object)("Couldn't execute activation: " + activationId));
                    if (tryAllActivations) {
                        ++unsuccesfulIndex;
                        break block9;
                    } else {
                        unsuccesfulIndex = i;
                        this.logger.debug((Object)("Trajectory execution stopped at index " + i + "/" + trajectoryToExecute.length));
                        break;
                    }
                }
                BatchTransformationRule<?, ?> rule = this.getRuleByActivation(activation);
                HashMap<String, Double> measureCosts = null;
                if (this.activationFitnessProcessors != null && this.activationFitnessProcessors.containsKey(rule)) {
                    IPatternMatch match = (IPatternMatch)activation.getAtom();
                    ActivationFitnessProcessor processor = this.activationFitnessProcessors.get(rule);
                    double fitness = processor.process(match);
                    if (measureCosts == null) {
                        measureCosts = new HashMap<String, Double>();
                    }
                    measureCosts.put(this.activationFitnessProcessorNames.get(rule), fitness);
                }
                ChangeCommand rc = new ChangeCommand(this.model){

                    protected void doExecute() {
                        activation.fire(DesignSpaceManager.this.evmContext);
                    }
                };
                this.domain.getCommandStack().execute((Command)rc);
                Object newStateId = null;
                if (createStateCode) {
                    newStateId = this.stateCoder.createStateCode();
                }
                this.trajectory.addStep(activationId, rule, newStateId, measureCosts);
                this.logger.debug((Object)("Activation executed: " + activationId));
            }
            ++i;
        }
        if (!createStateCode) {
            this.trajectory.modifyLastStateCode(this.stateCoder.createStateCode());
        }
        this.generateTransitions();
        this.logger.debug((Object)"Trajectory execution finished.");
        return unsuccesfulIndex;
    }

    public Object getTransitionByActivation(Activation<?> activation) {
        return this.activationIds.get(activation);
    }

    public Activation<?> getActivationById(Object activationId) {
        Activation activation = (Activation)this.activationIds.inverse().get(activationId);
        return activation;
    }

    public BatchTransformationRule<?, ?> getRuleByActivation(Activation<?> activation) {
        return this.context.getGlobalContext().getSpecificationRuleMap().get(activation.getInstance().getSpecification());
    }

    public BatchTransformationRule<?, ?> getRuleByActivationId(Object activationId) {
        return this.getRuleByActivation(this.getActivationById(activationId));
    }

    public boolean isNewModelStateAlreadyTraversed() {
        return !this.isNewState;
    }

    public List<Object> getTrajectoryFromRoot() {
        return this.trajectory.getTrajectory();
    }

    public Collection<Object> getTransitionsFromCurrentState() {
        return this.activationIds.values();
    }

    public Collection<Object> getUntraversedTransitionsFromCurrentState() {
        if (this.designSpace == null) {
            throw new DSEException("Unsupported without a design space");
        }
        Object currentState = this.trajectory.getCurrentStateId();
        Collection<Object> traversedIds = this.designSpace.getActivationIds(currentState);
        ArrayList<Object> untraversedTransitions = new ArrayList<Object>();
        for (Object activationId : this.activationIds.values()) {
            if (traversedIds.contains(activationId)) continue;
            untraversedTransitions.add(activationId);
        }
        return untraversedTransitions;
    }

    public boolean undoLastTransformation() {
        if (!this.trajectory.canStepBack()) {
            return false;
        }
        this.domain.getCommandStack().undo();
        this.generateTransitions();
        Object lastActivationId = this.trajectory.getLastActivationId();
        this.trajectory.backtrack();
        if (this.handlers != null) {
            for (IExploreEventHandler iExploreEventHandler : this.handlers) {
                iExploreEventHandler.undo(lastActivationId);
            }
        }
        this.logger.debug((Object)"Backtrack.");
        return true;
    }

    public void undoUntilRoot() {
        while (this.trajectory.canStepBack()) {
            this.domain.getCommandStack().undo();
            this.trajectory.backtrack();
        }
        this.generateTransitions();
        this.logger.debug((Object)"Backtracked to root.");
    }

    private Object generateMatchCode(IPatternMatch match) {
        return this.stateCoder.createActivationCode(match);
    }

    public Object getCurrentState() {
        return this.trajectory.getCurrentStateId();
    }

    private void generateTransitions() {
        this.activationIds.clear();
        for (Activation activation : this.conflictSet.getNextActivations()) {
            if (!activation.isEnabled()) continue;
            IPatternMatch match = (IPatternMatch)activation.getAtom();
            Object activationId = this.stateCoder.createActivationCode(match);
            this.activationIds.put((Object)activation, activationId);
        }
    }

    private Activation<?> getActivationByIdFromConflictSet(Object soughtActivationId) {
        for (Activation activation : this.conflictSet.getNextActivations()) {
            IPatternMatch match;
            Object activationId;
            if (!activation.isEnabled() || !(activationId = this.stateCoder.createActivationCode(match = (IPatternMatch)activation.getAtom())).equals(soughtActivationId)) continue;
            return activation;
        }
        return null;
    }

    public SolutionTrajectory createSolutionTrajectroy() {
        return this.trajectory.createSolutionTrajectory(this.serializerFactory);
    }

    public TrajectoryInfo getTrajectoryInfo() {
        return this.trajectory;
    }

    public void setDesignSpace(IDesignSpace designSpace) {
        this.designSpace = designSpace;
    }

    public IDesignSpace getDesignSpace() {
        return this.designSpace;
    }

    public void registerExploreEventHandler(IExploreEventHandler handler) {
        if (handler == null) {
            return;
        }
        if (this.handlers == null) {
            this.handlers = new ArrayList<IExploreEventHandler>();
        }
        this.handlers.add(handler);
    }

    public void deregisterExploreEventHandler(IExploreEventHandler handler) {
        if (handler == null) {
            return;
        }
        if (this.handlers != null) {
            this.handlers.remove(handler);
        }
    }

    public void registerActivationCostProcessor(String name, BatchTransformationRule<?, ?> rule, ActivationFitnessProcessor activationFitnessProcessor) {
        if (this.activationFitnessProcessors == null || this.activationFitnessProcessorNames == null) {
            this.activationFitnessProcessors = new HashMap();
            this.activationFitnessProcessorNames = new HashMap();
        }
        this.activationFitnessProcessors.put(rule, activationFitnessProcessor);
        this.activationFitnessProcessorNames.put(rule, name);
    }

    public boolean isCurentStateInTrajectory() {
        Object currentStateId = this.trajectory.getCurrentStateId();
        List<Object> stateTrajectory = this.trajectory.getStateTrajectory();
        int size = stateTrajectory.size();
        int i = 0;
        while (i < size - 1) {
            Object stateId = stateTrajectory.get(i);
            if (currentStateId.equals(stateId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IStateCoder getStateCoder() {
        return this.stateCoder;
    }
}

