/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.designspace.api;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.viatra.dse.api.DSEException;
import org.eclipse.viatra.dse.api.SolutionTrajectory;
import org.eclipse.viatra.dse.statecode.IStateCoderFactory;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRule;

public class TrajectoryInfo
implements Cloneable {
    private final List<Object> trajectory;
    private final List<Object> trajectoryView;
    private final List<BatchTransformationRule<?, ?>> rules;
    private final List<BatchTransformationRule<?, ?>> rulesView;
    private final List<Object> stateIds;
    private final List<Object> stateIdsView;
    private final List<Map<String, Double>> measuredCosts;

    public TrajectoryInfo(Object initialStateId) {
        Preconditions.checkNotNull((Object)initialStateId);
        this.stateIds = new ArrayList<Object>();
        this.stateIds.add(initialStateId);
        this.trajectory = new ArrayList<Object>();
        this.rules = new ArrayList();
        this.measuredCosts = new ArrayList<Map<String, Double>>();
        this.trajectoryView = Collections.unmodifiableList(this.trajectory);
        this.stateIdsView = Collections.unmodifiableList(this.stateIds);
        this.rulesView = Collections.unmodifiableList(this.rules);
    }

    protected TrajectoryInfo(List<Object> stateIds, List<Object> trajectory, List<BatchTransformationRule<?, ?>> rules, List<Map<String, Double>> measuredCosts) {
        this.stateIds = new ArrayList<Object>(stateIds);
        this.trajectory = new ArrayList<Object>(trajectory);
        this.rules = new ArrayList(rules);
        this.trajectoryView = Collections.unmodifiableList(trajectory);
        this.stateIdsView = Collections.unmodifiableList(stateIds);
        this.rulesView = Collections.unmodifiableList(rules);
        this.measuredCosts = new ArrayList<Map<String, Double>>(measuredCosts);
    }

    public void addStep(Object activationId, BatchTransformationRule<?, ?> rule, Object newStateId, Map<String, Double> measuredCosts) {
        this.stateIds.add(newStateId);
        this.trajectory.add(activationId);
        this.rules.add(rule);
        this.measuredCosts.add(measuredCosts);
    }

    public void backtrack() {
        int size = this.trajectory.size();
        if (size == 0) {
            throw new DSEException("Cannot step back any further!");
        }
        this.trajectory.remove(size - 1);
        this.rules.remove(size - 1);
        this.stateIds.remove(size);
        this.measuredCosts.remove(size - 1);
    }

    public Object getInitialStateId() {
        return this.stateIds.get(0);
    }

    public Object getCurrentStateId() {
        return this.stateIds.get(this.stateIds.size() - 1);
    }

    public Object getLastActivationId() {
        return this.trajectory.get(this.trajectory.size() - 1);
    }

    public Object getLastStateId() {
        return this.stateIds.get(this.stateIds.size() - 1);
    }

    public List<Object> getTrajectory() {
        return this.trajectoryView;
    }

    public List<Object> getStateTrajectory() {
        return this.stateIdsView;
    }

    public List<BatchTransformationRule<?, ?>> getRules() {
        return this.rulesView;
    }

    public int getDepth() {
        return this.trajectory.size();
    }

    public List<Map<String, Double>> getMeasuredCosts() {
        return this.measuredCosts;
    }

    public SolutionTrajectory createSolutionTrajectory(IStateCoderFactory stateCoderFactory) {
        ArrayList<Object> activationIds = new ArrayList<Object>(this.trajectory);
        ArrayList copiedRules = new ArrayList(this.rules);
        return new SolutionTrajectory(activationIds, copiedRules, stateCoderFactory);
    }

    public boolean canStepBack() {
        return !this.trajectory.isEmpty();
    }

    public TrajectoryInfo clone() {
        TrajectoryInfo clone = new TrajectoryInfo(this.stateIds, this.trajectory, this.rules, this.measuredCosts);
        return clone;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Trajectory:\n");
        for (Object activationId : this.trajectory) {
            sb.append(activationId);
            sb.append("\n");
        }
        return sb.toString();
    }

    public boolean modifyLastStateCode(Object stateCode) {
        if (this.stateIds.size() == 1) {
            return false;
        }
        this.stateIds.set(this.stateIds.size() - 1, stateCode);
        return true;
    }
}

