/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.objectives.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.objectives.IObjective;
import org.eclipse.viatra.dse.objectives.impl.BaseObjective;

public class CompositeObjective
extends BaseObjective {
    public static final String DEFAULT_NAME = "CompositeObjective";
    protected List<IObjective> objectives;
    protected List<Double> weights;
    protected boolean hardObjective;

    public CompositeObjective(String name, List<IObjective> objectives, List<Double> weights) {
        super(name);
        Preconditions.checkNotNull(objectives, (Object)"The list of objectives cannot be null.");
        Preconditions.checkNotNull(weights, (Object)"The list of weights cannot be null.");
        Preconditions.checkState((objectives.size() == weights.size() ? 1 : 0) != 0, (Object)"The size of the objectives and weights must match.");
        this.objectives = objectives;
        this.weights = weights;
    }

    public CompositeObjective(List<IObjective> objectives, List<Double> weights) {
        this(DEFAULT_NAME, objectives, weights);
    }

    public CompositeObjective(String name) {
        this(name, new ArrayList<IObjective>(), new ArrayList<Double>());
    }

    public CompositeObjective() {
        this(DEFAULT_NAME, new ArrayList<IObjective>(), new ArrayList<Double>());
    }

    public CompositeObjective withObjective(IObjective objective) {
        this.objectives.add(objective);
        this.weights.add(1.0);
        return this;
    }

    public CompositeObjective withObjective(IObjective objective, double weight) {
        this.objectives.add(objective);
        this.weights.add(weight);
        return this;
    }

    @Override
    public Double getFitness(ThreadContext context) {
        double result = 0.0;
        int i = 0;
        while (i < this.objectives.size()) {
            IObjective objective = this.objectives.get(i);
            Double weight = this.weights.get(i);
            result += objective.getFitness(context) * weight;
            ++i;
        }
        return result;
    }

    @Override
    public void init(ThreadContext context) {
        super.init(context);
        this.hardObjective = false;
        for (IObjective objective : this.objectives) {
            objective.init(context);
            if (!objective.isHardObjective()) continue;
            this.hardObjective = true;
        }
    }

    @Override
    public IObjective createNew() {
        IObjective objective2;
        ArrayList<IObjective> newObjectives = new ArrayList<IObjective>();
        for (IObjective objective2 : this.objectives) {
            newObjectives.add(objective2.createNew());
        }
        objective2 = new CompositeObjective(this.name, newObjectives, this.weights);
        if (this.isThereFitnessConstraint) {
            ((BaseObjective)objective2).withHardConstraintOnFitness(this.fitnessConstraint, this.fitnessConstraintComparator);
        }
        return ((BaseObjective)objective2).withComparator(this.comparator).withLevel(this.level);
    }

    @Override
    public boolean isHardObjective() {
        return this.hardObjective;
    }

    @Override
    public boolean satisifiesHardObjective(Double fitness) {
        boolean hardObjectiveSatisfied = true;
        for (IObjective objective : this.objectives) {
            boolean bl = hardObjectiveSatisfied = objective.satisifiesHardObjective(fitness) ? hardObjectiveSatisfied : false;
        }
        hardObjectiveSatisfied = super.satisifiesHardObjective(fitness) ? hardObjectiveSatisfied : false;
        return hardObjectiveSatisfied;
    }
}

