/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.objectives.impl;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.viatra.dse.base.DesignSpaceManager;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.designspace.api.TrajectoryInfo;
import org.eclipse.viatra.dse.objectives.ActivationFitnessProcessor;
import org.eclipse.viatra.dse.objectives.Comparators;
import org.eclipse.viatra.dse.objectives.IObjective;
import org.eclipse.viatra.dse.objectives.impl.BaseObjective;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRule;

public class TrajectoryCostSoftObjective
extends BaseObjective {
    public static final String DEFAULT_NAME = "TrajectoryCostObjective";
    protected Map<BatchTransformationRule<?, ?>, Double> fixCosts;
    protected Map<BatchTransformationRule<?, ?>, ActivationFitnessProcessor> activationCostProcessors;
    protected double trajectoryLengthWeight = 0.0;
    protected boolean calculateTrajectoryLengthWeight;

    public TrajectoryCostSoftObjective(String name) {
        super(name);
        this.comparator = Comparators.LOWER_IS_BETTER;
    }

    public TrajectoryCostSoftObjective() {
        this(DEFAULT_NAME);
    }

    public TrajectoryCostSoftObjective withRuleCost(BatchTransformationRule<?, ?> rule, double cost) {
        Preconditions.checkNotNull(rule);
        if (this.fixCosts == null) {
            this.fixCosts = new HashMap();
        }
        Preconditions.checkArgument((!this.fixCosts.containsKey(rule) ? 1 : 0) != 0);
        this.fixCosts.put(rule, cost);
        return this;
    }

    public TrajectoryCostSoftObjective withActivationCost(BatchTransformationRule<?, ?> rule, ActivationFitnessProcessor activationCostProcessor) {
        Preconditions.checkNotNull(rule);
        Preconditions.checkNotNull((Object)activationCostProcessor);
        if (this.activationCostProcessors == null) {
            this.activationCostProcessors = new HashMap();
        }
        Preconditions.checkArgument((!this.activationCostProcessors.containsKey(rule) ? 1 : 0) != 0);
        this.activationCostProcessors.put(rule, activationCostProcessor);
        return this;
    }

    public TrajectoryCostSoftObjective withTrajectoryLengthWeight(double trajectoryLengthWeight) {
        this.trajectoryLengthWeight = trajectoryLengthWeight;
        this.calculateTrajectoryLengthWeight = true;
        return this;
    }

    @Override
    public Double getFitness(ThreadContext context) {
        DesignSpaceManager dsm = context.getDesignSpaceManager();
        TrajectoryInfo trajectoryInfo = dsm.getTrajectoryInfo();
        List<Object> trajectory = trajectoryInfo.getTrajectory();
        List<BatchTransformationRule<?, ?>> rules = trajectoryInfo.getRules();
        double result = 0.0;
        int i = 0;
        while (i < trajectory.size()) {
            Map<String, Double> costs;
            BatchTransformationRule<?, ?> rule = rules.get(i);
            Double cost = this.fixCosts.get(rule);
            if (cost != null) {
                result += cost.doubleValue();
            }
            if ((costs = trajectoryInfo.getMeasuredCosts().get(i)) != null && (cost = costs.get(this.name)) != null) {
                result += cost.doubleValue();
            }
            ++i;
        }
        if (this.calculateTrajectoryLengthWeight) {
            result += (double)trajectory.size() * this.trajectoryLengthWeight;
        }
        return result;
    }

    @Override
    public void init(ThreadContext context) {
        super.init(context);
        DesignSpaceManager dsm = context.getDesignSpaceManager();
        for (Map.Entry<BatchTransformationRule<?, ?>, ActivationFitnessProcessor> entry : this.activationCostProcessors.entrySet()) {
            dsm.registerActivationCostProcessor(this.name, entry.getKey(), entry.getValue());
        }
    }

    @Override
    public IObjective createNew() {
        return this;
    }
}

