/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.statecoding.simple;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.dse.api.DSEException;
import org.eclipse.viatra.dse.statecode.IStateCoder;
import org.eclipse.viatra.dse.util.EMFHelper;
import org.eclipse.viatra.dse.util.ValueComparableEObjectStringMap;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.scope.QueryScope;
import org.eclipse.viatra.query.runtime.base.api.FeatureListener;
import org.eclipse.viatra.query.runtime.base.api.InstanceListener;
import org.eclipse.viatra.query.runtime.base.api.NavigationHelper;
import org.eclipse.viatra.query.runtime.emf.EMFBaseIndexWrapper;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;

public class SimpleStateCoder
implements IStateCoder {
    private Set<EClass> classes;
    private Set<EStructuralFeature> features;
    private NavigationHelper navigationHelper;
    private EMFHelper.MetaModelElements metaModelElements;
    private Map<EClass, Map<EObject, String>> objectCodes;
    private int maxDepth;
    private Set<EObject> changedOrNewEObjects = new HashSet<EObject>();
    private Set<EObject> deletedClasses = new HashSet<EObject>();

    public SimpleStateCoder(EMFHelper.MetaModelElements metaModelElements) {
        this.metaModelElements = metaModelElements;
        this.maxDepth = 1;
        this.classes = metaModelElements.classes;
        this.features = new HashSet<EAttribute>(metaModelElements.attributes);
        this.features.addAll(metaModelElements.references);
    }

    @Override
    public void init(Notifier notifier) {
        try {
            EMFScope scope = new EMFScope(notifier);
            ViatraQueryEngine queryEngine = ViatraQueryEngine.on((QueryScope)scope);
            EMFBaseIndexWrapper baseIndex = (EMFBaseIndexWrapper)queryEngine.getBaseIndex();
            this.navigationHelper = baseIndex.getNavigationHelper();
            this.navigationHelper.registerObservedTypes(this.classes, null, this.features);
        }
        catch (ViatraQueryException e) {
            throw new DSEException(e);
        }
        this.objectCodes = new HashMap<EClass, Map<EObject, String>>();
        for (EClass eClass : this.classes) {
            ValueComparableEObjectStringMap codes = new ValueComparableEObjectStringMap();
            this.objectCodes.put(eClass, codes);
            for (EObject eObject : this.navigationHelper.getDirectInstances(eClass)) {
                codes.put(eObject, this.createObjectCodeWithDepth(eObject, this.maxDepth));
            }
        }
        this.navigationHelper.addFeatureListener(this.features, new FeatureListener(){

            public void featureInserted(EObject host, EStructuralFeature feature, Object value) {
                SimpleStateCoder.this.changedOrNewEObjects.add(host);
            }

            public void featureDeleted(EObject host, EStructuralFeature feature, Object value) {
                SimpleStateCoder.this.changedOrNewEObjects.add(host);
                if (value instanceof EObject) {
                    SimpleStateCoder.this.changedOrNewEObjects.add((EObject)value);
                }
            }
        });
        this.navigationHelper.addInstanceListener(this.classes, new InstanceListener(){

            public void instanceInserted(EClass clazz, EObject instance) {
                SimpleStateCoder.this.changedOrNewEObjects.add(instance);
            }

            public void instanceDeleted(EClass clazz, EObject instance) {
                SimpleStateCoder.this.deletedClasses.add(instance);
            }
        });
    }

    private String createObjectCodeWithDepth(EObject eObject, int depth) {
        StringBuilder sb = new StringBuilder();
        EClass eClass = eObject.eClass();
        Set<EAttribute> attributes = this.metaModelElements.attributesOfClass.get(eClass);
        for (EAttribute eAttribute : attributes) {
            Object value = eObject.eGet((EStructuralFeature)eAttribute);
            sb.append(value);
            sb.append(',');
        }
        if (!attributes.isEmpty()) {
            sb.deleteCharAt(sb.length() - 1);
        }
        if (depth > 0) {
            sb.append('-');
            Set<EReference> eReferences = this.metaModelElements.referencesOfClass.get(eClass);
            for (EReference eReference : eReferences) {
                Object value = eObject.eGet((EStructuralFeature)eReference);
                if (value == null) {
                    sb.append("null,");
                    continue;
                }
                if (value instanceof EObject) {
                    sb.append(this.createObjectCodeWithDepth((EObject)value, depth - 1));
                    sb.append(',');
                    continue;
                }
                List referencedEObjects = (List)value;
                if (referencedEObjects.isEmpty()) continue;
                Object[] codes = new String[referencedEObjects.size()];
                int index = 0;
                for (EObject referencedEObject : referencedEObjects) {
                    codes[index++] = this.createObjectCodeWithDepth(referencedEObject, depth - 1);
                }
                Arrays.sort(codes);
                sb.append('(');
                Object[] objectArray = codes;
                int n = codes.length;
                int n2 = 0;
                while (n2 < n) {
                    Object code = objectArray[n2];
                    sb.append((String)code);
                    ++n2;
                }
                sb.append("),");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public Object createStateCode() {
        this.refreshObjectCodes();
        StringBuilder sb = new StringBuilder();
        for (EClass eClass : this.classes) {
            Set instances = this.navigationHelper.getDirectInstances(eClass);
            if (instances.isEmpty()) continue;
            sb.append(eClass.getName());
            sb.append(':');
            Object[] codesToSort = new String[instances.size()];
            int index = 0;
            Map<EObject, String> codes = this.objectCodes.get(eClass);
            for (EObject eObject : instances) {
                codesToSort[index++] = codes.get(eObject);
            }
            Arrays.sort(codesToSort);
            Object[] objectArray = codesToSort;
            int n = codesToSort.length;
            int n2 = 0;
            while (n2 < n) {
                Object string = objectArray[n2];
                sb.append((String)string);
                sb.append(';');
                ++n2;
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append('|');
        }
        if (sb.length() != 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private void refreshObjectCodes() {
        for (EObject eObject : this.deletedClasses) {
            EClass eClass = eObject.eClass();
            this.objectCodes.get(eClass).remove(eObject);
        }
        this.deletedClasses.clear();
        HashSet<EObject> objectsToRecode = new HashSet<EObject>();
        for (EObject eObject : this.changedOrNewEObjects) {
            objectsToRecode.add(eObject);
            for (EStructuralFeature.Setting setting : this.navigationHelper.getInverseReferences(eObject)) {
                objectsToRecode.add(setting.getEObject());
            }
        }
        for (EObject eObject : objectsToRecode) {
            EClass eClass = eObject.eClass();
            this.objectCodes.get(eClass).put(eObject, this.createObjectCodeWithDepth(eObject, this.maxDepth));
        }
        this.changedOrNewEObjects.clear();
    }

    @Override
    public Object createActivationCode(IPatternMatch match) {
        Object param;
        StringBuilder sb = new StringBuilder();
        String[] tokens = match.specification().getFullyQualifiedName().split("\\.");
        sb.append(tokens[tokens.length - 1]);
        sb.append(':');
        int i = 0;
        while ((param = match.get(i)) != null) {
            EObject eObject = (EObject)param;
            EClass eClass = eObject.eClass();
            Set<EAttribute> attributes = this.metaModelElements.attributesOfClass.get(eClass);
            for (EAttribute eAttribute : attributes) {
                Object value = eObject.eGet((EStructuralFeature)eAttribute);
                sb.append(value);
                sb.append(',');
            }
            if (!attributes.isEmpty()) {
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append('|');
            ++i;
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString().intern();
    }
}

