/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.integration.graphiti;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.internal.parts.ContainerShapeEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.viatra.query.runtime.api.IModelConnectorTypeEnum;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.adapters.EMFModelConnector;

public class GraphitiModelConnector
extends EMFModelConnector {
    public GraphitiModelConnector(IEditorPart editorPart) {
        super(editorPart);
    }

    public Notifier getNotifier(IModelConnectorTypeEnum modelConnectorTypeEnum) {
        Notifier result = null;
        if (this.editorPart instanceof DiagramEditor) {
            DiagramEditor diagramEditor;
            PictogramElement[] selectedElements;
            if (IModelConnectorTypeEnum.RESOURCESET.equals((Object)modelConnectorTypeEnum)) {
                DiagramEditor diagramEditor2 = (DiagramEditor)this.editorPart;
                return diagramEditor2.getEditingDomain().getResourceSet();
            }
            if (IModelConnectorTypeEnum.RESOURCE.equals((Object)modelConnectorTypeEnum) && (selectedElements = (diagramEditor = (DiagramEditor)this.editorPart).getSelectedPictogramElements()).length > 0) {
                PictogramElement element = selectedElements[0];
                EObject businessObject = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(element);
                if (businessObject != null) {
                    return businessObject.eResource();
                }
            }
        }
        return result;
    }

    public void showLocation(Object[] locationObjects) {
        TreeSelection preparedSelection = this.prepareSelection(locationObjects);
        this.navigateToElements((IEditorPart)this.getOwner(), (IStructuredSelection)preparedSelection);
        this.workbenchPage.bringToTop(this.getOwner());
    }

    protected TreePath createTreePath(IEditorPart editor, EObject obj) {
        if (editor instanceof DiagramEditor) {
            Diagram diagram = ((DiagramEditor)editor).getDiagramTypeProvider().getDiagram();
            List pictogramElements = Graphiti.getLinkService().getPictogramElements(diagram, obj);
            if (!pictogramElements.isEmpty()) {
                ArrayList<EditPart> parts = new ArrayList<EditPart>();
                for (PictogramElement element : pictogramElements) {
                    EditPart part = this.findEditPart((DiagramEditor)editor, element);
                    if (part == null) continue;
                    parts.add(part);
                }
                return new TreePath(parts.toArray());
            }
        }
        return null;
    }

    private EditPart findEditPart(DiagramEditor editor, PictogramElement element) {
        try {
            Method m = null;
            try {
                m = editor.getClass().getMethod("getEditPartForPictogramElement", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                m = editor.getClass().getMethod("getDiagramBehavior", new Class[0]);
                Class<?> behaviourClass = m.invoke((Object)element, new Object[0]).getClass();
                m = behaviourClass.getMethod("getEditPartForPictogramElement", new Class[0]);
            }
            if (m != null) {
                return (EditPart)m.invoke((Object)this.editorPart, element);
            }
        }
        catch (Exception e) {
            this.logger.log((IStatus)new Status(4, "org.eclipse.viatra.integration.graphiti", "Error while connecting to Graphiti based editor", (Throwable)e));
        }
        return null;
    }

    protected void navigateToElements(IEditorPart editorPart, IStructuredSelection selection) {
        if (editorPart instanceof DiagramEditor) {
            DiagramEditor providerEditor = (DiagramEditor)editorPart;
            providerEditor.getGraphicalViewer().setSelection((ISelection)selection);
        }
    }

    protected Collection<EObject> getSelectedEObjects(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            UnmodifiableIterator selectionIterator = Iterators.filter((Iterator)((IStructuredSelection)selection).iterator(), ContainerShapeEditPart.class);
            return Lists.newArrayList((Iterator)Iterators.filter((Iterator)Iterators.transform((Iterator)selectionIterator, (Function)new Function<ContainerShapeEditPart, EObject>(){

                public EObject apply(ContainerShapeEditPart input) {
                    return Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(input.getPictogramElement());
                }
            }), (Predicate)Predicates.notNull()));
        }
        return super.getSelectedEObjects();
    }
}

