/**
 * Copyright (c) 2010-2012, Mark Czotter, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Mark Czotter - initial API and implementation
 */
package org.eclipse.viatra.query.patternlanguage.emf.jvmmodel;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra.query.patternlanguage.emf.jvmmodel.JavadocInferrer;
import org.eclipse.viatra.query.patternlanguage.emf.util.EMFJvmTypesBuilder;
import org.eclipse.viatra.query.patternlanguage.emf.util.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.viatra.query.patternlanguage.emf.util.IErrorFeedback;
import org.eclipse.viatra.query.patternlanguage.emf.validation.EMFIssueCodes;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Pattern;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Variable;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.xbase.jvmmodel.JvmAnnotationReferenceBuilder;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeReferenceBuilder;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * {@link ViatraQueryMatcher} implementation inferrer.
 * 
 * @author Mark Czotter
 * @noreference
 */
@SuppressWarnings("all")
public class PatternMatcherClassInferrer {
  @Inject
  @Extension
  private EMFJvmTypesBuilder _eMFJvmTypesBuilder;
  
  @Inject
  @Extension
  private EMFPatternLanguageJvmModelInferrerUtil _eMFPatternLanguageJvmModelInferrerUtil;
  
  @Inject
  @Extension
  private JavadocInferrer _javadocInferrer;
  
  @Extension
  private JvmTypeReferenceBuilder builder;
  
  @Extension
  private JvmAnnotationReferenceBuilder annBuilder;
  
  @Inject
  private IErrorFeedback feedback;
  
  public Boolean inferMatcherClassElements(final JvmGenericType matcherClass, final Pattern pattern, final JvmDeclaredType specificationClass, final JvmDeclaredType matchClass, final JvmTypeReferenceBuilder builder, final JvmAnnotationReferenceBuilder annBuilder) {
    boolean _xtrycatchfinallyexpression = false;
    try {
      boolean _xblockexpression = false;
      {
        this.builder = builder;
        this.annBuilder = annBuilder;
        CharSequence _javadocMatcherClass = this._javadocInferrer.javadocMatcherClass(pattern);
        String _string = _javadocMatcherClass.toString();
        this._eMFJvmTypesBuilder.setDocumentation(matcherClass, _string);
        this.inferStaticMethods(matcherClass, pattern);
        this.inferFields(matcherClass, pattern);
        this.inferConstructors(matcherClass, pattern);
        this.inferMethods(matcherClass, pattern, matchClass);
        EList<JvmMember> _members = matcherClass.getMembers();
        JvmTypeReference _typeRef = this.builder.typeRef(matcherClass);
        JvmTypeReference _typeRef_1 = this.builder.typeRef(IQuerySpecification.class, _typeRef);
        final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
          @Override
          public void apply(final JvmOperation it) {
            it.setVisibility(JvmVisibility.PUBLIC);
            it.setStatic(true);
            CharSequence _javadocQuerySpecificationMethod = PatternMatcherClassInferrer.this._javadocInferrer.javadocQuerySpecificationMethod(pattern);
            String _string = _javadocQuerySpecificationMethod.toString();
            PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
            EList<JvmTypeReference> _exceptions = it.getExceptions();
            JvmTypeReference _typeRef = PatternMatcherClassInferrer.this.builder.typeRef(ViatraQueryException.class);
            PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, _typeRef);
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("return ");
                JvmTypeReference _typeRef = PatternMatcherClassInferrer.this.builder.typeRef(specificationClass);
                _builder.append(_typeRef, "");
                _builder.append(".instance();");
                _builder.newLineIfNotEmpty();
              }
            };
            PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
          }
        };
        JvmOperation _method = this._eMFJvmTypesBuilder.toMethod(pattern, "querySpecification", _typeRef_1, _function);
        _xblockexpression = this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
      }
      _xtrycatchfinallyexpression = _xblockexpression;
    } catch (final Throwable _t) {
      if (_t instanceof IllegalStateException) {
        final IllegalStateException ex = (IllegalStateException)_t;
        String _message = ex.getMessage();
        this.feedback.reportError(pattern, _message, EMFIssueCodes.OTHER_ISSUE, Severity.ERROR, 
          IErrorFeedback.JVMINFERENCE_ERROR_TYPE);
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
    return Boolean.valueOf(_xtrycatchfinallyexpression);
  }
  
  /**
   * Infers fields for Matcher class based on the input 'pattern'.
   */
  public boolean inferFields(final JvmDeclaredType matcherClass, final Pattern pattern) {
    boolean _xblockexpression = false;
    {
      EList<Variable> _parameters = pattern.getParameters();
      for (final Variable variable : _parameters) {
        EList<JvmMember> _members = matcherClass.getMembers();
        String _positionConstant = this._eMFPatternLanguageJvmModelInferrerUtil.positionConstant(variable);
        JvmTypeReference _typeRef = this.builder.typeRef(int.class);
        final Procedure1<JvmField> _function = new Procedure1<JvmField>() {
          @Override
          public void apply(final JvmField it) {
            it.setStatic(true);
            it.setFinal(true);
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                EList<Variable> _parameters = pattern.getParameters();
                int _indexOf = _parameters.indexOf(variable);
                _builder.append(_indexOf, "");
              }
            };
            PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setInitializer(it, _client);
          }
        };
        JvmField _field = this._eMFJvmTypesBuilder.toField(pattern, _positionConstant, _typeRef, _function);
        this._eMFJvmTypesBuilder.<JvmField>operator_add(_members, _field);
      }
      EList<JvmMember> _members_1 = matcherClass.getMembers();
      JvmTypeReference _typeRef_1 = this.builder.typeRef(Logger.class);
      final Procedure1<JvmField> _function_1 = new Procedure1<JvmField>() {
        @Override
        public void apply(final JvmField it) {
          it.setStatic(true);
          it.setFinal(true);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append(ViatraQueryLoggingUtil.class, "");
              _builder.append(".getLogger(");
              String _matcherClassName = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.matcherClassName(pattern);
              _builder.append(_matcherClassName, "");
              _builder.append(".class)");
              _builder.newLineIfNotEmpty();
            }
          };
          PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setInitializer(it, _client);
        }
      };
      JvmField _field_1 = this._eMFJvmTypesBuilder.toField(pattern, "LOGGER", _typeRef_1, _function_1);
      _xblockexpression = this._eMFJvmTypesBuilder.<JvmField>operator_add(_members_1, _field_1);
    }
    return _xblockexpression;
  }
  
  /**
   * Infers static methods for Matcher class based on the input 'pattern'.
   * NOTE: queryDefinition() will be inferred later, in EMFPatternLanguageJvmModelInferrer
   */
  public boolean inferStaticMethods(final JvmGenericType matcherClass, final Pattern pattern) {
    boolean _xblockexpression = false;
    {
      EList<JvmMember> _members = matcherClass.getMembers();
      JvmTypeReference _typeRef = this.builder.typeRef(matcherClass);
      final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          it.setStatic(true);
          it.setVisibility(JvmVisibility.PUBLIC);
          CharSequence _javadocMatcherStaticOnEngine = PatternMatcherClassInferrer.this._javadocInferrer.javadocMatcherStaticOnEngine(pattern);
          String _string = _javadocMatcherStaticOnEngine.toString();
          PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
          EList<JvmFormalParameter> _parameters = it.getParameters();
          JvmTypeReference _typeRef = PatternMatcherClassInferrer.this.builder.typeRef(ViatraQueryEngine.class);
          JvmFormalParameter _parameter = PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.toParameter(pattern, "engine", _typeRef);
          PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
          EList<JvmTypeReference> _exceptions = it.getExceptions();
          JvmTypeReference _typeRef_1 = PatternMatcherClassInferrer.this.builder.typeRef(ViatraQueryException.class);
          PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, _typeRef_1);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("// check if matcher already exists");
              _builder.newLine();
              String _simpleName = matcherClass.getSimpleName();
              _builder.append(_simpleName, "");
              _builder.append(" matcher = engine.getExistingMatcher(querySpecification());");
              _builder.newLineIfNotEmpty();
              _builder.append("if (matcher == null) {");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("matcher = (");
              String _simpleName_1 = matcherClass.getSimpleName();
              _builder.append(_simpleName_1, "\t");
              _builder.append(")engine.getMatcher(querySpecification());");
              _builder.newLineIfNotEmpty();
              _builder.append("}");
              _builder.newLine();
              _builder.append("return matcher;");
              _builder.newLine();
            }
          };
          PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
        }
      };
      JvmOperation _method = this._eMFJvmTypesBuilder.toMethod(pattern, "on", _typeRef, _function);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
      EList<JvmMember> _members_1 = matcherClass.getMembers();
      JvmTypeReference _typeRef_1 = this.builder.typeRef(matcherClass);
      final Procedure1<JvmOperation> _function_1 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          it.setStatic(true);
          it.setVisibility(JvmVisibility.PUBLIC);
          CharSequence _javadocMatcherStaticOnEngine = PatternMatcherClassInferrer.this._javadocInferrer.javadocMatcherStaticOnEngine(pattern);
          String _string = _javadocMatcherStaticOnEngine.toString();
          PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
          EList<JvmTypeReference> _exceptions = it.getExceptions();
          JvmTypeReference _typeRef = PatternMatcherClassInferrer.this.builder.typeRef(ViatraQueryException.class);
          PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, _typeRef);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("return new ");
              String _simpleName = matcherClass.getSimpleName();
              _builder.append(_simpleName, "");
              _builder.append("();");
              _builder.newLineIfNotEmpty();
            }
          };
          PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
        }
      };
      JvmOperation _method_1 = this._eMFJvmTypesBuilder.toMethod(pattern, "create", _typeRef_1, _function_1);
      _xblockexpression = this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_1, _method_1);
    }
    return _xblockexpression;
  }
  
  /**
   * Infers constructors for Matcher class based on the input 'pattern'.
   */
  public boolean inferConstructors(final JvmDeclaredType matcherClass, final Pattern pattern) {
    EList<JvmMember> _members = matcherClass.getMembers();
    final Procedure1<JvmConstructor> _function = new Procedure1<JvmConstructor>() {
      @Override
      public void apply(final JvmConstructor it) {
        String _matcherClassName = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.matcherClassName(pattern);
        it.setSimpleName(_matcherClassName);
        it.setVisibility(JvmVisibility.PRIVATE);
        CharSequence _javadocMatcherConstructorEngine = PatternMatcherClassInferrer.this._javadocInferrer.javadocMatcherConstructorEngine(pattern);
        String _string = _javadocMatcherConstructorEngine.toString();
        PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
        EList<JvmTypeReference> _exceptions = it.getExceptions();
        JvmTypeReference _typeRef = PatternMatcherClassInferrer.this.builder.typeRef(ViatraQueryException.class);
        PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, _typeRef);
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("super(querySpecification());");
          }
        };
        PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
      }
    };
    JvmConstructor _constructor = this._eMFJvmTypesBuilder.toConstructor(pattern, _function);
    return this._eMFJvmTypesBuilder.<JvmConstructor>operator_add(_members, _constructor);
  }
  
  /**
   * Infers methods for Matcher class based on the input 'pattern'.
   */
  public boolean inferMethods(final JvmDeclaredType type, final Pattern pattern, final JvmType matchClass) {
    boolean _xblockexpression = false;
    {
      this.builder = this.builder;
      EList<Variable> _parameters = pattern.getParameters();
      boolean _isEmpty = _parameters.isEmpty();
      boolean _not = (!_isEmpty);
      if (_not) {
        EList<JvmMember> _members = type.getMembers();
        JvmTypeReference _typeRef = this.builder.typeRef(matchClass);
        JvmTypeReference _typeRef_1 = this.builder.typeRef(Collection.class, _typeRef);
        final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
          @Override
          public void apply(final JvmOperation it) {
            CharSequence _javadocGetAllMatchesMethod = PatternMatcherClassInferrer.this._javadocInferrer.javadocGetAllMatchesMethod(pattern);
            String _string = _javadocGetAllMatchesMethod.toString();
            PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
            EList<Variable> _parameters = pattern.getParameters();
            for (final Variable parameter : _parameters) {
              EList<JvmFormalParameter> _parameters_1 = it.getParameters();
              String _parameterName = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(parameter);
              JvmTypeReference _calculateType = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(parameter);
              JvmFormalParameter _parameter = PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.toParameter(parameter, _parameterName, _calculateType);
              PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter);
            }
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("return rawGetAllMatches(new Object[]{");
                {
                  EList<Variable> _parameters = pattern.getParameters();
                  boolean _hasElements = false;
                  for(final Variable p : _parameters) {
                    if (!_hasElements) {
                      _hasElements = true;
                    } else {
                      _builder.appendImmediate(", ", "");
                    }
                    String _parameterName = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(p);
                    _builder.append(_parameterName, "");
                  }
                }
                _builder.append("});");
                _builder.newLineIfNotEmpty();
              }
            };
            PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
          }
        };
        JvmOperation _method = this._eMFJvmTypesBuilder.toMethod(pattern, "getAllMatches", _typeRef_1, _function);
        this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
        EList<JvmMember> _members_1 = type.getMembers();
        JvmTypeReference _typeRef_2 = this.builder.typeRef(matchClass);
        final Procedure1<JvmOperation> _function_1 = new Procedure1<JvmOperation>() {
          @Override
          public void apply(final JvmOperation it) {
            CharSequence _javadocGetOneArbitraryMatchMethod = PatternMatcherClassInferrer.this._javadocInferrer.javadocGetOneArbitraryMatchMethod(pattern);
            String _string = _javadocGetOneArbitraryMatchMethod.toString();
            PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
            EList<Variable> _parameters = pattern.getParameters();
            for (final Variable parameter : _parameters) {
              EList<JvmFormalParameter> _parameters_1 = it.getParameters();
              String _parameterName = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(parameter);
              JvmTypeReference _calculateType = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(parameter);
              JvmFormalParameter _parameter = PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.toParameter(parameter, _parameterName, _calculateType);
              PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter);
            }
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("return rawGetOneArbitraryMatch(new Object[]{");
                {
                  EList<Variable> _parameters = pattern.getParameters();
                  boolean _hasElements = false;
                  for(final Variable p : _parameters) {
                    if (!_hasElements) {
                      _hasElements = true;
                    } else {
                      _builder.appendImmediate(", ", "");
                    }
                    String _parameterName = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(p);
                    _builder.append(_parameterName, "");
                  }
                }
                _builder.append("});");
                _builder.newLineIfNotEmpty();
              }
            };
            PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
          }
        };
        JvmOperation _method_1 = this._eMFJvmTypesBuilder.toMethod(pattern, "getOneArbitraryMatch", _typeRef_2, _function_1);
        this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_1, _method_1);
        EList<JvmMember> _members_2 = type.getMembers();
        JvmTypeReference _typeRef_3 = this.builder.typeRef(boolean.class);
        final Procedure1<JvmOperation> _function_2 = new Procedure1<JvmOperation>() {
          @Override
          public void apply(final JvmOperation it) {
            CharSequence _javadocHasMatchMethod = PatternMatcherClassInferrer.this._javadocInferrer.javadocHasMatchMethod(pattern);
            String _string = _javadocHasMatchMethod.toString();
            PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
            EList<Variable> _parameters = pattern.getParameters();
            for (final Variable parameter : _parameters) {
              EList<JvmFormalParameter> _parameters_1 = it.getParameters();
              String _parameterName = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(parameter);
              JvmTypeReference _calculateType = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(parameter);
              JvmFormalParameter _parameter = PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.toParameter(parameter, _parameterName, _calculateType);
              PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter);
            }
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("return rawHasMatch(new Object[]{");
                {
                  EList<Variable> _parameters = pattern.getParameters();
                  boolean _hasElements = false;
                  for(final Variable p : _parameters) {
                    if (!_hasElements) {
                      _hasElements = true;
                    } else {
                      _builder.appendImmediate(", ", "");
                    }
                    String _parameterName = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(p);
                    _builder.append(_parameterName, "");
                  }
                }
                _builder.append("});");
                _builder.newLineIfNotEmpty();
              }
            };
            PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
          }
        };
        JvmOperation _method_2 = this._eMFJvmTypesBuilder.toMethod(pattern, "hasMatch", _typeRef_3, _function_2);
        this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_2, _method_2);
        EList<JvmMember> _members_3 = type.getMembers();
        JvmTypeReference _typeRef_4 = this.builder.typeRef(int.class);
        final Procedure1<JvmOperation> _function_3 = new Procedure1<JvmOperation>() {
          @Override
          public void apply(final JvmOperation it) {
            CharSequence _javadocCountMatchesMethod = PatternMatcherClassInferrer.this._javadocInferrer.javadocCountMatchesMethod(pattern);
            String _string = _javadocCountMatchesMethod.toString();
            PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
            EList<Variable> _parameters = pattern.getParameters();
            for (final Variable parameter : _parameters) {
              EList<JvmFormalParameter> _parameters_1 = it.getParameters();
              String _parameterName = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(parameter);
              JvmTypeReference _calculateType = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(parameter);
              JvmFormalParameter _parameter = PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.toParameter(parameter, _parameterName, _calculateType);
              PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter);
            }
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("return rawCountMatches(new Object[]{");
                {
                  EList<Variable> _parameters = pattern.getParameters();
                  boolean _hasElements = false;
                  for(final Variable p : _parameters) {
                    if (!_hasElements) {
                      _hasElements = true;
                    } else {
                      _builder.appendImmediate(", ", "");
                    }
                    String _parameterName = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(p);
                    _builder.append(_parameterName, "");
                  }
                }
                _builder.append("});");
                _builder.newLineIfNotEmpty();
              }
            };
            PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
          }
        };
        JvmOperation _method_3 = this._eMFJvmTypesBuilder.toMethod(pattern, "countMatches", _typeRef_4, _function_3);
        this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_3, _method_3);
        EList<JvmMember> _members_4 = type.getMembers();
        final Procedure1<JvmOperation> _function_4 = new Procedure1<JvmOperation>() {
          @Override
          public void apply(final JvmOperation it) {
            JvmTypeReference _typeRef = PatternMatcherClassInferrer.this.builder.typeRef(Void.TYPE);
            it.setReturnType(_typeRef);
            CharSequence _javadocForEachMatchMethod = PatternMatcherClassInferrer.this._javadocInferrer.javadocForEachMatchMethod(pattern);
            String _string = _javadocForEachMatchMethod.toString();
            PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
            EList<Variable> _parameters = pattern.getParameters();
            for (final Variable parameter : _parameters) {
              EList<JvmFormalParameter> _parameters_1 = it.getParameters();
              String _parameterName = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(parameter);
              JvmTypeReference _calculateType = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(parameter);
              JvmFormalParameter _parameter = PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.toParameter(parameter, _parameterName, _calculateType);
              PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter);
            }
            EList<JvmFormalParameter> _parameters_2 = it.getParameters();
            JvmTypeReference _typeRef_1 = PatternMatcherClassInferrer.this.builder.typeRef(matchClass);
            JvmTypeReference _wildcardSuper = PatternMatcherClassInferrer.this.builder.wildcardSuper(_typeRef_1);
            JvmTypeReference _typeRef_2 = PatternMatcherClassInferrer.this.builder.typeRef(IMatchProcessor.class, _wildcardSuper);
            JvmFormalParameter _parameter_1 = PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.toParameter(pattern, "processor", _typeRef_2);
            PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_2, _parameter_1);
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("rawForEachMatch(new Object[]{");
                {
                  EList<Variable> _parameters = pattern.getParameters();
                  boolean _hasElements = false;
                  for(final Variable p : _parameters) {
                    if (!_hasElements) {
                      _hasElements = true;
                    } else {
                      _builder.appendImmediate(", ", "");
                    }
                    String _parameterName = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(p);
                    _builder.append(_parameterName, "");
                  }
                }
                _builder.append("}, processor);");
                _builder.newLineIfNotEmpty();
              }
            };
            PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
          }
        };
        JvmOperation _method_4 = this._eMFJvmTypesBuilder.toMethod(pattern, "forEachMatch", null, _function_4);
        this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_4, _method_4);
        EList<JvmMember> _members_5 = type.getMembers();
        JvmTypeReference _typeRef_5 = this.builder.typeRef(boolean.class);
        final Procedure1<JvmOperation> _function_5 = new Procedure1<JvmOperation>() {
          @Override
          public void apply(final JvmOperation it) {
            CharSequence _javadocForOneArbitraryMatchMethod = PatternMatcherClassInferrer.this._javadocInferrer.javadocForOneArbitraryMatchMethod(pattern);
            String _string = _javadocForOneArbitraryMatchMethod.toString();
            PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
            EList<Variable> _parameters = pattern.getParameters();
            for (final Variable parameter : _parameters) {
              EList<JvmFormalParameter> _parameters_1 = it.getParameters();
              String _parameterName = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(parameter);
              JvmTypeReference _calculateType = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(parameter);
              JvmFormalParameter _parameter = PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.toParameter(parameter, _parameterName, _calculateType);
              PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter);
            }
            EList<JvmFormalParameter> _parameters_2 = it.getParameters();
            JvmTypeReference _typeRef = PatternMatcherClassInferrer.this.builder.typeRef(matchClass);
            JvmTypeReference _wildcardSuper = PatternMatcherClassInferrer.this.builder.wildcardSuper(_typeRef);
            JvmTypeReference _typeRef_1 = PatternMatcherClassInferrer.this.builder.typeRef(IMatchProcessor.class, _wildcardSuper);
            JvmFormalParameter _parameter_1 = PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.toParameter(pattern, "processor", _typeRef_1);
            PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_2, _parameter_1);
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("return rawForOneArbitraryMatch(new Object[]{");
                {
                  EList<Variable> _parameters = pattern.getParameters();
                  boolean _hasElements = false;
                  for(final Variable p : _parameters) {
                    if (!_hasElements) {
                      _hasElements = true;
                    } else {
                      _builder.appendImmediate(", ", "");
                    }
                    String _parameterName = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(p);
                    _builder.append(_parameterName, "");
                  }
                }
                _builder.append("}, processor);");
                _builder.newLineIfNotEmpty();
              }
            };
            PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
          }
        };
        JvmOperation _method_5 = this._eMFJvmTypesBuilder.toMethod(pattern, "forOneArbitraryMatch", _typeRef_5, _function_5);
        this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_5, _method_5);
        EList<JvmMember> _members_6 = type.getMembers();
        JvmTypeReference _typeRef_6 = this.builder.typeRef(matchClass);
        final Procedure1<JvmOperation> _function_6 = new Procedure1<JvmOperation>() {
          @Override
          public void apply(final JvmOperation it) {
            CharSequence _javadocNewMatchMethod = PatternMatcherClassInferrer.this._javadocInferrer.javadocNewMatchMethod(pattern);
            String _string = _javadocNewMatchMethod.toString();
            PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
            EList<Variable> _parameters = pattern.getParameters();
            for (final Variable parameter : _parameters) {
              EList<JvmFormalParameter> _parameters_1 = it.getParameters();
              String _parameterName = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(parameter);
              JvmTypeReference _calculateType = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(parameter);
              JvmFormalParameter _parameter = PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.toParameter(parameter, _parameterName, _calculateType);
              PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter);
            }
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("return ");
                JvmTypeReference _typeRef = PatternMatcherClassInferrer.this.builder.typeRef(matchClass);
                _builder.append(_typeRef, "");
                _builder.append(".newMatch(");
                {
                  EList<Variable> _parameters = pattern.getParameters();
                  boolean _hasElements = false;
                  for(final Variable p : _parameters) {
                    if (!_hasElements) {
                      _hasElements = true;
                    } else {
                      _builder.appendImmediate(", ", "");
                    }
                    String _parameterName = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(p);
                    _builder.append(_parameterName, "");
                  }
                }
                _builder.append(");");
                _builder.newLineIfNotEmpty();
              }
            };
            PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
          }
        };
        JvmOperation _method_6 = this._eMFJvmTypesBuilder.toMethod(pattern, "newMatch", _typeRef_6, _function_6);
        this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_6, _method_6);
        EList<Variable> _parameters_1 = pattern.getParameters();
        for (final Variable variable : _parameters_1) {
          {
            final JvmTypeReference typeOfVariable = this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(variable);
            EList<JvmMember> _members_7 = type.getMembers();
            String _name = variable.getName();
            String _plus = ("rawAccumulateAllValuesOf" + _name);
            JvmTypeReference _typeRef_7 = this.builder.typeRef(Set.class, typeOfVariable);
            final Procedure1<JvmOperation> _function_7 = new Procedure1<JvmOperation>() {
              @Override
              public void apply(final JvmOperation it) {
                CharSequence _javadocGetAllValuesOfMethod = PatternMatcherClassInferrer.this._javadocInferrer.javadocGetAllValuesOfMethod(variable);
                String _string = _javadocGetAllValuesOfMethod.toString();
                PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
                EList<JvmFormalParameter> _parameters = it.getParameters();
                JvmTypeReference _typeRef = PatternMatcherClassInferrer.this.builder.typeRef(Object.class);
                JvmTypeReference _addArrayTypeDimension = PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.addArrayTypeDimension(_typeRef);
                JvmFormalParameter _parameter = PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.toParameter(variable, "parameters", _addArrayTypeDimension);
                PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
                it.setVisibility(JvmVisibility.PROTECTED);
                StringConcatenationClient _client = new StringConcatenationClient() {
                  @Override
                  protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append(Set.class, "");
                    _builder.append("<");
                    _builder.append(typeOfVariable, "");
                    _builder.append("> results = new ");
                    _builder.append(HashSet.class, "");
                    _builder.append("<");
                    _builder.append(typeOfVariable, "");
                    _builder.append(">();");
                    _builder.newLineIfNotEmpty();
                    _builder.append("rawAccumulateAllValues(");
                    String _positionConstant = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.positionConstant(variable);
                    _builder.append(_positionConstant, "");
                    _builder.append(", parameters, results);");
                    _builder.newLineIfNotEmpty();
                    _builder.append("return results;");
                    _builder.newLine();
                  }
                };
                PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
              }
            };
            JvmOperation _method_7 = this._eMFJvmTypesBuilder.toMethod(variable, _plus, _typeRef_7, _function_7);
            this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_7, _method_7);
            EList<JvmMember> _members_8 = type.getMembers();
            String _name_1 = variable.getName();
            String _plus_1 = ("getAllValuesOf" + _name_1);
            JvmTypeReference _typeRef_8 = this.builder.typeRef(Set.class, typeOfVariable);
            final Procedure1<JvmOperation> _function_8 = new Procedure1<JvmOperation>() {
              @Override
              public void apply(final JvmOperation it) {
                CharSequence _javadocGetAllValuesOfMethod = PatternMatcherClassInferrer.this._javadocInferrer.javadocGetAllValuesOfMethod(variable);
                String _string = _javadocGetAllValuesOfMethod.toString();
                PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
                StringConcatenationClient _client = new StringConcatenationClient() {
                  @Override
                  protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append("return rawAccumulateAllValuesOf");
                    String _name = variable.getName();
                    _builder.append(_name, "");
                    _builder.append("(emptyArray());");
                    _builder.newLineIfNotEmpty();
                  }
                };
                PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
              }
            };
            JvmOperation _method_8 = this._eMFJvmTypesBuilder.toMethod(pattern, _plus_1, _typeRef_8, _function_8);
            this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_8, _method_8);
            EList<Variable> _parameters_2 = pattern.getParameters();
            int _size = _parameters_2.size();
            boolean _greaterThan = (_size > 1);
            if (_greaterThan) {
              EList<JvmMember> _members_9 = type.getMembers();
              String _name_2 = variable.getName();
              String _plus_2 = ("getAllValuesOf" + _name_2);
              JvmTypeReference _typeRef_9 = this.builder.typeRef(Set.class, typeOfVariable);
              final Procedure1<JvmOperation> _function_9 = new Procedure1<JvmOperation>() {
                @Override
                public void apply(final JvmOperation it) {
                  CharSequence _javadocGetAllValuesOfMethod = PatternMatcherClassInferrer.this._javadocInferrer.javadocGetAllValuesOfMethod(variable);
                  String _string = _javadocGetAllValuesOfMethod.toString();
                  PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
                  EList<JvmFormalParameter> _parameters = it.getParameters();
                  JvmTypeReference _typeRef = PatternMatcherClassInferrer.this.builder.typeRef(matchClass);
                  JvmFormalParameter _parameter = PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.toParameter(pattern, "partialMatch", _typeRef);
                  PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
                  StringConcatenationClient _client = new StringConcatenationClient() {
                    @Override
                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                      _builder.append("return rawAccumulateAllValuesOf");
                      String _name = variable.getName();
                      _builder.append(_name, "");
                      _builder.append("(partialMatch.toArray());");
                      _builder.newLineIfNotEmpty();
                    }
                  };
                  PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
                }
              };
              JvmOperation _method_9 = this._eMFJvmTypesBuilder.toMethod(variable, _plus_2, _typeRef_9, _function_9);
              this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_9, _method_9);
              EList<JvmMember> _members_10 = type.getMembers();
              String _name_3 = variable.getName();
              String _plus_3 = ("getAllValuesOf" + _name_3);
              JvmTypeReference _typeRef_10 = this.builder.typeRef(Set.class, typeOfVariable);
              final Procedure1<JvmOperation> _function_10 = new Procedure1<JvmOperation>() {
                @Override
                public void apply(final JvmOperation it) {
                  CharSequence _javadocGetAllValuesOfMethod = PatternMatcherClassInferrer.this._javadocInferrer.javadocGetAllValuesOfMethod(variable);
                  String _string = _javadocGetAllValuesOfMethod.toString();
                  PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
                  EList<Variable> _parameters = pattern.getParameters();
                  for (final Variable parameter : _parameters) {
                    boolean _notEquals = (!Objects.equal(parameter, variable));
                    if (_notEquals) {
                      EList<JvmFormalParameter> _parameters_1 = it.getParameters();
                      String _parameterName = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(parameter);
                      JvmTypeReference _calculateType = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(parameter);
                      JvmFormalParameter _parameter = PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.toParameter(parameter, _parameterName, _calculateType);
                      PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter);
                    }
                  }
                  StringConcatenationClient _client = new StringConcatenationClient() {
                    @Override
                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                      _builder.append("return rawAccumulateAllValuesOf");
                      String _name = variable.getName();
                      _builder.append(_name, "");
                      _builder.append("(new Object[]{");
                      _builder.newLineIfNotEmpty();
                      {
                        EList<Variable> _parameters = pattern.getParameters();
                        boolean _hasElements = false;
                        for(final Variable p : _parameters) {
                          if (!_hasElements) {
                            _hasElements = true;
                          } else {
                            _builder.appendImmediate(", ", "");
                          }
                          String _xifexpression = null;
                          String _parameterName = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(p);
                          String _parameterName_1 = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(variable);
                          boolean _equals = Objects.equal(_parameterName, _parameterName_1);
                          if (_equals) {
                            _xifexpression = "null";
                          } else {
                            _xifexpression = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(p);
                          }
                          _builder.append(_xifexpression, "");
                          _builder.newLineIfNotEmpty();
                        }
                      }
                      _builder.append("});");
                      _builder.newLineIfNotEmpty();
                    }
                  };
                  PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
                }
              };
              JvmOperation _method_10 = this._eMFJvmTypesBuilder.toMethod(variable, _plus_3, _typeRef_10, _function_10);
              this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_10, _method_10);
            }
          }
        }
      } else {
        EList<JvmMember> _members_7 = type.getMembers();
        JvmTypeReference _typeRef_7 = this.builder.typeRef(boolean.class);
        final Procedure1<JvmOperation> _function_7 = new Procedure1<JvmOperation>() {
          @Override
          public void apply(final JvmOperation it) {
            CharSequence _javadocHasMatchMethodNoParameter = PatternMatcherClassInferrer.this._javadocInferrer.javadocHasMatchMethodNoParameter(pattern);
            String _string = _javadocHasMatchMethodNoParameter.toString();
            PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("return rawHasMatch(new Object[]{});");
              }
            };
            PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
          }
        };
        JvmOperation _method_7 = this._eMFJvmTypesBuilder.toMethod(pattern, "hasMatch", _typeRef_7, _function_7);
        this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_7, _method_7);
      }
      _xblockexpression = this.inferMatcherClassToMatchMethods(type, pattern, matchClass);
    }
    return _xblockexpression;
  }
  
  /**
   * Infers tupleToMatch, arrayToMatch methods for Matcher class based on the input 'pattern'.
   */
  public boolean inferMatcherClassToMatchMethods(final JvmDeclaredType matcherClass, final Pattern pattern, final JvmType matchClass) {
    boolean _xblockexpression = false;
    {
      JvmTypeReference _typeRef = this.builder.typeRef(matchClass);
      final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotationRef = PatternMatcherClassInferrer.this.annBuilder.annotationRef(Override.class);
          PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
          it.setVisibility(JvmVisibility.PROTECTED);
          EList<JvmFormalParameter> _parameters = it.getParameters();
          JvmTypeReference _typeRef = PatternMatcherClassInferrer.this.builder.typeRef(Tuple.class);
          JvmFormalParameter _parameter = PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.toParameter(pattern, "t", _typeRef);
          PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
        }
      };
      final JvmOperation tupleToMatchMethod = this._eMFJvmTypesBuilder.toMethod(pattern, "tupleToMatch", _typeRef, _function);
      JvmTypeReference _typeRef_1 = this.builder.typeRef(matchClass);
      final Procedure1<JvmOperation> _function_1 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotationRef = PatternMatcherClassInferrer.this.annBuilder.annotationRef(Override.class);
          PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
          it.setVisibility(JvmVisibility.PROTECTED);
          EList<JvmFormalParameter> _parameters = it.getParameters();
          JvmTypeReference _typeRef = PatternMatcherClassInferrer.this.builder.typeRef(Object.class);
          JvmTypeReference _addArrayTypeDimension = PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.addArrayTypeDimension(_typeRef);
          JvmFormalParameter _parameter = PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.toParameter(pattern, "match", _addArrayTypeDimension);
          PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
        }
      };
      final JvmOperation arrayToMatchMethod = this._eMFJvmTypesBuilder.toMethod(pattern, "arrayToMatch", _typeRef_1, _function_1);
      JvmTypeReference _typeRef_2 = this.builder.typeRef(matchClass);
      final Procedure1<JvmOperation> _function_2 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotationRef = PatternMatcherClassInferrer.this.annBuilder.annotationRef(Override.class);
          PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
          it.setVisibility(JvmVisibility.PROTECTED);
          EList<JvmFormalParameter> _parameters = it.getParameters();
          JvmTypeReference _typeRef = PatternMatcherClassInferrer.this.builder.typeRef(Object.class);
          JvmTypeReference _addArrayTypeDimension = PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.addArrayTypeDimension(_typeRef);
          JvmFormalParameter _parameter = PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.toParameter(pattern, "match", _addArrayTypeDimension);
          PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
        }
      };
      final JvmOperation arrayToMatchMutableMethod = this._eMFJvmTypesBuilder.toMethod(pattern, "arrayToMatchMutable", _typeRef_2, _function_2);
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          StringConcatenationClient _inferTupleToMatchMethodBody = PatternMatcherClassInferrer.this.inferTupleToMatchMethodBody(pattern);
          _builder.append(_inferTupleToMatchMethodBody, "");
        }
      };
      this._eMFJvmTypesBuilder.setBody(tupleToMatchMethod, _client);
      StringConcatenationClient _client_1 = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          StringConcatenationClient _inferArrayToMatchMethodBody = PatternMatcherClassInferrer.this.inferArrayToMatchMethodBody(pattern);
          _builder.append(_inferArrayToMatchMethodBody, "");
        }
      };
      this._eMFJvmTypesBuilder.setBody(arrayToMatchMethod, _client_1);
      StringConcatenationClient _client_2 = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          StringConcatenationClient _inferArrayToMatchMutableMethodBody = PatternMatcherClassInferrer.this.inferArrayToMatchMutableMethodBody(pattern);
          _builder.append(_inferArrayToMatchMutableMethodBody, "");
        }
      };
      this._eMFJvmTypesBuilder.setBody(arrayToMatchMutableMethod, _client_2);
      EList<JvmMember> _members = matcherClass.getMembers();
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members, tupleToMatchMethod);
      EList<JvmMember> _members_1 = matcherClass.getMembers();
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_1, arrayToMatchMethod);
      EList<JvmMember> _members_2 = matcherClass.getMembers();
      _xblockexpression = this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_2, arrayToMatchMutableMethod);
    }
    return _xblockexpression;
  }
  
  /**
   * Infers the tupleToMatch method body.
   */
  public StringConcatenationClient inferTupleToMatchMethodBody(final Pattern pattern) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return ");
        String _matchClassName = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.matchClassName(pattern);
        _builder.append(_matchClassName, "\t");
        _builder.append(".newMatch(");
        {
          EList<Variable> _parameters = pattern.getParameters();
          boolean _hasElements = false;
          for(final Variable p : _parameters) {
            if (!_hasElements) {
              _hasElements = true;
            } else {
              _builder.appendImmediate(", ", "\t");
            }
            _builder.append("(");
            JvmTypeReference _calculateType = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(p);
            JvmType _type = _calculateType.getType();
            _builder.append(_type, "\t");
            _builder.append(") t.get(");
            String _positionConstant = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.positionConstant(p);
            _builder.append(_positionConstant, "\t");
            _builder.append(")");
          }
        }
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("} catch(ClassCastException e) {");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _inferErrorLogging = PatternMatcherClassInferrer.this.inferErrorLogging("Element(s) in tuple not properly typed!", "e");
        _builder.append(_inferErrorLogging, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    };
    return _client;
  }
  
  /**
   * Infers the arrayToMatch method body.
   */
  public StringConcatenationClient inferArrayToMatchMethodBody(final Pattern pattern) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return ");
        String _matchClassName = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.matchClassName(pattern);
        _builder.append(_matchClassName, "\t");
        _builder.append(".newMatch(");
        {
          EList<Variable> _parameters = pattern.getParameters();
          boolean _hasElements = false;
          for(final Variable p : _parameters) {
            if (!_hasElements) {
              _hasElements = true;
            } else {
              _builder.appendImmediate(", ", "\t");
            }
            _builder.append("(");
            JvmTypeReference _calculateType = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(p);
            JvmType _type = _calculateType.getType();
            _builder.append(_type, "\t");
            _builder.append(") match[");
            String _positionConstant = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.positionConstant(p);
            _builder.append(_positionConstant, "\t");
            _builder.append("]");
          }
        }
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("} catch(ClassCastException e) {");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _inferErrorLogging = PatternMatcherClassInferrer.this.inferErrorLogging("Element(s) in array not properly typed!", "e");
        _builder.append(_inferErrorLogging, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    };
    return _client;
  }
  
  /**
   * Infers the arrayToMatch method body.
   */
  public StringConcatenationClient inferArrayToMatchMutableMethodBody(final Pattern pattern) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return ");
        String _matchClassName = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.matchClassName(pattern);
        _builder.append(_matchClassName, "\t");
        _builder.append(".newMutableMatch(");
        {
          EList<Variable> _parameters = pattern.getParameters();
          boolean _hasElements = false;
          for(final Variable p : _parameters) {
            if (!_hasElements) {
              _hasElements = true;
            } else {
              _builder.appendImmediate(", ", "\t");
            }
            _builder.append("(");
            JvmTypeReference _calculateType = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(p);
            JvmType _type = _calculateType.getType();
            _builder.append(_type, "\t");
            _builder.append(") match[");
            String _positionConstant = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.positionConstant(p);
            _builder.append(_positionConstant, "\t");
            _builder.append("]");
          }
        }
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("} catch(ClassCastException e) {");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _inferErrorLogging = PatternMatcherClassInferrer.this.inferErrorLogging("Element(s) in array not properly typed!", "e");
        _builder.append(_inferErrorLogging, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    };
    return _client;
  }
  
  /**
   * Infers the appropriate logging based on the parameters.
   */
  public CharSequence inferErrorLogging(final String message, final String exceptionName) {
    CharSequence _xifexpression = null;
    boolean _equals = Objects.equal(exceptionName, null);
    if (_equals) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("LOGGER.error(\"");
      _builder.append(message, "");
      _builder.append("\");");
      _xifexpression = _builder;
    } else {
      StringConcatenation _builder_1 = new StringConcatenation();
      _builder_1.append("LOGGER.error(\"");
      _builder_1.append(message, "");
      _builder_1.append("\",");
      _builder_1.append(exceptionName, "");
      _builder_1.append(");");
      _xifexpression = _builder_1;
    }
    return _xifexpression;
  }
}
