/**
 * Copyright (c) 2010-2016, Zoltan Ujhelyi, IncQuery Labs Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Zoltan Ujhelyi - initial API and implementation
 */
package org.eclipse.viatra.query.patternlanguage.emf.types;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Arrays;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra.query.patternlanguage.emf.eMFPatternLanguage.EClassifierConstraint;
import org.eclipse.viatra.query.patternlanguage.emf.eMFPatternLanguage.EnumValue;
import org.eclipse.viatra.query.patternlanguage.emf.types.EMFTypeSystem;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.AggregatedValue;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.BoolValue;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.CheckConstraint;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.CompareConstraint;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.DoubleValue;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.EntityType;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Expression;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.FunctionEvaluationValue;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.IntValue;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.ListValue;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.PathExpressionConstraint;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Pattern;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.PatternCompositionConstraint;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.StringValue;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.TypeCheckConstraint;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.VariableReference;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.VariableValue;
import org.eclipse.viatra.query.patternlanguage.typing.PatternLanguageTypeRules;
import org.eclipse.viatra.query.patternlanguage.typing.TypeInformation;
import org.eclipse.viatra.query.patternlanguage.typing.judgements.TypeJudgement;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;

/**
 * @author Zoltan Ujhelyi
 * @since 1.3
 */
@SuppressWarnings("all")
public class EMFPatternLanguageTypeRules extends PatternLanguageTypeRules {
  @Inject
  private EMFTypeSystem typeSystem;
  
  protected void _inferTypes(final EClassifierConstraint constraint, final TypeInformation information) {
    EntityType _type = constraint.getType();
    boolean _isValidType = this.typeSystem.isValidType(_type);
    if (_isValidType) {
      EntityType _type_1 = constraint.getType();
      final IInputKey type = this.typeSystem.extractTypeDescriptor(_type_1);
      VariableReference _var = constraint.getVar();
      TypeJudgement _typeJudgement = new TypeJudgement(_var, type);
      information.provideType(_typeJudgement);
    }
  }
  
  protected void _inferTypes(final EnumValue reference, final TypeInformation information) {
    EEnum _enumeration = reference.getEnumeration();
    boolean _equals = Objects.equal(_enumeration, null);
    if (_equals) {
      return;
    }
    EEnumLiteral _literal = reference.getLiteral();
    EEnum _eEnum = _literal.getEEnum();
    final IInputKey type = this.typeSystem.classifierToInputKey(_eEnum);
    TypeJudgement _typeJudgement = new TypeJudgement(reference, type);
    information.provideType(_typeJudgement);
  }
  
  public void inferTypes(final EObject reference, final TypeInformation information) {
    if (reference instanceof AggregatedValue) {
      _inferTypes((AggregatedValue)reference, information);
      return;
    } else if (reference instanceof BoolValue) {
      _inferTypes((BoolValue)reference, information);
      return;
    } else if (reference instanceof DoubleValue) {
      _inferTypes((DoubleValue)reference, information);
      return;
    } else if (reference instanceof FunctionEvaluationValue) {
      _inferTypes((FunctionEvaluationValue)reference, information);
      return;
    } else if (reference instanceof IntValue) {
      _inferTypes((IntValue)reference, information);
      return;
    } else if (reference instanceof ListValue) {
      _inferTypes((ListValue)reference, information);
      return;
    } else if (reference instanceof StringValue) {
      _inferTypes((StringValue)reference, information);
      return;
    } else if (reference instanceof EnumValue) {
      _inferTypes((EnumValue)reference, information);
      return;
    } else if (reference instanceof VariableValue) {
      _inferTypes((VariableValue)reference, information);
      return;
    } else if (reference instanceof EClassifierConstraint) {
      _inferTypes((EClassifierConstraint)reference, information);
      return;
    } else if (reference instanceof CheckConstraint) {
      _inferTypes((CheckConstraint)reference, information);
      return;
    } else if (reference instanceof CompareConstraint) {
      _inferTypes((CompareConstraint)reference, information);
      return;
    } else if (reference instanceof PathExpressionConstraint) {
      _inferTypes((PathExpressionConstraint)reference, information);
      return;
    } else if (reference instanceof PatternCompositionConstraint) {
      _inferTypes((PatternCompositionConstraint)reference, information);
      return;
    } else if (reference instanceof TypeCheckConstraint) {
      _inferTypes((TypeCheckConstraint)reference, information);
      return;
    } else if (reference instanceof Expression) {
      _inferTypes((Expression)reference, information);
      return;
    } else if (reference instanceof Pattern) {
      _inferTypes((Pattern)reference, information);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(reference, information).toString());
    }
  }
}
