/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.patternlanguage.emf.ui.builder;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Pattern;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

public class OldVersionHelper {
    Map<URI, Resource> resourceMap = Maps.newHashMap();
    Map<IPath, URI> copiedURIMap = Maps.newHashMap();
    Map<IProject, ResourceSet> resourceSetMap = Maps.newHashMap();
    @Inject
    private IWorkspaceRoot workspaceRoot;
    @Inject
    private IResourceSetProvider provider;

    private ResourceSet getResourceSet(IProject project) {
        if (!this.resourceSetMap.containsKey(project)) {
            ResourceSet set = this.provider.get(project);
            this.resourceSetMap.put(project, set);
            return set;
        }
        return this.resourceSetMap.get(project);
    }

    private URI getCopiedURI(IProject project, IPath relativePath) throws JavaModelException {
        try {
            if (!this.copiedURIMap.containsKey(relativePath)) {
                URI copiedURI;
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IClasspathEntry sourceEntry = (IClasspathEntry)Iterators.find((Iterator)Iterators.forArray((Object[])javaProject.getResolvedClasspath(true)), (Predicate)new SourceFolderFinder(relativePath));
                IPath outputLocation = sourceEntry.getOutputLocation();
                if (outputLocation == null) {
                    outputLocation = javaProject.getOutputLocation();
                }
                IPath path = outputLocation.append(relativePath.makeRelativeTo(sourceEntry.getPath()));
                URI uRI = copiedURI = project.getWorkspace().getRoot().findMember(path) != null ? URI.createPlatformResourceURI((String)path.toString(), (boolean)true) : null;
                if (copiedURI != null) {
                    this.copiedURIMap.put(relativePath, copiedURI);
                }
                return copiedURI;
            }
            return this.copiedURIMap.get(relativePath);
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public Pattern findPattern(URI proxyURI) throws JavaModelException {
        Path absolutePath = new Path(proxyURI.toPlatformString(true));
        if (absolutePath.segmentCount() == 0) {
            return null;
        }
        IProject project = this.workspaceRoot.getProject(absolutePath.segment(0).toString());
        ResourceSet set = this.getResourceSet(project);
        URI copiedURI = this.getCopiedURI(project, (IPath)absolutePath);
        if (copiedURI != null) {
            Resource res = set.getResource(copiedURI, true);
            String fragment = proxyURI.fragment();
            return (Pattern)res.getEObject(fragment);
        }
        return null;
    }

    public static final class SourceFolderFinder
    implements Predicate<IClasspathEntry> {
        private final IPath relativePath;

        private SourceFolderFinder(IPath relativePath) {
            this.relativePath = relativePath;
        }

        public boolean apply(IClasspathEntry entry) {
            boolean isSourceEntry;
            if (entry == null) {
                return false;
            }
            boolean bl = isSourceEntry = entry.getContentKind() == 1;
            if (isSourceEntry) {
                return entry.getPath().isPrefixOf(this.relativePath);
            }
            return false;
        }
    }
}

