/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.patternlanguage.emf.ui.contentassist;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguageScopeHelper;
import org.eclipse.viatra.query.patternlanguage.emf.ResolutionException;
import org.eclipse.viatra.query.patternlanguage.emf.eMFPatternLanguage.ClassType;
import org.eclipse.viatra.query.patternlanguage.emf.eMFPatternLanguage.EMFPatternLanguagePackage;
import org.eclipse.viatra.query.patternlanguage.emf.eMFPatternLanguage.PackageImport;
import org.eclipse.viatra.query.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.viatra.query.patternlanguage.emf.helper.EMFPatternLanguageHelper;
import org.eclipse.viatra.query.patternlanguage.emf.services.EMFPatternLanguageGrammarAccess;
import org.eclipse.viatra.query.patternlanguage.emf.ui.contentassist.AbstractEMFPatternLanguageProposalProvider;
import org.eclipse.viatra.query.patternlanguage.emf.ui.contentassist.ClassifierPrefixMatcher;
import org.eclipse.viatra.query.patternlanguage.emf.ui.contentassist.EnumPrefixMatcher;
import org.eclipse.viatra.query.patternlanguage.emf.ui.contentassist.PatternImporter;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.PathExpressionElement;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.PathExpressionHead;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Pattern;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.PatternBody;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.PatternCall;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Variable;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.ui.editor.contentassist.AbstractJavaBasedContentProposalProvider;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;
import org.eclipse.xtext.xbase.ui.hover.XbaseInformationControlInput;

public class EMFPatternLanguageProposalProvider
extends AbstractEMFPatternLanguageProposalProvider {
    private static final Set<String> FILTERED_KEYWORDS = Sets.newHashSet((Object[])new String[]{"pattern"});
    @Inject
    IScopeProvider scopeProvider;
    @Inject
    AbstractJavaBasedContentProposalProvider.ReferenceProposalCreator crossReferenceProposalCreator;
    @Inject
    IQualifiedNameConverter nameConverter;
    @Inject
    private EMFPatternLanguageGrammarAccess ga;

    public void createProposals(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (context.getCurrentNode().getGrammarElement() == this.ga.getML_COMMENTRule() || context.getCurrentNode().getGrammarElement() == this.ga.getSL_COMMENTRule()) {
            return;
        }
        super.createProposals(context, acceptor);
    }

    protected Function<IEObjectDescription, ICompletionProposal> getProposalFactory(String ruleName, ContentAssistContext contentAssistContext) {
        Function factory = super.getProposalFactory(ruleName, contentAssistContext);
        if (contentAssistContext.getCurrentNode().getSemanticElement() instanceof PatternCall && this.ga.getQualifiedNameRule().getName().equals(ruleName)) {
            factory = Functions.compose((Function)new Function<ICompletionProposal, ICompletionProposal>(){

                public ICompletionProposal apply(ICompletionProposal original) {
                    XbaseInformationControlInput input;
                    ConfigurableCompletionProposal prop;
                    Object info;
                    if (original instanceof ConfigurableCompletionProposal && (info = (prop = (ConfigurableCompletionProposal)original).getAdditionalProposalInfo((IProgressMonitor)new NullProgressMonitor())) instanceof XbaseInformationControlInput && (input = (XbaseInformationControlInput)info).getElement() instanceof Pattern) {
                        Pattern pattern = (Pattern)input.getElement();
                        prop.setTextApplier((ConfigurableCompletionProposal.IReplacementTextApplier)new PatternImporter(pattern));
                    }
                    return original;
                }
            }, (Function)factory);
        }
        return factory;
    }

    public void completeKeyword(Keyword keyword, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        if (FILTERED_KEYWORDS.contains(keyword.getValue())) {
            return;
        }
        super.completeKeyword(keyword, contentAssistContext, acceptor);
    }

    public void complete_ValueReference(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_ValueReference(model, ruleCall, context, acceptor);
        if (model instanceof PathExpressionHead) {
            PathExpressionHead head = (PathExpressionHead)model;
            try {
                EClassifier typeClassifier = EMFPatternLanguageScopeHelper.calculateExpressionType((PathExpressionHead)head);
                if (typeClassifier instanceof EEnum) {
                    EEnum type = (EEnum)typeClassifier;
                    ContentAssistContext.Builder myContextBuilder = context.copy();
                    myContextBuilder.setMatcher((PrefixMatcher)new EnumPrefixMatcher(type.getName()));
                    for (Iterator literal : type.getELiterals()) {
                        ICompletionProposal completionProposal = this.createCompletionProposal("::" + literal.getName(), String.valueOf(type.getName()) + "::" + literal.getName(), null, myContextBuilder.toContext());
                        acceptor.accept(completionProposal);
                    }
                }
                PatternBody body = (PatternBody)head.eContainer().eContainer();
                for (Variable var : body.getVariables()) {
                    acceptor.accept(this.createCompletionProposal(var.getName(), context));
                }
                Pattern pattern = (Pattern)body.eContainer();
                for (Variable var : pattern.getParameters()) {
                    acceptor.accept(this.createCompletionProposal(var.getName(), context));
                }
            }
            catch (ResolutionException resolutionException) {}
        }
    }

    public void completeType_Typename(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        PatternModel pModel = null;
        EObject root = EcoreUtil.getRootContainer((EObject)model);
        if (root instanceof PatternModel) {
            pModel = (PatternModel)root;
        }
        ContentAssistContext.Builder myContextBuilder = context.copy();
        myContextBuilder.setMatcher((PrefixMatcher)new ClassifierPrefixMatcher(context.getMatcher(), this.getQualifiedNameConverter()));
        ClassType type = null;
        if (!(model instanceof Variable)) {
            return;
        }
        type = (ClassType)((Variable)model).getType();
        ICompositeNode node = NodeModelUtils.getNode((EObject)type);
        int offset = node.getOffset();
        Region replaceRegion = new Region(offset, context.getReplaceRegion().getLength() + context.getReplaceRegion().getOffset() - offset);
        myContextBuilder.setReplaceRegion(replaceRegion);
        myContextBuilder.setLastCompleteNode((INode)node);
        StringBuilder availablePrefix = new StringBuilder(4);
        for (ILeafNode leaf : node.getLeafNodes()) {
            if (leaf.getGrammarElement() != null && !leaf.isHidden()) {
                if (leaf.getTotalLength() + leaf.getTotalOffset() < context.getOffset()) {
                    availablePrefix.append(leaf.getText());
                } else {
                    availablePrefix.append(leaf.getText().substring(0, context.getOffset() - leaf.getTotalOffset()));
                }
            }
            if (leaf.getTotalOffset() < context.getOffset()) continue;
        }
        myContextBuilder.setPrefix(availablePrefix.toString());
        ContentAssistContext myContext = myContextBuilder.toContext();
        for (PackageImport declaration : EMFPatternLanguageHelper.getPackageImportsIterable((PatternModel)pModel)) {
            if (declaration.getEPackage() == null) continue;
            this.createClassifierProposals(declaration, model, myContext, acceptor);
        }
    }

    private void createClassifierProposals(PackageImport declaration, EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean createDatatypeProposals = this.modelOrContainerIs(model, Variable.class);
        boolean createEnumProposals = this.modelOrContainerIs(model, EnumRule.class);
        boolean createClassProposals = this.modelOrContainerIs(model, Variable.class);
        Function<IEObjectDescription, ICompletionProposal> factory = this.getProposalFactory(null, context);
        for (EClassifier classifier : declaration.getEPackage().getEClassifiers()) {
            if (!(classifier instanceof EDataType && createDatatypeProposals || classifier instanceof EEnum && createEnumProposals) && (!(classifier instanceof EClass) || !createClassProposals)) continue;
            String classifierName = this.getValueConverter().toString((Object)classifier.getName(), "ID");
            QualifiedName proposalQualifiedName = QualifiedName.create((String)classifierName);
            IEObjectDescription description = EObjectDescription.create((QualifiedName)proposalQualifiedName, (EObject)classifier);
            ConfigurableCompletionProposal proposal = (ConfigurableCompletionProposal)factory.apply((Object)description);
            if (proposal != null) {
                proposal.setPriority(proposal.getPriority() * 2);
            }
            acceptor.accept((ICompletionProposal)proposal);
        }
    }

    private boolean modelOrContainerIs(EObject model, Class<?> ... types) {
        Class<?>[] classArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> type = classArray[n2];
            if (type.isInstance(model) || type.isInstance(model.eContainer())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void complete_RefType(PathExpressionElement model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        IScope scope = this.scopeProvider.getScope((EObject)model.getTail(), EMFPatternLanguagePackage.Literals.REFERENCE_TYPE__REFNAME);
        this.crossReferenceProposalCreator.lookupCrossReference(scope, (EObject)model, EMFPatternLanguagePackage.Literals.REFERENCE_TYPE__REFNAME, acceptor, Predicates.alwaysTrue(), this.getProposalFactory(ruleCall.getRule().getName(), context));
    }

    @Override
    public void completeRefType_Refname(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
    }
}

